/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.MergeIterator;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.UniqueIterator;
import org.w3c.dom.Node;

public abstract class AbstractPattern {
    protected static WriteStream dbg = LogStream.open("/caucho.com/xpath/pattern");
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    protected AbstractPattern parent;
    protected AbstractPattern child;

    AbstractPattern(AbstractPattern parent) {
        this.parent = parent;
        if (parent != null && parent.child == null) {
            parent.child = this;
        }
    }

    public AbstractPattern getParent() {
        return this.parent;
    }

    public double getPriority() {
        return 0.5;
    }

    public String getNodeName() {
        return "*";
    }

    public NodeIterator select(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        if (this.isStrictlyAscending()) {
            return base;
        }
        return new MergeIterator(env, base);
    }

    public NodeIterator selectUnique(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        if (this.isUnique()) {
            return base;
        }
        return new UniqueIterator(env, base);
    }

    public Node findAny(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        return base.nextNode();
    }

    public boolean isStrictlyAscending() {
        if (this.parent != null) {
            return this.parent.isStrictlyAscending();
        }
        return false;
    }

    public boolean isUnique() {
        if (this.parent != null) {
            return this.parent.isUnique();
        }
        return false;
    }

    boolean isSingleSelect() {
        if (this.parent != null) {
            return this.parent.isSingleSelect();
        }
        return false;
    }

    boolean isSingleLevel() {
        return this.isSingleSelect();
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern pattern) throws XPathException {
        if (this.parent == null) {
            throw new RuntimeException(String.valueOf(this) + " " + this.getClass());
        }
        return this.parent.createNodeIterator(node, env, pattern);
    }

    public Node firstNode(Node node, ExprEnvironment env) throws XPathException {
        throw new UnsupportedOperationException(String.valueOf(this) + " " + this.getClass());
    }

    public Node lastNode(Node node) {
        return null;
    }

    public Node nextNode(Node node, Node last) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean match(Node var1, ExprEnvironment var2) throws XPathException;

    public boolean isAscending() {
        return true;
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        return this.parent.position(node, env, pattern);
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        return this.parent.count(node, env, pattern);
    }

    public AbstractPattern copyAxis() {
        if (this.parent != null) {
            return this.parent.copyAxis();
        }
        return null;
    }

    public AbstractPattern copyPosition() {
        return this;
    }

    protected String getPrefix() {
        if (this.parent == null || this.parent instanceof FromAny) {
            return "";
        }
        if (this.parent instanceof FromContext) {
            FromContext context = (FromContext)this.parent;
            String name = "";
            for (int i = 0; i < context.getCount(); ++i) {
                name = name + "../";
            }
            return name;
        }
        if (this.parent instanceof FromRoot) {
            return "/";
        }
        return this.parent + "/";
    }

    public String toPatternString() {
        return this.toString();
    }
}

