/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class AxisIterator
extends NodeIterator {
    protected NodeIterator parentIter;
    protected AbstractPattern axis;
    protected Node node;
    protected Node next;
    protected Node lastNode;
    protected AbstractPattern match;

    protected AxisIterator(ExprEnvironment env) {
        super(env);
    }

    public AxisIterator(NodeIterator parentIter, AbstractPattern axis, Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this.parentIter = parentIter;
        this.axis = axis;
        this.match = match;
        if (parentIter != null) {
            node = parentIter.nextNode();
        }
        if (node != null) {
            this.lastNode = axis.lastNode(node);
            this.node = this.findFirstMatchingNode(axis.firstNode(node, env));
        }
        this.next = this.node;
    }

    public boolean hasNext() {
        block3: {
            if (this.next == null) {
                try {
                    this.next = this.nextNode();
                }
                catch (XPathException e) {
                    if (!dbg.canWrite()) break block3;
                    dbg.log(e);
                }
            }
        }
        return this.next != null;
    }

    public Node nextNode() throws XPathException {
        if (this.next != null) {
            this.node = this.next;
            this.next = null;
            return this.node;
        }
        if (this.node != null) {
            this.node = this.findFirstMatchingNode(this.axis.nextNode(this.node, this.lastNode));
        }
        this.next = null;
        return this.node;
    }

    private Node findFirstMatchingNode(Node node) throws XPathException {
        while (true) {
            if (node != null) {
                if (this.match == null || this.match.match(node, this.env)) {
                    ++this.position;
                    return node;
                }
                node = this.axis.nextNode(node, this.lastNode);
                continue;
            }
            if (this.parentIter == null || (node = this.parentIter.nextNode()) == null) {
                return null;
            }
            this.position = 0;
            this.size = 0;
            this.lastNode = this.axis.lastNode(node);
            node = this.axis.firstNode(node, this.env);
        }
    }

    public int getContextSize() {
        block5: {
            if (this.size == 0) {
                this.size = this.position;
                try {
                    Node ptr;
                    Node node = ptr = this.node == null ? null : this.axis.nextNode(this.node, this.lastNode);
                    while (ptr != null) {
                        if (this.match == null || this.match.match(ptr, this.env)) {
                            ++this.size;
                        }
                        ptr = this.axis.nextNode(ptr, this.lastNode);
                    }
                }
                catch (XPathException e) {
                    if (!dbg.canWrite()) break block5;
                    dbg.log(e);
                }
            }
        }
        return this.size;
    }

    public Object clone() {
        AxisIterator iter = new AxisIterator(this.env);
        iter.copy(this);
        if (this.parentIter != null) {
            iter.parentIter = (NodeIterator)this.parentIter.clone();
        }
        iter.axis = this.axis;
        iter.node = this.node;
        iter.match = this.match;
        return iter;
    }

    public String toString() {
        return "[AxisIterator " + this.axis + " " + this.match + "]";
    }
}

