/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QElement;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.AttributeIterator;
import com.caucho.xpath.pattern.AttributeListIterator;
import com.caucho.xpath.pattern.Axis;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FromAttributes
extends Axis {
    public FromAttributes(AbstractPattern parent) {
        super(parent);
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (!(node instanceof Attr)) {
            return false;
        }
        if (node instanceof QAttr && ((QAttr)node).getNamespaceURI() == "http://www.w3.org/2000/xmlns/") {
            return false;
        }
        return this.parent == null || this.parent.match(node.getParentNode(), env);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int count = 1;
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int count = 0;
        CauchoElement parent = (CauchoElement)node.getParentNode();
        for (node = parent.getFirstAttribute(); node != null; node = node.getNextSibling()) {
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        if (node instanceof CauchoNode) {
            if (this.parent == null) {
                return new AttributeIterator(null, this, node, env, match);
            }
            if (this.parent instanceof FromRoot) {
                if (node instanceof Document) {
                    return new AttributeIterator(null, this, node, env, match);
                }
                return new AttributeIterator(null, this, node.getOwnerDocument(), env, match);
            }
            NodeIterator parentIter = this.parent.createNodeIterator(node, env, this.parent.copyPosition());
            return new AttributeIterator(parentIter, this, null, env, match);
        }
        if (this.parent == null) {
            return new AttributeListIterator(null, env, match);
        }
        if (this.parent instanceof FromRoot) {
            if (node instanceof Document) {
                return new AttributeListIterator(null, env, match);
            }
            return new AttributeListIterator(null, env, match);
        }
        NodeIterator parentIter = this.parent.createNodeIterator(node, env, this.parent.copyPosition());
        return new AttributeListIterator(parentIter, env, match);
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        if (node instanceof QElement) {
            return ((QElement)node).getFirstAttribute();
        }
        return null;
    }

    public Node nextNode(Node node, Node lastNode) {
        return node.getNextSibling();
    }

    public boolean isStrictlyAscending() {
        if (this.parent == null) {
            return true;
        }
        return this.parent.isStrictlyAscending();
    }

    public boolean equals(Object b) {
        if (!(b instanceof FromAttributes)) {
            return false;
        }
        FromAttributes bPattern = (FromAttributes)b;
        return this.parent == bPattern.parent || this.parent != null && this.parent.equals(bPattern.parent);
    }

    public String toString() {
        return this.getPrefix() + "attribute::";
    }
}

