/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.SelectedNode;
import org.w3c.dom.Node;

public class MergeIterator
extends NodeIterator {
    private NodeIterator baseIterator;
    private SelectedNode[] nodes = new SelectedNode[32];
    private int head;
    private int tail;

    public MergeIterator(ExprEnvironment env, NodeIterator baseIterator) throws XPathException {
        super(env);
        SelectedNode node;
        this.baseIterator = baseIterator;
        block0: while ((node = baseIterator.nextSelectedNode()) != null) {
            int ptr;
            SelectedNode oldNode;
            int cmp;
            int index;
            if (this.tail == this.nodes.length) {
                SelectedNode[] newNodes = new SelectedNode[2 * this.nodes.length];
                System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
                this.nodes = newNodes;
            }
            for (index = this.tail; index > 0 && (cmp = node.compareTo(oldNode = this.nodes[index - 1])) <= 0; --index) {
                if (cmp == 0) continue block0;
            }
            ++this.tail;
            while (ptr > index) {
                this.nodes[ptr] = this.nodes[ptr - 1];
                --ptr;
            }
            this.nodes[index] = node;
        }
    }

    public boolean hasNext() {
        return this.head < this.tail;
    }

    public Node nextNode() {
        if (this.head < this.tail) {
            this.position = this.head + 1;
            return this.nodes[this.head++].getNode();
        }
        return null;
    }

    public SelectedNode nextSelectedNode() {
        if (this.head < this.tail) {
            this.position = this.head + 1;
            return this.nodes[this.head++];
        }
        return null;
    }

    public Object clone() {
        try {
            MergeIterator clone = new MergeIterator(this.env, this.baseIterator);
            clone.head = this.head;
            clone.tail = this.tail;
            if (this.nodes.length != clone.nodes.length) {
                clone.nodes = new SelectedNode[this.nodes.length];
            }
            System.arraycopy(this.nodes, 0, clone.nodes, 0, this.tail);
            return clone;
        }
        catch (Exception e) {
            if (dbg.canWrite()) {
                dbg.log(e);
            }
            return null;
        }
    }
}

