/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NamespaceNode;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.SelectedAttribute;
import com.caucho.xpath.pattern.SelectedNode;
import org.w3c.dom.Node;

public class NamespaceIterator
extends NodeIterator {
    protected NodeIterator parentIter;
    protected AbstractPattern match;
    protected NamespaceNode node;
    protected NamespaceNode next;

    protected NamespaceIterator(ExprEnvironment env) {
        super(env);
    }

    public NamespaceIterator(Node node, NodeIterator parentIter, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this.parentIter = parentIter;
        this.match = match;
        if (parentIter == null) {
            this.node = NamespaceNode.create(node);
        }
        this.next = this.node = this.findFirstMatchingNode();
    }

    public boolean hasNext() {
        block3: {
            if (this.next == null) {
                try {
                    this.next = (NamespaceNode)this.nextNode();
                }
                catch (XPathException e) {
                    if (!dbg.canWrite()) break block3;
                    dbg.log(e);
                }
            }
        }
        return this.next != null;
    }

    public Node nextNode() throws XPathException {
        if (this.next != null) {
            this.node = this.next;
            this.next = null;
            return this.node;
        }
        if (this.node != null) {
            this.node = (NamespaceNode)this.node.getNextSibling();
            this.node = this.findFirstMatchingNode();
        }
        this.next = null;
        return this.node;
    }

    public SelectedNode nextSelectedNode() throws XPathException {
        Node node = this.nextNode();
        return node == null ? null : new SelectedAttribute(node);
    }

    private NamespaceNode findFirstMatchingNode() throws XPathException {
        while (true) {
            Node parentNode;
            if (this.node != null) {
                if (this.match == null || this.match.match(this.node, this.env)) {
                    ++this.position;
                    return this.node;
                }
                this.node = (NamespaceNode)this.node.getNextSibling();
                continue;
            }
            if (this.parentIter == null || (parentNode = this.parentIter.nextNode()) == null) {
                return null;
            }
            this.position = 0;
            this.size = 0;
            this.node = NamespaceNode.create(parentNode);
        }
    }

    public int getContextSize() {
        return this.position;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        return "[NamespaceIterator " + this.match + "]";
    }
}

