/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.StylesheetEnv;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.SelectedAttribute;
import com.caucho.xpath.pattern.SelectedNode;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class NodeIterator
implements ExprEnvironment,
Iterator {
    protected static WriteStream dbg = LogStream.open("/caucho.com/xpath/pattern");
    protected ExprEnvironment env;
    protected Node contextNode;
    protected int position;
    protected int size;

    protected NodeIterator(ExprEnvironment env) {
        if (env == null) {
            throw new NullPointerException();
        }
        this.env = env;
    }

    public abstract boolean hasNext();

    public abstract Node nextNode() throws XPathException;

    public Object next() {
        Node value;
        block2: {
            value = null;
            try {
                value = this.nextNode();
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block2;
                dbg.log(e);
            }
        }
        return value;
    }

    public SelectedNode nextSelectedNode() throws XPathException {
        Node node = this.nextNode();
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            return new SelectedAttribute(node);
        }
        return new SelectedNode(node);
    }

    public Node getCurrentNode() {
        return this.env.getCurrentNode();
    }

    public Node getContextNode() {
        if (this.contextNode != null) {
            return this.contextNode;
        }
        return this.env.getContextNode();
    }

    public Node setContextNode(Node node) {
        Node oldNode = this.contextNode;
        this.contextNode = node;
        return oldNode;
    }

    public int getContextPosition() {
        return this.position;
    }

    public int getContextSize() {
        if (this.size == 0) {
            this.size = this.position;
            NodeIterator clone = (NodeIterator)this.clone();
            try {
                while (clone != null && clone.nextNode() != null) {
                    ++this.size;
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.size;
    }

    public Document getOwnerDocument() {
        return this.env.getOwnerDocument();
    }

    public Var getVar(String name) {
        return this.env.getVar(name);
    }

    public XPathFun getFunction(String name) {
        return this.env.getFunction(name);
    }

    public StylesheetEnv getStylesheetEnv() {
        return this.env.getStylesheetEnv();
    }

    public Object systemProperty(String namespaceURI, String localName) {
        return this.env.getOwnerDocument();
    }

    public String stringValue(Node node) {
        return XmlUtil.textValue(node);
    }

    public int getPositionIndex() {
        return 0;
    }

    public void setMorePositions(boolean more) {
    }

    public abstract Object clone();

    public void copy(NodeIterator src) {
        this.env = src.env;
        this.position = src.position;
        this.size = src.size;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

