/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Node;

public class UnionIterator
extends NodeIterator {
    private NodeIterator leftIter;
    private NodeIterator rightIter;
    private Node node;

    public UnionIterator(ExprEnvironment env, NodeIterator leftIter, NodeIterator rightIter) throws XPathException {
        super(env);
        this.leftIter = leftIter;
        this.rightIter = rightIter;
        this.node = leftIter.nextNode();
        if (this.node == null) {
            leftIter = null;
            this.node = rightIter.nextNode();
        }
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Node nextNode() throws XPathException {
        Node next = this.node;
        if (next == null) {
            return null;
        }
        if (this.leftIter != null) {
            this.node = this.leftIter.nextNode();
            if (this.node == null) {
                this.leftIter = null;
                this.node = this.rightIter.nextNode();
            }
        } else {
            this.node = this.rightIter.nextNode();
        }
        return next;
    }

    public Object clone() {
        try {
            UnionIterator clone = new UnionIterator(this.env, (NodeIterator)this.leftIter.clone(), (NodeIterator)this.rightIter.clone());
            clone.node = this.node;
            clone.position = this.position;
            return clone;
        }
        catch (Exception e) {
            if (dbg.canWrite()) {
                dbg.log(e);
            }
            return null;
        }
    }
}

