/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.UnionIterator;
import org.w3c.dom.Node;

public class UnionPattern
extends AbstractPattern {
    private AbstractPattern left;
    private AbstractPattern right;

    public UnionPattern(AbstractPattern left, AbstractPattern right) {
        super(null);
        if (right.getParent() instanceof FromAttributes && left.getParent() instanceof FromChildren) {
            this.left = right;
            this.right = left;
        } else {
            this.left = left;
            this.right = right;
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        return this.left.match(node, env) || this.right.match(node, env);
    }

    public boolean isStrictlyAscending() {
        return this.left.getParent() instanceof FromAttributes && this.right.getParent() instanceof FromChildren;
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern match) throws XPathException {
        NodeIterator leftIter = this.left.createNodeIterator(node, env, this.left.copyPosition());
        NodeIterator rightIter = this.right.createNodeIterator(node, env, this.right.copyPosition());
        return new UnionIterator(env, leftIter, rightIter);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this.select(node, env);
        int i = 1;
        while (iter.hasNext()) {
            if (iter.next() == node) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        NodeIterator iter = this.select(node, env);
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public AbstractPattern getLeft() {
        return this.left;
    }

    public AbstractPattern getRight() {
        return this.right;
    }

    public String toString() {
        return this.left.toString() + "|" + this.right.toString();
    }
}

