/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaCompiler;
import com.caucho.transform.Stylesheet;
import com.caucho.transform.StylesheetFactory;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import com.caucho.xsl.Generator;
import com.caucho.xsl.IdentityStylesheet;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.SAXFilterImpl;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TemplatesHandlerImpl;
import com.caucho.xsl.TransformerConfigurationExceptionWrapper;
import com.caucho.xsl.TransformerHandlerImpl;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XmlStylesheetReader;
import com.caucho.xsl.XslParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Random;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public abstract class AbstractStylesheetFactory
extends SAXTransformerFactory
implements StylesheetFactory {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/generate");
    static L10N L = new L10N(class$com$caucho$xsl$AbstractStylesheetFactory == null ? (class$com$caucho$xsl$AbstractStylesheetFactory = AbstractStylesheetFactory.class$("com.caucho.xsl.AbstractStylesheetFactory")) : class$com$caucho$xsl$AbstractStylesheetFactory);
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private String systemId;
    private Path workPath = CauchoSystem.getWorkPath();
    private Path stylePath;
    private Path scriptPath;
    private ClassLoader loader;
    private String className;
    private boolean isAutoCompile = true;
    private boolean loadPrecompiledStylesheet = true;
    static /* synthetic */ Class class$com$caucho$xsl$AbstractStylesheetFactory;

    protected AbstractStylesheetFactory() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public void setAttribute(String name, Object value) {
    }

    public boolean getFeature(String name) {
        return name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature") || name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter") || name.equals("http://javax.xml.transform.dom.DOMResult/feature") || name.equals("http://javax.xml.transform.dom.DOMSource/feature") || name.equals("http://javax.xml.transform.sax.SAXResult/feature") || name.equals("http://javax.xml.transform.sax.SAXSource/feature") || name.equals("http://javax.xml.transform.stream.StreamResult/feature") || name.equals("http://javax.xml.transform.stream.StreamSource/feature");
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setStylePath(Path path) {
        this.stylePath = path;
    }

    public Path getStylePath() {
        if (this.stylePath != null) {
            return this.stylePath;
        }
        return this.getSearchPath();
    }

    public void setSearchPath(Path path) {
        this.stylePath = path;
    }

    public Path getSearchPath() {
        if (this.stylePath != null) {
            return this.stylePath;
        }
        return Vfs.lookup(".");
    }

    public void setScriptPath(Path path) {
        this.scriptPath = path;
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    public void setWorkPath(Path path) {
        this.workPath = path;
    }

    public Path getWorkPath() {
        return this.workPath;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean getLoadPrecompiledStylesheet() {
        return this.loadPrecompiledStylesheet;
    }

    public void setLoadPrecompiledStylesheet(boolean preload) {
        this.loadPrecompiledStylesheet = preload;
    }

    public boolean isAutoCompile() {
        return this.isAutoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this.isAutoCompile = autoCompile;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        try {
            XmlStylesheetReader reader = new XmlStylesheetReader();
            this.parseSAX(source, reader);
            String href = reader.getAssociatedStylesheet(media, title, charset);
            if (href == null) {
                return null;
            }
            String base = source.getSystemId();
            return this.getSource(href, base);
        }
        catch (Exception e) {
            throw new TransformerConfigurationException(e);
        }
    }

    private Source getSource(String href, String base) throws Exception {
        Path subpath;
        if (href == null) {
            href = "";
        }
        if (base == null) {
            base = "/";
        }
        if (this.uriResolver != null) {
            subpath = href.startsWith("/") || base.equals("/") ? this.getSearchPath().lookup(href) : this.getSearchPath().lookup(base).getParent().lookup(href);
            Source source = this.uriResolver.resolve(href, base);
            if (source != null) {
                if (source.getSystemId() == null) {
                    source.setSystemId(subpath.getURL());
                }
                return source;
            }
        }
        if (href.startsWith("/") || base.equals("/")) {
            subpath = this.getSearchPath().lookup(href);
        } else {
            if (base.startsWith("file:")) {
                base = base.substring(5);
            }
            subpath = this.getSearchPath().lookup(base).getParent().lookup(href);
        }
        return new StreamSource(subpath.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSAX(Source source, ContentHandler handler) throws TransformerConfigurationException {
        block8: {
            try {
                if (source instanceof SAXSource) {
                    SAXSource saxSource = (SAXSource)source;
                    XMLReader reader = saxSource.getXMLReader();
                    InputSource inputSource = saxSource.getInputSource();
                    reader.setContentHandler(handler);
                    reader.parse(inputSource);
                    break block8;
                }
                if (source instanceof StreamSource) {
                    Xml parser = new Xml();
                    parser.setContentHandler(handler);
                    ReadStream rs = this.openPath(source);
                    try {
                        parser.parse(rs);
                        break block8;
                    }
                    finally {
                        rs.close();
                    }
                }
                if (source instanceof DOMSource) {
                    DOMSource domSource = (DOMSource)source;
                    Node node = domSource.getNode();
                    XmlUtil.toSAX(node, handler);
                }
            }
            catch (Exception e) {
                throw new TransformerConfigurationException(e);
            }
        }
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(new IdentityStylesheet());
    }

    public Stylesheet newStylesheet(Document xsl) throws Exception {
        return (Stylesheet)((Object)this.generate(xsl, null));
    }

    public Stylesheet newStylesheet(Reader reader) throws Exception {
        ReadStream rs = Vfs.openRead(reader);
        return (Stylesheet)((Object)this.generate(this.parseXSL(rs), rs.getPath()));
    }

    public Stylesheet newStylesheet(InputStream is) throws Exception {
        ReadStream rs = Vfs.openRead(is);
        return (Stylesheet)((Object)this.generate(this.parseXSL(rs), rs.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stylesheet newStylesheet(String systemId) throws Exception {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
        if (stylesheet != null) {
            return stylesheet;
        }
        ReadStream is = this.stylePath != null ? this.stylePath.lookup(systemId).openRead() : Vfs.lookup(systemId).openRead();
        try {
            Stylesheet stylesheet2 = this.newStylesheet(is);
            return stylesheet2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stylesheet newStylesheet(Path path) throws Exception {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(path.getFullPath(), path.getUserPath());
        if (stylesheet != null) {
            return stylesheet;
        }
        Class clazz = class$com$caucho$xsl$AbstractStylesheetFactory == null ? (class$com$caucho$xsl$AbstractStylesheetFactory = AbstractStylesheetFactory.class$("com.caucho.xsl.AbstractStylesheetFactory")) : class$com$caucho$xsl$AbstractStylesheetFactory;
        synchronized (clazz) {
            Stylesheet stylesheet2;
            stylesheet = this.loadPrecompiledStylesheet(this.systemId, this.systemId);
            if (stylesheet != null) {
                return stylesheet;
            }
            Path oldStylePath = this.stylePath;
            this.stylePath = path;
            ReadStream is = null;
            try {
                is = path.openRead();
                stylesheet2 = this.newStylesheet(is);
                Object var8_7 = null;
                this.stylePath = oldStylePath;
                if (is == null) return stylesheet2;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.stylePath = oldStylePath;
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return stylesheet2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        String systemId = source.getSystemId();
        try {
            Templates templates;
            block14: {
                StylesheetImpl stylesheet;
                if (systemId != null && (stylesheet = this.loadPrecompiledStylesheet(systemId, systemId)) != null) {
                    return stylesheet;
                }
                if (source instanceof DOMSource) {
                    Node node = ((DOMSource)source).getNode();
                    return this.generate(node, systemId == null ? null : Vfs.lookup(systemId));
                }
                if (source instanceof SAXSource) {
                    SAXSource saxSource = (SAXSource)source;
                    XMLReader reader = saxSource.getXMLReader();
                    InputSource inputSource = saxSource.getInputSource();
                    QDocument doc = new QDocument();
                    if (inputSource != null) {
                        DOMBuilder builder = new DOMBuilder();
                        builder.init(doc);
                        reader.setContentHandler(builder);
                    }
                    reader.parse(inputSource);
                    return this.generate(doc, null);
                }
                ReadStream rs = this.openPath(source);
                if (rs == null) {
                    return this.generate(new QDocument(), null);
                }
                try {
                    Path path = rs.getPath();
                    templates = this.generate(this.parseXSL(rs), path);
                    Object var9_12 = null;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return templates;
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XslParseException(e);
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return this.newTransformerHandler(new StylesheetImpl());
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTemplates(source));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return new TransformerHandlerImpl(templates.newTransformer());
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        return new SAXFilterImpl((TransformerImpl)templates.newTransformer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node parseStylesheet(Source source) throws TransformerConfigurationException {
        Document document;
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        if (!(source instanceof StreamSource)) return null;
        InputStream is = ((StreamSource)source).getInputStream();
        ReadStream rs = null;
        try {
            try {
                rs = Vfs.openRead(is);
                document = this.parseXSL(rs);
                Object var6_6 = null;
                if (rs == null) return document;
            }
            catch (Exception e) {
                throw new TransformerConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return document;
        }
        rs.close();
        return document;
    }

    public Templates newTemplates(Node node) throws TransformerConfigurationException {
        DocumentType dtd;
        Document doc = node.getOwnerDocument();
        if (node instanceof Document) {
            doc = (Document)node;
        }
        if ((dtd = doc.getDoctype()) != null && dtd.getSystemId() != null) {
            return this.generate(node, this.getSearchPath().lookup(dtd.getSystemId()));
        }
        if (doc instanceof CauchoDocument) {
            String systemId = ((CauchoDocument)doc).getFilename();
            return this.generate(node, this.getSearchPath().lookup(systemId));
        }
        return this.generate(node, null);
    }

    public Templates newTemplates(String systemId) throws TransformerConfigurationException {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
        if (stylesheet != null) {
            return stylesheet;
        }
        Class clazz = class$com$caucho$xsl$AbstractStylesheetFactory == null ? (class$com$caucho$xsl$AbstractStylesheetFactory = AbstractStylesheetFactory.class$("com.caucho.xsl.AbstractStylesheetFactory")) : class$com$caucho$xsl$AbstractStylesheetFactory;
        synchronized (clazz) {
            stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
            if (stylesheet != null) {
                return stylesheet;
            }
            Path path = this.getSearchPath().lookup(systemId);
            try {
                ReadStream is = path.openRead();
                Document doc = this.parseXSL(is);
                is.close();
                return this.generate(doc, path);
            }
            catch (TransformerConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransformerConfigurationExceptionWrapper(e);
            }
        }
    }

    ReadStream openPath(String href, String base) throws TransformerException, IOException {
        Path subpath;
        if (this.uriResolver != null) {
            subpath = href.startsWith("/") || base.equals("/") ? this.getSearchPath().lookup(href) : this.getSearchPath().lookup(base).getParent().lookup(href);
            Source source = this.uriResolver.resolve(href, base);
            if (source != null) {
                if (source.getSystemId() == null) {
                    source.setSystemId(subpath.getURL());
                }
                return this.openPath(source);
            }
        }
        if (base.startsWith("string:") || base.startsWith("error:")) {
            base = "/";
        }
        if (href.startsWith("/") || base.equals("/")) {
            subpath = this.getSearchPath().lookup(href);
        } else {
            if (base.startsWith("file:")) {
                base = base.substring(5);
            }
            subpath = this.getSearchPath().lookup(base).getParent().lookup(href);
        }
        return subpath.openRead();
    }

    ReadStream openPath(Source source) throws TransformerException, IOException {
        String systemId = source.getSystemId();
        Path path = systemId != null ? this.getSearchPath().lookup(systemId) : this.getSearchPath().lookup("caucho_anonymous.xsl");
        if (source instanceof StreamSource) {
            StreamSource stream = (StreamSource)source;
            InputStream is = stream.getInputStream();
            if (is instanceof ReadStream) {
                return (ReadStream)is;
            }
            if (is != null) {
                ReadStream rs = Vfs.openRead(is);
                rs.setPath(path);
                return rs;
            }
            Reader reader = stream.getReader();
            if (reader != null) {
                ReadStream rs = Vfs.openRead(reader);
                rs.setPath(path);
                return rs;
            }
        }
        if (systemId != null) {
            return this.getSearchPath().lookup(systemId).openRead();
        }
        return null;
    }

    Path lookupPath(String base, String href) throws TransformerException {
        String systemId;
        Source source;
        if (this.uriResolver != null && (source = this.uriResolver.resolve(href, base)) != null && (systemId = source.getSystemId()) != null) {
            return this.getSearchPath().lookup(systemId);
        }
        return this.getSearchPath().lookup(base).lookup(href);
    }

    public Transformer newTransformer(Document xsl) throws TransformerConfigurationException {
        return this.newTemplates(xsl).newTransformer();
    }

    public void transform(Document xsl, Node xml, OutputStream out) throws Exception {
        TransformerImpl transformer = (TransformerImpl)this.newTransformer(xsl);
        transformer.transform(xml, out);
    }

    public void transform(String xsl, Node xml, OutputStream out) throws Exception {
        TransformerImpl transformer = (TransformerImpl)this.newTemplates(xsl).newTransformer();
        transformer.transform(xml, out);
    }

    protected abstract Document parseXSL(ReadStream var1) throws TransformerConfigurationException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Templates generate(Node xsl, Path path) throws TransformerConfigurationException {
        Class clazz = class$com$caucho$xsl$AbstractStylesheetFactory == null ? (class$com$caucho$xsl$AbstractStylesheetFactory = AbstractStylesheetFactory.class$("com.caucho.xsl.AbstractStylesheetFactory")) : class$com$caucho$xsl$AbstractStylesheetFactory;
        synchronized (clazz) {
            Generator gen = null;
            try {
                try {
                    String filename;
                    if (path == null && xsl != null) {
                        Document doc = xsl.getOwnerDocument();
                        if (doc == null && xsl instanceof Document) {
                            doc = (Document)xsl;
                        }
                        DocumentType dtd = doc.getDoctype();
                        String systemId = null;
                        if (dtd != null) {
                            systemId = dtd.getSystemId();
                        }
                        if (systemId != null) {
                            path = this.getStylePath().lookup(systemId);
                        }
                    }
                    if (path == null && xsl instanceof CauchoNode && (filename = ((CauchoNode)xsl).getFilename()) != null) {
                        path = this.getStylePath().lookup(filename);
                    }
                    if (path == null) {
                        path = this.getStylePath().lookup("anonymous.xsl");
                    }
                    Path stylePath = path.getParent();
                    Expr expr = XPath.parseExpr("//xtp:directive.page/@language");
                    String language = expr.evalString(xsl);
                    String userName = path.getUserPath();
                    String mangledName = this.getMangledName(userName);
                    String encoding = XPath.evalString("//xsl:output/@encoding", xsl);
                    if (encoding != null && encoding.equals("")) {
                        encoding = null;
                    }
                    if (language != null && !language.equals("")) {
                        if (!language.equals("java")) throw new XslParseException(L.l("unsupported language `{0}'", language));
                    }
                    language = "java";
                    gen = new JavaGenerator(this, mangledName, encoding);
                    gen.setPath(path);
                    Iterator iter = XPath.select("//xtp:directive.page/@*", xsl);
                    while (iter.hasNext()) {
                        Attr attr = (Attr)iter.next();
                        String name = attr.getNodeName();
                        String value = attr.getNodeValue();
                        if (name.equals("errorPage")) {
                            gen.setErrorPage(value);
                            continue;
                        }
                        if (name.equals("import")) {
                            gen.addImport(value);
                            continue;
                        }
                        if (name.equals("contentType")) {
                            gen.setContentType(value);
                            continue;
                        }
                        if (name.equals("language")) {
                            if (language.equalsIgnoreCase(value)) continue;
                            throw new XslParseException(L.l("mismatched language `{0}'", value));
                        }
                        if (!name.equals("xml:space")) throw new XslParseException(L.l("unknown directive `{0}'", name));
                    }
                    StylesheetImpl stylesheet = gen.generate(xsl);
                    gen = null;
                    stylesheet.init(path);
                    stylesheet.setURIResolver(this.uriResolver);
                    StylesheetImpl stylesheetImpl = stylesheet;
                    Object var16_17 = null;
                    try {
                        if (gen == null) return stylesheetImpl;
                        gen.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return stylesheetImpl;
                }
                catch (TransformerConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XslParseException(e);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {}
                catch (IOException e) {
                    throw throwable;
                }
                if (gen == null) throw throwable;
                gen.close();
                throw throwable;
            }
        }
    }

    private String getMangledName(String userName) {
        String name = null;
        if (userName == null || userName.equals("anonymous.xsl") || userName.equals("string") || userName.equals("stream")) {
            userName = "x" + (new Random().nextInt() & 0x3FF) + ".xsl";
        }
        name = this.getClassName() == null ? userName : this.getClassName();
        name = name.startsWith("/") ? "xsl" + name : "xsl/" + name;
        return JavaCompiler.mangleName(name);
    }

    StylesheetImpl loadPrecompiledStylesheet(String systemId, String userId) {
        if (!this.loadPrecompiledStylesheet) {
            return null;
        }
        try {
            StylesheetImpl stylesheet = this.loadStylesheet(systemId, this.getMangledName(userId));
            if (!(stylesheet == null || this.isAutoCompile && stylesheet.isModified())) {
                stylesheet.setURIResolver(this.uriResolver);
                return stylesheet;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected StylesheetImpl loadStylesheet(String systemId, String className) throws Exception {
        Path classPath = this.workPath.lookup(className.replace('.', '/') + ".class");
        if (!classPath.canRead()) {
            throw new ClassNotFoundException("can't find compiled XSL `" + className + "'");
        }
        SimpleClassLoader loader = SimpleClassLoader.create(this.loader, this.workPath, className);
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(className, false, loader);
        }
        catch (Error e) {
            block7: {
                try {
                    classPath.remove();
                }
                catch (IOException e1) {
                    if (!dbg.canWrite()) break block7;
                    dbg.log(e1);
                }
            }
            throw e;
        }
        StylesheetImpl stylesheet = (StylesheetImpl)cl.newInstance();
        if (this.stylePath != null) {
            Path path = this.stylePath.lookup(systemId);
        } else {
            Path path = Vfs.lookup(systemId);
        }
        stylesheet.init(this.getStylePath());
        stylesheet.setURIResolver(this.uriResolver);
        return stylesheet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

