/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharScanner;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QElement;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPath;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.UnionPattern;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.XslParser;
import com.caucho.xsl.fun.FormatNumberFun;
import com.caucho.xsl.fun.KeyFun;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

abstract class Generator {
    private static WriteStream dbg = LogStream.open("/caucho.com/xsl/generate");
    private static L10N L = new L10N(class$com$caucho$xsl$Generator == null ? (class$com$caucho$xsl$Generator = Generator.class$("com.caucho.xsl.Generator")) : class$com$caucho$xsl$Generator);
    static final String XSLNS = "http://www.w3.org/1999/XSL/Transform";
    static final String XTPNS = "http://www.caucho.com/XTP/1.0";
    private static final int STYLESHEET = 0;
    private static final int OUTPUT = 1;
    private static final int IMPORT = 2;
    private static final int INCLUDE = 3;
    private static final int TEMPLATE = 4;
    private static final int STRIP_SPACE = 5;
    private static final int PRESERVE_SPACE = 6;
    private static final int KEY = 7;
    private static final int LOCALE = 8;
    private static final int ATTRIBUTE_SET = 9;
    private static final int NAMESPACE_ALIAS = 10;
    private static final int APPLY_TEMPLATES = 11;
    private static final int APPLY_IMPORTS = 12;
    private static final int CALL_TEMPLATE = 13;
    private static final int PARAM = 14;
    private static final int VARIABLE = 15;
    private static final int VALUE_OF = 16;
    private static final int COPY_OF = 17;
    private static final int FOR_EACH = 18;
    private static final int IF = 19;
    private static final int CHOOSE = 20;
    private static final int TEXT = 21;
    private static final int XSL_TEXT = 22;
    private static final int NUMBER = 23;
    private static final int COPY = 24;
    private static final int COPY_ELEMENT = 25;
    private static final int ELEMENT = 26;
    private static final int ATTRIBUTE = 27;
    private static final int PI = 28;
    private static final int COMMENT = 29;
    private static final int MESSAGE = 30;
    private static final int EXPRESSION = 31;
    private static final int SCRIPTLET = 32;
    private static final int DECLARATION = 33;
    private static final int DIRECTIVE_CACHE = 34;
    private static final int DIRECTIVE_PAGE = 35;
    private static final int WHILE = 36;
    private static final int ASSIGN = 37;
    private static final int IGNORE = 38;
    private static final int RESULT_DOCUMENT = 39;
    private static IntMap tags;
    private static IntMap xtpTags;
    private String version = "1.0";
    String xslName;
    Path topContext;
    Path baseURL;
    Path context;
    CharBuffer text;
    HashMap names = new HashMap();
    int loopDepth;
    Path workPath;
    protected HashMap preserve = new HashMap();
    protected HashMap strip = new HashMap();
    HashMap attributeSets = new HashMap();
    protected HashMap namespaceAliases = new HashMap();
    protected HashMap excludedNamespaces = new HashMap();
    protected KeyFun keyFun;
    protected FormatNumberFun formatNumberFun;
    protected NamespaceContext namespace;
    protected ArrayList globalActions = new ArrayList();
    protected ArrayList globalParameters = new ArrayList();
    protected Document doc;
    protected CauchoDocument qDoc;
    protected Path path;
    boolean lineContent;
    int lineWs;
    String filename;
    int line;
    protected LineMap lineMap;
    private ArrayList frags;
    protected int destLine = 1;
    boolean defaultCacheable = true;
    boolean isCacheable;
    protected String encoding;
    HashMap templates = new HashMap();
    int minImportance;
    int importance;
    int templateCount;
    private IntArray vars = new IntArray();
    private ArrayList inits = new ArrayList();
    protected ArrayList depends = new ArrayList();
    protected ArrayList cacheDepends = new ArrayList();
    private boolean isCauchoXsl;
    protected boolean isRawText;
    protected String errorPage;
    boolean hasSession;
    protected AbstractPattern nodeListContext;
    private boolean isTop;
    private ClassLoader loader;
    protected boolean isSpecial;
    HashMap outputAttributes = new HashMap();
    HashMap macros;
    HashMap files;
    protected AbstractStylesheetFactory xslGenerator;
    protected ArrayList imports = new ArrayList();
    private static CharScanner commaDelimScanner;
    static /* synthetic */ Class class$com$caucho$xsl$Generator;

    Generator(AbstractStylesheetFactory xslGenerator) {
        Path path;
        this.xslGenerator = xslGenerator;
        this.workPath = xslGenerator.getWorkPath();
        this.topContext = this.context = (path = xslGenerator.getStylePath());
        this.loader = xslGenerator.getClassLoader();
        if (this.loader == null) {
            this.loader = CauchoSystem.getContextClassLoader();
        }
        this.text = new CharBuffer();
        this.frags = new ArrayList();
        this.macros = new HashMap();
        this.keyFun = new KeyFun();
        this.formatNumberFun = new FormatNumberFun();
    }

    void init(String filename) {
        this.lineMap = new LineMap(filename);
    }

    void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    void addImport(String pkg) {
        this.imports.add(pkg);
    }

    void setContentType(String type) {
    }

    void setPath(Path path) {
        this.path = path;
        this.context = path;
    }

    void setWorkPath(Path path) {
        this.workPath = path;
    }

    public StylesheetImpl generate(Node node) throws Exception {
        Element top;
        DocumentType dtd;
        Document xsl = node.getOwnerDocument();
        if (xsl == null) {
            xsl = (Document)node;
        }
        if ((dtd = xsl.getDoctype()) != null) {
            if (xsl instanceof QAbstractNode) {
                String baseURI = ((QAbstractNode)((Object)xsl)).getBaseURI();
                this.context = baseURI.startsWith("string:") ? this.path : this.path.lookup(((QAbstractNode)((Object)xsl)).getBaseURI());
            }
            this.topContext = this.context;
        }
        if ((top = xsl.getDocumentElement()) == null) {
            throw this.error((Node)xsl, L.l("xsl:stylesheet must be top element."));
        }
        this.doc = xsl;
        if (this.doc instanceof CauchoDocument) {
            this.qDoc = (CauchoDocument)this.doc;
        }
        QElement qTop = null;
        if (top instanceof QElement) {
            qTop = (QElement)top;
        }
        this.isTop = true;
        this.files = new HashMap();
        this.scanFiles(top);
        if (this.qDoc != null) {
            ArrayList depends = (ArrayList)this.qDoc.getProperty("caucho.depends");
            for (int i = 0; depends != null && i < depends.size(); ++i) {
                Path path = (Path)depends.get(i);
                this.addDepend(path);
            }
        } else {
            this.addDepend(this.path);
        }
        if ("stylesheet".equals(this.getXslLocal(top)) || "transform".equals(this.getXslLocal(top))) {
            this.generateStylesheet(top, true);
        } else {
            this.printHeader();
            boolean oldCacheable = this.isCacheable;
            boolean oldDefaultCacheable = this.defaultCacheable;
            this.isCacheable = true;
            this.printTemplate(top, null, "/", null, Double.NaN);
            this.isCacheable = oldCacheable;
            this.defaultCacheable = oldDefaultCacheable;
        }
        StylesheetImpl stylesheet = this.completeGenerate(this.inits, this.globalActions);
        return stylesheet;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanFiles(Element top) throws XslParseException, IOException {
        block14: {
            this.isCauchoXsl = top.getAttribute("xsl-caucho").equals("") == false;
            try {
                iter = XPath.select("//xtp:directive.page/@*", top);
            }
            catch (Exception e) {
                throw new XslParseException(e);
            }
            block6: while (true) {
                if (iter.hasNext()) {
                    attr = (Attr)iter.next();
                    name = attr.getNodeName();
                    value = attr.getNodeValue();
                    if (!name.equals("import")) continue;
                } else {
                    try {
                        iter = XPath.select("//xsl:import|xsl:include", top);
                        break block14;
                    }
                    catch (Exception e) {
                        throw new XslParseException(e);
                    }
                }
                cursor = new StringCharCursor(value);
                cb = new CharBuffer();
                while (true) {
                    if (cursor.current() == '\uffff') ** break;
                    Generator.commaDelimScanner.skip(cursor);
                    cb.clear();
                    ch = Generator.commaDelimScanner.scan(cursor, cb);
                    if (cb.length() != 0) {
                        this.addImport(cb.toString());
                        continue;
                    }
                    if (ch != '\uffff') break block6;
                }
                break;
            }
            throw new IOException(Generator.L.l("illegal `import' directive"));
        }
        while (true) {
            if (!var2_2.hasNext()) {
                return;
            }
            elt = (Element)var2_2.next();
            href = elt.getAttribute("href");
            try {
                rs = this.xslGenerator.openPath(href, this.context.getURL());
            }
            catch (Exception e) {
                throw new XslParseException(e);
            }
            path = rs.getPath();
            xsl = this.readXsl(rs);
            subtop = xsl.getDocumentElement();
            if (subtop == null) {
                throw this.error((Node)elt, Generator.L.l("xsl:import file {0} is empty", path.getFullPath()));
            }
            oldContext = this.context;
            virtualContext = this.context.getParent().lookup(href);
            this.context = path;
            this.files.put(virtualContext.getPath(), new File(this.context, xsl));
            this.scanFiles(subtop);
            this.context = oldContext;
        }
    }

    Document readXsl(Path path) throws IOException, XslParseException {
        return this.readXsl(path.openRead());
    }

    Document readXsl(ReadStream file) throws IOException, XslParseException {
        try {
            this.addDepend(file.getPath());
            if (this.isCauchoXsl) {
                XslParser parser = new XslParser();
                Document document = parser.parse(file);
                return document;
            }
            Document parser = new Xml().parseDocument(file);
            return parser;
        }
        catch (SAXException e) {
            throw new XslParseException(e);
        }
        finally {
            file.close();
        }
    }

    private void generateStylesheet(Element elt, boolean isTop) throws Exception {
        QElement element = (QElement)elt;
        this.isCauchoXsl = !element.getAttribute("xsl-caucho").equals("");
        this.addNamespace(element);
        if (isTop) {
            this.printHeader();
        }
        this.version = element.getAttribute("version");
        if (this.version.equals("")) {
            this.version = "1.0";
        }
        this.generateAttributeSets(element);
        this.excludeNamespaces(element);
        String xslSpace = element.getAttribute("xsl-space");
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            int code = -1;
            String name = this.getXslLocal(child);
            if (name != null) {
                code = tags.get(name);
            } else {
                name = this.getXtpLocal(child);
                if (name != null) {
                    code = xtpTags.get(name);
                } else {
                    String childName = child.getNodeName();
                    if (!childName.startsWith("jsp:directive.") && !childName.equals("jsp:declaration") && !childName.equals("jsp:scriptlet")) continue;
                    this.addGlobalAction((Element)child);
                    continue;
                }
            }
            NamespaceContext oldNamespace = this.addNamespace((Element)child);
            this.generateTopLevelNode(code, (Element)child);
            this.namespace = oldNamespace;
        }
    }

    private void addGlobalAction(Element elt) {
        this.globalActions.add(elt);
    }

    private void excludeNamespaces(Element element) throws Exception {
        if (!(element instanceof QElement)) {
            return;
        }
        QElement elt = (QElement)element;
        String excludeNamespace = element.getAttribute("exclude-result-prefixes");
        if (!excludeNamespace.equals("")) {
            Regexp regexp = new Regexp("[,\\s]+");
            ArrayList strings = regexp.split(excludeNamespace);
            for (int i = 0; i < strings.size(); ++i) {
                String prefix = (String)strings.get(i);
                String ns = elt.getNamespace(prefix);
                if (ns == null) {
                    throw this.error((Node)elt, L.l("`{0}' must be a namespace prefix", prefix));
                }
                this.excludedNamespaces.put(ns, "");
            }
        }
    }

    private void generateTopLevelNode(int code, Element elt) throws Exception {
        this.setLocation(elt);
        switch (code) {
            case 21: {
                break;
            }
            case 4: {
                this.generateTemplate(elt);
                break;
            }
            case 1: {
                this.generateOutput(elt);
                break;
            }
            case 15: 
            case 37: {
                this.inits.add(elt);
                break;
            }
            case 14: {
                this.globalParameters.add(elt.getAttribute("name"));
                this.inits.add(elt);
                break;
            }
            case 6: {
                this.generatePreserveSpace(elt);
                break;
            }
            case 5: {
                this.generateStripSpace(elt);
                break;
            }
            case 2: {
                this.generateImport(elt);
                break;
            }
            case 3: {
                this.generateInclude(elt);
                break;
            }
            case 7: {
                this.generateKey(elt);
                break;
            }
            case 8: {
                this.generateLocale(elt);
                break;
            }
            case 10: {
                this.generateNamespaceAlias(elt);
                break;
            }
            case 33: {
                this.printDeclaration(elt);
                break;
            }
            case 34: {
                this.addCacheDepends(elt.getAttribute("file"));
                if (!elt.getAttribute("no-cache").equals("")) {
                    this.isCacheable = false;
                    this.defaultCacheable = false;
                    break;
                }
                this.defaultCacheable = true;
                break;
            }
            case 9: 
            case 38: {
                break;
            }
            default: {
                if (code >= 0) {
                    throw this.error((Node)elt, "xsl:stylesheet cannot contain `" + elt.getNodeName() + "'");
                }
                if (!(elt instanceof QElement) || !XSLNS.equals(((QElement)elt).getNamespaceURI()) || this.version == null || !this.version.equals("1.0")) break;
                throw this.error((Node)elt, "unknown XSL element `" + elt.getNodeName() + "'");
            }
        }
    }

    private void addCacheDepends(String attr) {
        if (attr.equals("")) {
            return;
        }
        int i = 0;
        int ch = 0;
        int len = attr.length();
        while (true) {
            block12: {
                block11: {
                    if (i >= len) break block11;
                    char c = attr.charAt(i);
                    ch = c;
                    if (XmlChar.isWhitespace(c)) break block12;
                }
                if (ch != 44) break;
            }
            ++i;
        }
        CharBuffer cb = new CharBuffer();
        block1: while (i < len) {
            cb.clear();
            while (i < len) {
                char c = attr.charAt(i);
                ch = c;
                if (XmlChar.isWhitespace(c) || ch == 44) break;
                cb.append((char)ch);
                ++i;
            }
            this.cacheDepends.add(cb.toString());
            while (true) {
                block14: {
                    block13: {
                        if (i >= len) break block13;
                        char c = attr.charAt(i);
                        ch = c;
                        if (XmlChar.isWhitespace(c)) break block14;
                    }
                    if (ch != 44) continue block1;
                }
                ++i;
            }
        }
    }

    private void generateCacheDepends(String attr) throws Exception {
        if (attr.equals("")) {
            return;
        }
        int i = 0;
        int ch = 0;
        int len = attr.length();
        while (true) {
            block12: {
                block11: {
                    if (i >= len) break block11;
                    char c = attr.charAt(i);
                    ch = c;
                    if (XmlChar.isWhitespace(c)) break block12;
                }
                if (ch != 44) break;
            }
            ++i;
        }
        CharBuffer cb = new CharBuffer();
        block1: while (i < len) {
            cb.clear();
            while (i < len) {
                char c = attr.charAt(i);
                ch = c;
                if (XmlChar.isWhitespace(c) || ch == 44) break;
                cb.append((char)ch);
                ++i;
            }
            this.printCacheDepends(cb.toString());
            while (true) {
                block14: {
                    block13: {
                        if (i >= len) break block13;
                        char c = attr.charAt(i);
                        ch = c;
                        if (XmlChar.isWhitespace(c)) break block14;
                    }
                    if (ch != 44) continue block1;
                }
                ++i;
            }
        }
    }

    void generateTemplate(Element element) throws Exception {
        String name = element.getAttribute("name");
        String patternString = element.getAttribute("match");
        String mode = element.getAttribute("mode");
        String priority = element.getAttribute("priority");
        double dPriority = Double.NaN;
        if (!name.equals("")) {
            this.macros.put(name, name);
        }
        if (name.equals("") && patternString.equals("")) {
            throw this.error("xsl:template expects a `name' or a `match' attribute.");
        }
        if (!priority.equals("")) {
            try {
                dPriority = Double.valueOf(priority);
            }
            catch (Exception e) {
                throw this.error("xsl:template expects `priority' must be a double.");
            }
        }
        boolean oldCacheable = this.isCacheable;
        boolean oldDefaultCacheable = this.defaultCacheable;
        AbstractPattern oldNodeListContext = this.nodeListContext;
        if (!patternString.equals("")) {
            this.nodeListContext = this.parseMatch(patternString);
        }
        this.isCacheable = true;
        this.printTemplate(element, name, patternString, mode, dPriority);
        this.nodeListContext = oldNodeListContext;
        this.isCacheable = oldCacheable;
        this.defaultCacheable = oldDefaultCacheable;
    }

    void generateImport(Element element) throws Exception {
        String href = element.getAttribute("href");
        if (href.equals("")) {
            throw this.error("xsl:import expects `href' attribute.");
        }
        int oldMinImportance = this.minImportance;
        Path oldContext = this.context;
        String pathName = this.context.getParent().lookup(href).getPath();
        File file = (File)this.files.get(pathName);
        if (file == null) {
            throw new FileNotFoundException(href);
        }
        this.context = file.getContext();
        Document xsl = file.getDoc();
        if (xsl == null) {
            throw new FileNotFoundException(href);
        }
        Element top = xsl.getDocumentElement();
        if (top == null || !"stylesheet".equals(this.getXslLocal(top)) && !"transform".equals(this.getXslLocal(top))) {
            throw this.error("imported stylesheet `" + href + "' missing xsl:stylesheet.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:import must be empty");
        }
        this.minImportance = this.importance;
        boolean oldTop = this.isTop;
        boolean oldRaw = this.isRawText;
        this.isTop = false;
        this.isRawText = false;
        this.generateStylesheet(top, false);
        this.isRawText = oldRaw;
        this.isTop = oldTop;
        this.minImportance = oldMinImportance;
        this.context = oldContext;
        this.incrementImportance();
    }

    void generateInclude(Element element) throws Exception {
        String href = element.getAttribute("href");
        if (href.equals("")) {
            throw this.error("xsl:include expects `href' attribute.");
        }
        Path oldContext = this.context;
        Path path = this.context.getParent().lookup(href);
        File file = (File)this.files.get(path.getPath());
        if (file == null) {
            throw new FileNotFoundException(path.getPath());
        }
        this.context = file.getContext();
        Document xsl = file.getDoc();
        Element top = xsl.getDocumentElement();
        if (top == null || !"stylesheet".equals(this.getXslLocal(top)) && !"transform".equals(this.getXslLocal(top))) {
            throw this.error("imported stylesheet `" + href + "' missing xsl:stylesheet.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:include must be empty");
        }
        this.generateStylesheet(top, false);
        this.context = oldContext;
    }

    void generateKey(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error("xsl:key expects `name' attribute.");
        }
        String match = element.getAttribute("match");
        if (match.equals("")) {
            throw this.error("xsl:key expects `match' attribute.");
        }
        String use = element.getAttribute("use");
        if (use.equals("")) {
            throw this.error("xsl:key expects `use' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:key must be empty");
        }
        this.keyFun.add(name, this.parseMatch(match), this.parseExpr(use));
    }

    void generateLocale(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            name = "*";
        }
        DecimalFormatSymbols format = new DecimalFormatSymbols();
        String value = element.getAttribute("decimal-separator");
        if (value.length() > 0) {
            format.setDecimalSeparator(value.charAt(0));
        }
        if ((value = element.getAttribute("grouping-separator")).length() > 0) {
            format.setGroupingSeparator(value.charAt(0));
        }
        if (!(value = element.getAttribute("infinity")).equals("")) {
            format.setInfinity(value);
        }
        if ((value = element.getAttribute("minus-sign")).length() > 0) {
            format.setMinusSign(value.charAt(0));
        }
        if (!(value = element.getAttribute("NaN")).equals("")) {
            format.setNaN(value);
        }
        if ((value = element.getAttribute("percent")).length() > 0) {
            format.setPercent(value.charAt(0));
        }
        if ((value = element.getAttribute("per-mille")).length() > 0) {
            format.setPerMill(value.charAt(0));
        }
        if ((value = element.getAttribute("zero-digit")).length() > 0) {
            format.setZeroDigit(value.charAt(0));
        }
        if ((value = element.getAttribute("digit")).length() > 0) {
            format.setDigit(value.charAt(0));
        }
        if ((value = element.getAttribute("pattern-separator")).length() > 0) {
            format.setPatternSeparator(value.charAt(0));
        }
        this.formatNumberFun.addLocale(name, format);
    }

    void generateNamespaceAlias(Element element) throws Exception {
        if (!(element instanceof QElement)) {
            return;
        }
        QElement elt = (QElement)element;
        String stylesheetPrefix = element.getAttribute("stylesheet-prefix");
        String resultPrefix = element.getAttribute("result-prefix");
        if (stylesheetPrefix.equals("")) {
            throw this.error((Node)element, "xsl:namespace-alias needs `stylesheet-prefix'");
        }
        if (resultPrefix.equals("")) {
            throw this.error((Node)element, "xsl:namespace-alias needs `result-prefix'");
        }
        String stylesheetNs = elt.getNamespace(stylesheetPrefix);
        if (stylesheetPrefix.equals("#default")) {
            stylesheetNs = "";
        } else if (stylesheetNs.equals("")) {
            throw this.error((Node)element, "`" + stylesheetPrefix + "' is not a valid namespace prefix");
        }
        String resultNs = elt.getNamespace(resultPrefix);
        if (resultPrefix.equals("#default")) {
            resultPrefix = "";
            resultNs = "";
        } else if (resultNs.equals("")) {
            throw this.error((Node)element, "`" + resultPrefix + "' is not a valid namespace prefix");
        }
        String[] result = new String[]{resultPrefix, resultNs};
        this.namespaceAliases.put(stylesheetNs, result);
    }

    void generateAttributeSets(Element element) throws Exception {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"attribute-set".equals(this.getXslLocal(child))) continue;
            QElement elt = (QElement)child;
            String name = elt.getAttribute("name");
            if (name.equals("")) {
                throw this.error(L.l("xsl:attribute-set expects `name' attribute."));
            }
            this.generateAttributeSet(element, name);
        }
    }

    HashMap generateAttributeSet(Element element, String setName) throws Exception {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Node attr;
            if (!"attribute-set".equals(this.getXslLocal(child))) continue;
            QElement elt = (QElement)child;
            String name = elt.getAttribute("name");
            if (name.equals("")) {
                throw this.error(L.l("xsl:attribute-set expects `name' attribute."));
            }
            if (!name.equals(setName)) continue;
            HashMap set = (HashMap)this.attributeSets.get(name);
            if (set != null) {
                return set;
            }
            set = new HashMap();
            this.attributeSets.put(name, set);
            for (attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
                if (!attr.getNodeName().equals("use-attribute-sets")) continue;
                HashMap subset = this.generateAttributeSet(element, attr.getNodeValue());
                if (subset == null) {
                    throw this.error((Node)elt, L.l("Unknown attribute-set `{0}'.  Each use-attribute-sets needs a matching xsl:attribute-set.", attr.getNodeValue()));
                }
                Iterator iter = subset.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    set.put(key, subset.get(key));
                }
            }
            for (attr = elt.getFirstChild(); attr != null; attr = attr.getNextSibling()) {
                if (!"attribute".equals(this.getXslLocal(attr))) continue;
                Element attrElt = (Element)attr;
                String attrName = attrElt.getAttribute("name");
                if (attrName.equals("")) {
                    throw this.error(L.l("xsl:attribute expects `name' attribute."));
                }
                set.put(attrName, ((QElement)attr).getTextValue());
            }
            for (attr = elt.getFirstAttribute(); attr != null; attr = (Attr)attr.getNextSibling()) {
                if (attr.getNodeName().equals("name") || attr.getNodeName().equals("use-attribute-sets")) continue;
                set.put(attr.getNodeName(), attr.getNodeValue());
            }
            return set;
        }
        return null;
    }

    private void generateOutput(Element element) throws Exception {
        Node attr = ((QElement)element).getFirstAttribute();
        if (element.getFirstChild() != null) {
            throw this.error("xsl:output must be empty");
        }
        String disableEscaping = element.getAttribute("resin:disable-output-escaping");
        if (disableEscaping.equals("")) {
            disableEscaping = element.getAttribute("disable-output-escaping");
        }
        if (disableEscaping.equals("no") || disableEscaping.equals("false")) {
            this.isRawText = false;
        } else if (!disableEscaping.equals("")) {
            this.isRawText = true;
        }
        if (!this.isTop) {
            return;
        }
        if (this.outputAttributes == null) {
            this.outputAttributes = new HashMap();
        }
        while (attr != null) {
            this.outputAttributes.put(attr.getNodeName(), attr.getNodeValue());
            attr = attr.getNextSibling();
        }
    }

    private void generatePreserveSpace(Element element) throws Exception {
        int i;
        String elements = element.getAttribute("elements");
        if (elements.equals("")) {
            throw this.error("xsl:preserve-space expects `elements' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:preserve-space must be empty");
        }
        int len = elements.length();
        for (i = 0; i < len && XmlChar.isWhitespace(elements.charAt(i)); ++i) {
        }
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(elements.charAt(i))) {
                cb.append(elements.charAt(i));
                ++i;
            }
            this.preserve.put(cb.toString(), "true");
            while (i < len && XmlChar.isWhitespace(elements.charAt(i))) {
                ++i;
            }
        }
    }

    private void generateStripSpace(Element element) throws Exception {
        int i;
        String elements = element.getAttribute("elements");
        if (elements.equals("")) {
            throw this.error("xsl:strip-space expects `elements' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:strip-space must be empty");
        }
        int len = elements.length();
        for (i = 0; i < len && XmlChar.isWhitespace(elements.charAt(i)); ++i) {
        }
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(elements.charAt(i))) {
                cb.append(elements.charAt(i));
                ++i;
            }
            this.strip.put(cb.toString(), "true");
            while (i < len && XmlChar.isWhitespace(elements.charAt(i))) {
                ++i;
            }
        }
    }

    protected void generateChildren(Node node) throws Exception {
        this.vars.add(0);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.generateChild(child);
        }
        int count = this.vars.pop();
        if (count > 0 && this.vars.size() > 0) {
            this.printPopScope(count);
        }
    }

    protected void generateChild(Node child) throws Exception {
        String nodeName = this.getXslLocal(child);
        int code = -1;
        if (nodeName != null) {
            code = tags.get(nodeName);
        } else {
            nodeName = this.getXtpLocal(child);
            if (nodeName != null) {
                code = xtpTags.get(nodeName);
            }
        }
        if (nodeName == null) {
            if (child.getNodeType() == 3) {
                this.generateText(child);
            } else if (child.getNodeType() == 1) {
                NamespaceContext oldNamespace = this.addNamespace((Element)child);
                this.printElement((Element)child);
                this.namespace = oldNamespace;
            }
            return;
        }
        if (child instanceof QElement) {
            NamespaceContext oldNamespace = this.addNamespace((QElement)child);
            this.generateChild(child, code);
            this.namespace = oldNamespace;
        } else {
            this.generateChild(child, code);
        }
    }

    private void generateChild(Node child, int code) throws Exception {
        if (child instanceof QAbstractNode) {
            QAbstractNode qChild = (QAbstractNode)child;
            this.setLocation(qChild.getFilename(), qChild.getLine());
        }
        switch (code) {
            case 21: {
                this.generateText(child);
                break;
            }
            case 22: {
                this.generateXslText((Element)child);
                break;
            }
            case 11: {
                this.generateApplyTemplates((Element)child);
                break;
            }
            case 12: {
                this.generateApplyImports((Element)child);
                break;
            }
            case 13: {
                this.generateCallTemplate((Element)child);
                break;
            }
            case 14: {
                this.generateParamVariable((Element)child);
                break;
            }
            case 15: {
                this.generateVariable((Element)child);
                break;
            }
            case 16: {
                this.generateValueOf((Element)child);
                break;
            }
            case 17: {
                this.generateCopyOf((Element)child);
                break;
            }
            case 18: {
                this.generateForEach((Element)child);
                break;
            }
            case 19: {
                this.generateIf((Element)child);
                break;
            }
            case 20: {
                this.generateChoose((Element)child);
                break;
            }
            case 23: {
                this.generateNumber((Element)child);
                break;
            }
            case 24: {
                this.printCopy((Element)child);
                break;
            }
            case 25: {
                this.printCopyElement((Element)child);
                break;
            }
            case 26: {
                this.generateElement((Element)child);
                break;
            }
            case 27: {
                this.generateAttribute((Element)child);
                break;
            }
            case 28: {
                this.printPi((Element)child);
                break;
            }
            case 29: {
                this.printComment((Element)child);
                break;
            }
            case 30: {
                this.printMessage((Element)child);
                break;
            }
            case 31: {
                if (!this.defaultCacheable) {
                    this.isCacheable = false;
                }
                this.printExpression((Element)child);
                break;
            }
            case 32: {
                if (!this.defaultCacheable) {
                    this.isCacheable = false;
                }
                this.printScriptlet((Element)child);
                break;
            }
            case 34: {
                this.generateCacheDepends(((Element)child).getAttribute("file"));
                if (!((Element)child).getAttribute("no-cache").equals("")) {
                    this.isCacheable = false;
                    this.defaultCacheable = false;
                    break;
                }
                this.defaultCacheable = true;
                break;
            }
            case 36: {
                this.generateWhile((Element)child);
                break;
            }
            case 37: {
                this.generateAssign((Element)child);
                break;
            }
            case 39: {
                this.generateResultDocument((Element)child);
                break;
            }
            case 38: {
                break;
            }
            default: {
                if (child instanceof QElement && XSLNS.equals(((QElement)child).getNamespaceURI()) && this.version != null && this.version.equals("1.0")) {
                    throw this.error(child, "unknown XSL element `" + child.getNodeName() + "'");
                }
                boolean hasFallback = false;
                for (Node subchild = child.getFirstChild(); subchild != null; subchild = subchild.getNextSibling()) {
                    String local = this.getXslLocal(subchild);
                    if (local == null || !"fallback".equals(local)) continue;
                    hasFallback = true;
                    this.generateChildren(subchild);
                }
                if (hasFallback) break;
                this.printError(L.l("expected xsl tag at `{0}'", child.getNodeName()));
            }
        }
    }

    private void generateText(Node node) throws Exception {
        int i;
        String data = node.getNodeValue();
        int length = data.length();
        if (length == 0) {
            return;
        }
        for (i = 0; i < length && XmlChar.isWhitespace(data.charAt(i)); ++i) {
        }
        if (i == length && this.stripNode(node)) {
            return;
        }
        if (data != null && data.length() > 0 && node instanceof QAbstractNode) {
            this.setLocation(node);
            this.writeText(data);
        }
    }

    private boolean stripNode(Node node) {
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            Element elt;
            String space;
            if (!(node instanceof Element) || (space = (elt = (Element)node).getAttribute("xml:space")).equals("")) continue;
            return !space.equals("preserve");
        }
        return true;
    }

    void generateXslText(Element element) throws Exception {
        this.text.clear();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            String data = child.getNodeValue();
            int length = data.length();
            this.text.append(data);
        }
        String disableEscaping = element.getAttribute("disable-output-escaping");
        if (disableEscaping.equals("")) {
            disableEscaping = "no";
        }
        if (this.text.length() > 0) {
            if (!disableEscaping.equals("yes") && !disableEscaping.equals("true")) {
                this.writeText(this.text.toString());
            } else {
                this.startDisableEscaping();
                this.writeText(this.text.toString());
                this.endDisableEscaping();
            }
        }
    }

    private void generateApplyTemplates(Node node) throws Exception {
        Sort[] sort;
        QElement element = (QElement)node;
        String select = element.getAttribute("select");
        String mode = element.getAttribute("mode");
        AbstractPattern selectPattern = null;
        if (!select.equals("")) {
            selectPattern = this.parseSelect(select, node);
        }
        if ((sort = this.generateSort(node)) != null && selectPattern == null) {
            selectPattern = this.parseSelect("*", node);
        }
        this.pushCall();
        this.generateArgs(element);
        this.printApplyTemplates(selectPattern, mode, sort);
        this.popCall();
    }

    private void generateApplyImports(Node node) throws Exception {
        QElement element = (QElement)node;
        String mode = element.getAttribute("mode");
        if (element.getFirstChild() != null) {
            throw this.error(L.l("xsl:apply-imports must be empty"));
        }
        this.pushCall();
        this.generateArgs(element);
        this.printApplyImports(mode, this.minImportance, this.importance);
        this.popCall();
    }

    private void generateCallTemplate(Element element) throws Exception {
        String name = element.getAttribute("name");
        String mode = element.getAttribute("mode");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:call-template", "name"));
        }
        if (this.findMacro(name) == null) {
            throw this.error(L.l("`{0}' is an unknown macro for xsl:call-template.  All macros must be defined in an <xsl:template name='...'> element.", name));
        }
        this.pushCall();
        this.generateArgs(element);
        this.printCallTemplate(name, mode);
        this.popCall();
    }

    private Element findMacro(String name) throws Exception {
        Element template = this.findMacroInDocument(this.doc, name);
        if (template != null) {
            return template;
        }
        Iterator iter = this.files.values().iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            Document doc = file.getDoc();
            template = this.findMacroInDocument(doc, name);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    private Element findMacroInDocument(Document doc, String name) {
        Element elt = doc.getDocumentElement();
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element template;
            if (!child.getNodeName().equals("xsl:template") || !(template = (Element)child).getAttribute("name").equals(name)) continue;
            return template;
        }
        return null;
    }

    private void generateMacro(Element element) throws Exception {
        QElement elt = (QElement)element;
        String name = element.getNodeName();
        String mode = element.getAttribute("mode");
        this.pushCall();
        for (Node node = elt.getFirstAttribute(); node != null; node = node.getNextSibling()) {
            String argName = node.getNodeName();
            String argValue = node.getNodeValue();
            this.printParam(argName, argValue, elt);
        }
        this.printParam("contents", elt);
        this.printCallTemplate(name, mode);
        this.popCall();
    }

    private void generateArgs(Element element) throws Exception {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String localName = this.getXslLocal(node);
            if (!"with-param".equals(localName)) continue;
            String key = ((Element)node).getAttribute("name");
            String expr = ((Element)node).getAttribute("select");
            if (key.equals("")) {
                throw this.error(L.l("{0} requires `{1}' attribute", (Object)"xsl:with-param", "name"));
            }
            if (!expr.equals("")) {
                this.printParam(key, this.parseExpr(expr));
                continue;
            }
            this.printParam(key, node);
        }
    }

    private void generateParamVariable(Element element) throws Exception {
        int i = this.vars.size() - 1;
        this.vars.set(i, this.vars.get(i) + 1);
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:param", "name"));
        }
        if (!expr.equals("")) {
            this.printParamVariable(name, this.parseExpr(expr));
        } else {
            this.printParamVariable(name, element);
        }
    }

    private void generateVariable(Element element) throws Exception {
        int i = this.vars.size() - 1;
        this.vars.set(i, this.vars.get(i) + 1);
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:variable", "name"));
        }
        if (!expr.equals("")) {
            this.printVariable(name, this.parseExpr(expr));
        } else {
            this.printVariable(name, element);
        }
    }

    private void generateAssign(Element element) throws Exception {
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xtp:assign", "name"));
        }
        if (!expr.equals("")) {
            this.printAssign(name, this.parseExpr(expr));
        } else {
            this.printAssign(name, element);
        }
    }

    private void generateResultDocument(Element element) throws Exception {
        String href = element.getAttribute("href");
        String format = element.getAttribute("format");
        if (href.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xtp:result-document", "href"));
        }
        this.printResultDocument(element, href, format);
    }

    private void generateValueOf(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:value-of", "select"));
        }
        if (element.getFirstChild() != null) {
            throw this.error(L.l("{0} must be empty", "xsl:value-of"));
        }
        String disable = element.getAttribute("disable-output-escaping");
        boolean isDisabled = disable.equals("yes");
        if (isDisabled) {
            this.startDisableEscaping();
        }
        this.printSelectValue(select, element);
        if (isDisabled) {
            this.endDisableEscaping();
        }
    }

    private void generateCopyOf(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:copy-of", "select"));
        }
        if (element.getFirstChild() != null) {
            throw this.error(L.l("{0} must be empty", "xsl:copy-of"));
        }
        this.printCopyOf(select, element);
    }

    void generateForEach(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:for-each", "select"));
        }
        Sort[] sort = this.generateSort(element);
        if (sort != null) {
            this.printForEach(element, select, sort);
        } else {
            this.printForEach(element, select);
        }
    }

    private Sort[] generateSort(Node node) throws XslParseException, IOException {
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        block0: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String lang;
            if (child.getNodeType() == 3) {
                String data = child.getNodeValue();
                for (int i = 0; i < data.length(); ++i) {
                    if (!XmlChar.isWhitespace(data.charAt(i))) break block0;
                }
                continue;
            }
            if (child.getNodeType() == 8) continue;
            if (child.getNodeType() == 7) continue;
            String name = this.getXslLocal(child);
            if (!"sort".equals(name)) break;
            Element elt = (Element)child;
            String select = elt.getAttribute("select");
            if (select.equals("")) {
                throw this.error(L.l("{0} expects attribute `{1}'", (Object)"xsl:sort", "select"));
            }
            Expr expr = this.parseExpr(select);
            String order = elt.getAttribute("order");
            Expr isAscending = null;
            if (order.equals("")) {
                isAscending = this.parseExpr("true()");
            } else if (order.startsWith("{") && order.endsWith("}")) {
                order = order.substring(1, order.length() - 1);
                isAscending = this.parseExpr(order + " = 'ascending'");
            } else {
                isAscending = order.equals("ascending") ? this.parseExpr("true()") : this.parseExpr("false()");
            }
            String dataType = elt.getAttribute("data-type");
            boolean isText = true;
            if (dataType.equals("number")) {
                isText = false;
            }
            if ((lang = elt.getAttribute("lang")).equals("")) {
                sorts.add(Sort.create(expr, isAscending, isText));
                continue;
            }
            lang = lang.startsWith("{") && lang.endsWith("}") ? lang.substring(1, lang.length() - 1) : "'" + lang + "'";
            sorts.add(Sort.create(expr, isAscending, this.parseExpr(lang)));
        }
        if (sorts.size() > 0) {
            return sorts.toArray(new Sort[sorts.size()]);
        }
        return null;
    }

    void generateIf(Element element) throws Exception {
        String test = element.getAttribute("test");
        if (test.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:if", "test"));
        }
        this.printIf(element, this.parseExpr(test));
    }

    void generateWhile(Element element) throws Exception {
        String test = element.getAttribute("test");
        if (test.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:while", "test"));
        }
        this.printWhile(element, this.parseExpr(test));
    }

    void generateChoose(Element element) throws Exception {
        boolean first = true;
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            String name = this.getXslLocal(child);
            if ("when".equals(name)) {
                Element elt = (Element)child;
                String test = elt.getAttribute("test");
                if (test.equals("")) {
                    throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:when", "test"));
                }
                this.printChoose(elt, this.parseExpr(test), first);
                first = false;
                continue;
            }
            if ("otherwise".equals(name)) {
                this.printOtherwise((Element)child, first);
                continue;
            }
            throw this.error(L.l("xsl:choose expects `xsl:when' or `xsl:otherwise' at `{0}'", child.getNodeName()));
        }
    }

    void generateElement(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:element", "name"));
        }
        Attr nsAttr = element.getAttributeNode("namespace");
        if (nsAttr == null) {
            this.printElement(element, name);
        } else {
            this.printElement(element, name, nsAttr.getNodeValue());
        }
    }

    void generateAttribute(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:attribute", "name"));
        }
        Attr nsAttr = element.getAttributeNode("namespace");
        boolean oldSpecial = this.isSpecial;
        this.isSpecial = true;
        if (nsAttr == null) {
            this.printAttribute(element, name);
        } else {
            this.printAttribute(element, name, nsAttr.getNodeValue());
        }
        this.isSpecial = oldSpecial;
    }

    void generateNumber(Element element) throws Exception {
        String value = element.getAttribute("value");
        String count = element.getAttribute("count");
        String from = element.getAttribute("from");
        String level = element.getAttribute("level");
        String format = element.getAttribute("format");
        String letter = element.getAttribute("letter-value");
        String separator = element.getAttribute("grouping-separator");
        String lang = element.getAttribute("lang");
        String size_name = element.getAttribute("grouping-size");
        int size = 0;
        for (int i = 0; i < size_name.length(); ++i) {
            char ch = size_name.charAt(i);
            if (ch < '0' || ch > '9') continue;
            size = 10 * size + ch - 48;
        }
        boolean isAlphabetic = true;
        if (!letter.equals("alphabetic")) {
            isAlphabetic = false;
        }
        AbstractPattern countPattern = null;
        if (!count.equals("")) {
            countPattern = this.parseMatch(count);
        }
        AbstractPattern fromPattern = null;
        if (!from.equals("")) {
            fromPattern = this.parseMatch(from);
        }
        if (level.equals("") || level.equals("single")) {
            level = "single";
        } else if (!level.equals("multiple") && !level.equals("any")) {
            throw this.error(L.l("xsl:number can't understand level=`{0}'", level));
        }
        XslNumberFormat xslFormat = new XslNumberFormat(format, lang, isAlphabetic, separator, size);
        if (!value.equals("")) {
            this.printNumber(this.parseExpr(value), xslFormat);
        } else {
            this.printNumber(level, countPattern, fromPattern, xslFormat);
        }
    }

    void printNumber(Expr expr, XslNumberFormat format) throws Exception {
    }

    void printNumber(String level, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
    }

    void setLocation(Node node) throws Exception {
        if (node instanceof QAbstractNode) {
            this.setLocation(((QAbstractNode)node).getFilename(), ((QAbstractNode)node).getLine());
        }
    }

    protected void setLocation(String filename, int line) throws XslParseException, IOException {
        if (filename != null) {
            this.filename = filename;
            this.line = line;
            this.lineMap.add(filename, line, this.destLine);
        }
    }

    int getTextLength() {
        return this.text.length();
    }

    protected void printHeader() throws XslParseException, IOException {
    }

    protected abstract void startDisableEscaping() throws Exception;

    protected abstract void endDisableEscaping() throws Exception;

    protected abstract void writeText(String var1) throws Exception;

    protected abstract void printTemplate(Element var1, String var2, String var3, String var4, double var5) throws Exception;

    void printLocation(Node node) throws Exception {
        if (node instanceof QAbstractNode) {
            this.printLocation(((QAbstractNode)node).getFilename(), ((QAbstractNode)node).getLine());
        }
    }

    protected abstract void printLocation(String var1, int var2) throws Exception;

    protected abstract void printElement(Node var1) throws Exception;

    protected abstract void printApplyTemplates(AbstractPattern var1, String var2, Sort[] var3) throws Exception;

    protected abstract void printApplyImports(String var1, int var2, int var3) throws Exception;

    protected abstract void printCallTemplate(String var1, String var2) throws Exception;

    protected abstract void pushCall() throws Exception;

    protected abstract void popCall() throws Exception;

    protected abstract void printParam(String var1, Object var2) throws Exception;

    protected abstract void printParam(String var1, String var2, Element var3) throws Exception;

    protected abstract void printParamVariable(String var1, Expr var2) throws Exception;

    protected abstract void printParamVariable(String var1, Element var2) throws Exception;

    protected abstract void printVariable(String var1, Object var2) throws Exception;

    protected void printAssign(String name, Object value) throws Exception {
        this.printVariable(name, value);
    }

    protected abstract void printPopScope(int var1) throws Exception;

    protected abstract void printCopyOf(String var1, Element var2) throws Exception;

    protected abstract void printSelectValue(String var1, Element var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2, Sort[] var3) throws Exception;

    protected void printIf(Element element, Expr expr) throws Exception {
    }

    protected void printChoose(Element element, Expr expr, boolean first) throws Exception {
    }

    protected void printOtherwise(Element element, boolean first) throws Exception {
    }

    protected void printCopy(Element element) throws Exception {
    }

    protected void printCopyElement(Element element) throws Exception {
    }

    protected void printElement(Element element, String name) throws Exception {
    }

    protected void printElement(Element element, String name, String namespace) throws Exception {
    }

    protected void printAttribute(Element node, String name) throws Exception {
    }

    protected void printAttribute(Element node, String name, String namespace) throws Exception {
    }

    protected void printPi(Element node) throws Exception {
    }

    protected void printComment(Element node) throws Exception {
    }

    protected void printError(String msg) throws Exception {
    }

    protected void printMessage(Element node) throws Exception {
    }

    protected void printExpression(Element node) throws Exception {
    }

    protected void printScriptlet(Element node) throws Exception {
    }

    protected void printDeclaration(Element node) throws Exception {
    }

    protected void printCacheDepends(String path) throws Exception {
    }

    protected void printWhile(Element element, Expr expr) throws Exception {
    }

    protected void printResultDocument(Element element, String href, String format) throws Exception {
    }

    private void incrementImportance() {
        ++this.importance;
    }

    Template addPattern(AbstractPattern pattern, String mode, double priority, String function, int funId) {
        if (pattern instanceof UnionPattern) {
            UnionPattern union = (UnionPattern)pattern;
            this.addPattern(union.getLeft(), mode, priority, function, funId);
            return this.addPattern(union.getRight(), mode, priority, function, funId);
        }
        if (Double.isNaN(priority)) {
            priority = pattern.getPriority();
        }
        if (dbg.canWrite()) {
            dbg.log("add " + pattern.getNodeName() + " " + pattern + " fun:" + function + " mode:" + mode + " priority:" + priority);
        }
        Template template = new Template(pattern, mode, this.minImportance, this.importance, priority, this.templateCount++, function, funId);
        this.addTemplate(pattern.getNodeName(), template);
        return template;
    }

    private void addTemplate(String nodeName, Template template) {
        ArrayList<Template> templateList = (ArrayList<Template>)this.templates.get(nodeName);
        if (templateList == null) {
            templateList = new ArrayList<Template>();
            this.templates.put(nodeName, templateList);
        }
        for (int i = templateList.size() - 1; i >= 0; --i) {
            Template item = (Template)templateList.get(i);
            if (template.compareTo(item) > 0) continue;
            templateList.add(i + 1, template);
            return;
        }
        templateList.add(0, template);
    }

    protected AbstractPattern parseMatch(String pattern) throws XslParseException, IOException {
        try {
            return XPath.parseMatch(pattern, this.namespace).getPattern();
        }
        catch (Exception e) {
            throw this.error(L.l("{0} in pattern `{1}'", (Object)e.toString(), pattern));
        }
    }

    protected AbstractPattern parseSelect(String pattern) throws IOException, XslParseException {
        try {
            return XPath.parseSelect(pattern, this.namespace).getPattern();
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    protected AbstractPattern parseSelect(String pattern, Node node) throws IOException, XslParseException {
        try {
            return XPath.parseSelect(pattern, this.namespace).getPattern();
        }
        catch (Exception e) {
            throw this.error(node, e);
        }
    }

    protected Expr parseExpr(String pattern) throws IOException, XslParseException {
        try {
            return XPath.parseExpr(pattern, this.namespace, this.nodeListContext);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    XslParseException error(Exception e) {
        if (e.getMessage() != null) {
            return this.error(e.getMessage());
        }
        e.printStackTrace();
        if (dbg.canWrite()) {
            e.printStackTrace(dbg.getPrintWriter());
        }
        return this.error(e.toString());
    }

    XslParseException error(Node node, Exception e) {
        if (e.getMessage() != null) {
            return this.error(node, e.getMessage());
        }
        e.printStackTrace();
        if (dbg.canWrite()) {
            e.printStackTrace(dbg.getPrintWriter());
        }
        return this.error(e.toString());
    }

    XslParseException error(String message) {
        return new XslParseException(this.filename + ":" + this.line + ": " + message);
    }

    XslParseException error(Node node, String message) {
        if (!(node instanceof QAbstractNode)) {
            return this.error(message);
        }
        QAbstractNode qnode = (QAbstractNode)node;
        String filename = qnode.getFilename();
        int line = qnode.getLine();
        if (filename != null) {
            return new XslParseException(filename + ":" + line + ": " + message);
        }
        return this.error(message);
    }

    protected String getXslLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        QElement elt = (QElement)node;
        String ns = elt.getNamespaceURI();
        String prefix = elt.getPrefix();
        if (ns == null && elt.getNodeName().startsWith("xsl:")) {
            return elt.getNodeName().substring(4);
        }
        if (ns == null) {
            return null;
        }
        if (ns.startsWith(XSLNS) && (ns.length() == XSLNS.length() || ns.charAt(XSLNS.length()) == '/')) {
            return elt.getLocalName();
        }
        return null;
    }

    private String getXtpLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        QElement elt = (QElement)node;
        String ns = elt.getNamespaceURI();
        String prefix = elt.getPrefix();
        if (ns == null && elt.getNodeName().startsWith("xtp:")) {
            return elt.getNodeName().substring(4);
        }
        if (ns == null) {
            return null;
        }
        if (ns.startsWith(XTPNS)) {
            return elt.getLocalName();
        }
        return null;
    }

    private Expr parseExpr(Node node, String expr) throws Exception {
        try {
            return XPath.parseExpr(expr, this.namespace, this.nodeListContext);
        }
        catch (Exception e) {
            throw this.error(node, e.getMessage());
        }
    }

    private NamespaceContext addNamespace(Element elt) {
        NamespaceContext oldNamespace = this.namespace;
        for (Node attr = ((QElement)elt).getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            String name = attr.getNodeName();
            if (!name.startsWith("xmlns:")) continue;
            name = name.substring(6);
            String url = attr.getNodeValue();
            if (url.equals(XSLNS) || url.equals(XTPNS)) continue;
            if (url.startsWith("quote:")) {
                url = url.substring(6);
            }
            this.namespace = new NamespaceContext(this.namespace, name, url);
        }
        return oldNamespace;
    }

    void addDepend(Path depend) {
        if (depend != null) {
            this.depends.add(depend);
        }
    }

    protected abstract StylesheetImpl completeGenerate(ArrayList var1, ArrayList var2) throws Exception;

    public void close() throws IOException, XslParseException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        commaDelimScanner = new CharScanner(" \t\n\r,");
        tags = new IntMap();
        tags.put("stylesheet", 0);
        tags.put("transform", 0);
        tags.put("output", 1);
        tags.put("template", 4);
        tags.put("preserve-space", 6);
        tags.put("strip-space", 5);
        tags.put("import", 2);
        tags.put("include", 3);
        tags.put("key", 7);
        tags.put("decimal-format", 8);
        tags.put("attribute-set", 9);
        tags.put("namespace-alias", 10);
        tags.put("apply-templates", 11);
        tags.put("apply-imports", 12);
        tags.put("call-template", 13);
        tags.put("param", 14);
        tags.put("variable", 15);
        tags.put("for-each", 18);
        tags.put("if", 19);
        tags.put("choose", 20);
        tags.put("value-of", 16);
        tags.put("copy-of", 17);
        tags.put("text", 22);
        tags.put("#text", 21);
        tags.put("number", 23);
        tags.put("copy", 24);
        tags.put("element", 26);
        tags.put("attribute", 27);
        tags.put("pi", 28);
        tags.put("processing-instruction", 28);
        tags.put("comment", 29);
        tags.put("message", 30);
        tags.put("sort", 38);
        tags.put("fallback", 38);
        tags.put("result-document", 39);
        xtpTags = new IntMap();
        xtpTags.put("expression", 31);
        xtpTags.put("expr", 31);
        xtpTags.put("eval", 31);
        xtpTags.put("scriptlet", 32);
        xtpTags.put("script", 32);
        xtpTags.put("decl", 33);
        xtpTags.put("declaration", 33);
        xtpTags.put("directive.cache", 34);
        xtpTags.put("while", 36);
        xtpTags.put("assign", 37);
    }

    static class File {
        Path _context;
        Document _doc;

        File(Path context, Document doc) {
            this._context = context;
            this._doc = doc;
        }

        Path getContext() {
            return this._context;
        }

        Document getDoc() {
            return this._doc;
        }
    }
}

