/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.transform.SAXTransformer;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.SAXBuilder;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXTransformerImpl
extends TransformerImpl
implements SAXTransformer {
    private ContentHandler contentHandler;

    SAXTransformerImpl(StylesheetImpl stylesheet) {
        super(stylesheet);
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver handler) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source) throws SAXException, IOException {
        InputStream is = source.getByteStream();
        if (is != null) {
            ReadStream rs = Vfs.openRead(is);
            rs.setEncoding(source.getEncoding());
            try {
                this.transform(this.parseDocument(rs, null));
            }
            finally {
                rs.close();
            }
        } else {
            Reader reader = source.getCharacterStream();
            if (reader != null) {
                ReadStream rs = Vfs.openRead(reader);
                try {
                    this.transform(this.parseDocument(rs, null));
                }
                finally {
                    rs.close();
                }
            } else {
                String systemId = source.getSystemId();
                if (systemId != null) {
                    this.transform(this.parseDocument(systemId));
                } else {
                    throw new SAXException("no valid input source");
                }
            }
        }
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.transform(this.parseDocument(systemId));
    }

    public void transform(InputStream source) throws SAXException, IOException {
        this.transform(this.parseDocument(source, null));
    }

    public void transform(String systemId) throws SAXException, IOException {
        this.transform(this.parseDocument(systemId));
    }

    public void transformString(String source) throws SAXException, IOException {
        this.transform(this.parseStringDocument(source, null));
    }

    public void transform(Node source) throws SAXException, IOException {
        SAXBuilder out = new SAXBuilder(this);
        try {
            out.startDocument();
            this.stylesheet.transform(source, out, this);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

