/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.transform.OutputFormat;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QElement;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.StylesheetEnv;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xsl.AbstractStylesheet;
import com.caucho.xsl.Sort;
import com.caucho.xsl.Template;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XslException;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslWriter;
import com.caucho.xsl.fun.DocumentFun;
import com.caucho.xsl.fun.ExtensionElementFun;
import com.caucho.xsl.fun.ExtensionFunctionFun;
import com.caucho.xsl.fun.SystemPropertyFun;
import com.caucho.xsl.fun.UnparsedEntityFun;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StylesheetImpl
extends AbstractStylesheet {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/apply");
    public char[] text;
    protected HashMap templates;
    HashMap funs = new HashMap();
    private HashMap preserve;
    private HashMap strip;
    private HashMap preservePrefix;
    private HashMap stripPrefix;
    private HashMap properties = new HashMap();
    boolean isCacheable = true;
    protected boolean defaultDisableEscaping;
    Path cachePath;
    long lastModified;
    boolean generateLocation;
    LineMap lineMap;

    protected void copy(AbstractStylesheet stylesheet) {
        super.copy(stylesheet);
        StylesheetImpl stylesheetImpl = (StylesheetImpl)stylesheet;
        stylesheetImpl.text = this.text;
        stylesheetImpl.templates = this.templates;
        stylesheetImpl.preserve = this.preserve;
        stylesheetImpl.strip = this.strip;
        stylesheetImpl.preservePrefix = this.preservePrefix;
        stylesheetImpl.stripPrefix = this.stripPrefix;
        stylesheetImpl.lineMap = this.lineMap;
        stylesheetImpl.properties = this.properties;
        stylesheetImpl.defaultDisableEscaping = this.defaultDisableEscaping;
    }

    public OutputFormat getOutputFormat() {
        return new OutputFormat();
    }

    public void setOutputFormat(OutputFormat output) {
    }

    protected void setSpaces(HashMap preserve, HashMap preservePrefix, HashMap strip, HashMap stripPrefix) {
        this.preserve = preserve;
        this.strip = strip;
        this.preservePrefix = preservePrefix;
        this.stripPrefix = stripPrefix;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setGenerateLocation(boolean generateLocation) {
        this.generateLocation = generateLocation;
    }

    public boolean getGenerateLocation() {
        return this.generateLocation;
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(name);
        if (value != null) {
            return value;
        }
        return super.getProperty(name);
    }

    protected void addFunction(String name, XPathFun fun) {
        this.funs.put(name, fun);
    }

    public void init(Path path) throws Exception {
        super.init(path);
        this.addFunction("system-property", new SystemPropertyFun());
        this.addFunction("element-available", new ExtensionElementFun());
        this.addFunction("function-available", new ExtensionFunctionFun());
        this.addFunction("unparsed-entity-uri", new UnparsedEntityFun());
    }

    public void transform(Node xml, XMLWriter writer, TransformerImpl transformer) throws SAXException, IOException, TransformerException {
        if (xml == null) {
            throw new NullPointerException("can't transform null node");
        }
        XslWriter out = new XslWriter(null, this, transformer);
        out.init(writer);
        if (this.funs == null) {
            this.funs = (HashMap)((StylesheetImpl)this.stylesheet).funs.clone();
        } else {
            this.funs.putAll(((StylesheetImpl)this.stylesheet).funs);
        }
        this.addFunction("document", new DocumentFun(transformer));
        DocumentFun docFun = new DocumentFun(transformer);
        docFun.setHtml(true);
        this.addFunction("html_document", docFun);
        Env env = XPath.createEnv();
        env.setFunctions(this.funs);
        StylesheetEnv ssEnv = new StylesheetEnv();
        ssEnv.setPath(this.getPath());
        env.setStylesheetEnv(ssEnv);
        out.disableEscaping(this.defaultDisableEscaping);
        try {
            this._xsl_init(out, xml, env);
            this.applyNode(out, xml, env, 0, Integer.MAX_VALUE);
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XslException(e, this.lineMap);
        }
        out.close();
        XPath.freeEnv(env);
    }

    protected void _xsl_init(XslWriter out, Node context, Env env) throws Exception {
    }

    protected Document ownerDocument(Node node) {
        Document owner = node.getOwnerDocument();
        if (owner != null) {
            return owner;
        }
        return (Document)node;
    }

    public void applyNode(XslWriter out, Node node, Env env) throws Exception {
        this.applyNode(out, node, env, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected void applyNode(XslWriter out, Node node, Env env, int min, int max) throws Exception {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.applyNode(out, child, env, 0, Integer.MAX_VALUE);
                }
                break;
            }
            case 1: {
                Node child;
                out.pushCopy(node);
                if (node instanceof QElement) {
                    for (child = ((QElement)node).getFirstAttribute(); child != null; child = child.getNextSibling()) {
                        this.applyNode(out, child, env, 0, Integer.MAX_VALUE);
                    }
                } else {
                    NamedNodeMap attributeMap = ((Element)node).getAttributes();
                    int size = attributeMap.getLength();
                    for (int i = 0; i < size; ++i) {
                        Node child2 = attributeMap.item(i);
                        this.applyNode(out, child2, env, 0, Integer.MAX_VALUE);
                    }
                }
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.applyNode(out, child, env, 0, Integer.MAX_VALUE);
                }
                out.popCopy(node);
                break;
            }
            case 3: 
            case 4: {
                String value = node.getNodeValue();
                out.print(value);
                return;
            }
            case 2: 
            case 5: {
                out.pushCopy(node);
                out.popCopy(node);
            }
        }
    }

    protected Template getTemplate(HashMap templates, Node node, Env env, int min, int max) throws XPathException {
        Object template = null;
        Template[] templateList = (Template[])templates.get(node.getNodeName());
        if (templateList == null) {
            templateList = (Template[])templates.get("*");
        }
        for (int i = 0; templateList != null && i < templateList.length; ++i) {
            Template subtemplate = templateList[i];
            if (min > subtemplate.maxImportance || subtemplate.maxImportance > max || !subtemplate.pattern.match(node, env)) continue;
            return subtemplate;
        }
        return null;
    }

    protected void applyNodeDefault(XslWriter out, Node node, Env env) throws Exception {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (this.generateLocation && node instanceof QAbstractNode) {
                    out.setLocation(((QAbstractNode)node).getFilename(), ((QAbstractNode)node).getLine());
                }
                String value = node.getNodeValue();
                if (this.strip == null) {
                    out.print(value);
                    return;
                }
                for (int i = value.length() - 1; i >= 0; --i) {
                    if (XmlChar.isWhitespace(value.charAt(i))) continue;
                    out.print(value);
                    return;
                }
                if (!this.stripSpaces(node.getParentNode())) {
                    out.print(value);
                }
                return;
            }
            case 2: 
            case 5: {
                out.print(node.getNodeValue());
                break;
            }
            case 1: 
            case 9: {
                throw new RuntimeException();
            }
        }
    }

    public void printValue(XslWriter out, Node node) throws IOException {
        if (node != null) {
            out.print(this.getNodeValue(node));
        }
    }

    public String getNodeValue(Node node) {
        CharBuffer cb = new CharBuffer();
        this.nodeValue(cb, node);
        return cb.toString();
    }

    private void nodeValue(CharBuffer cb, Node node) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    switch (child.getNodeType()) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.nodeValue(cb, child);
                        }
                    }
                }
                break;
            }
            case 5: {
                cb.append('&');
                cb.append(node.getNodeName());
                cb.append(';');
                break;
            }
            case 9: {
                Document doc = (Document)node;
                this.nodeValue(cb, doc.getDocumentElement());
                break;
            }
            case 3: 
            case 4: {
                String value = node.getNodeValue();
                for (int i = value.length() - 1; i >= 0; --i) {
                    if (XmlChar.isWhitespace(value.charAt(i))) continue;
                    cb.append(value);
                    return;
                }
                if (this.stripSpaces(node.getParentNode())) break;
                cb.append(node.getNodeValue());
                return;
            }
            default: {
                cb.append(node.getNodeValue());
            }
        }
    }

    protected ArrayList xslSort(Node node, Env env, AbstractPattern pattern, Sort[] sortList) throws Exception {
        ArrayList<Node> sortKeys = new ArrayList<Node>();
        NodeIterator iter = pattern.select(node, env);
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            sortKeys.add(child);
        }
        int[] map = new int[sortKeys.size()];
        for (int i = map.length - 1; i >= 0; --i) {
            map[i] = i;
        }
        int[] workMap = new int[map.length];
        Object[] values = new Object[map.length * sortList.length];
        int size = map.length;
        for (int i = 0; i < size; ++i) {
            Node child = (Node)sortKeys.get(i);
            env.setPosition(i + 1);
            for (int j = 0; j < sortList.length; ++j) {
                Object value;
                Sort sort = sortList[j];
                values[i * sortList.length + j] = value = sort.sortValue(child, env);
            }
        }
        boolean[] ascendingList = new boolean[sortList.length];
        for (int i = 0; i < ascendingList.length; ++i) {
            Expr isAscending = sortList[i].getAscending();
            if (isAscending != null && !isAscending.evalBoolean(node, env)) continue;
            ascendingList[i] = true;
        }
        Comparator[] comparatorList = new Comparator[sortList.length];
        for (int i = 0; i < comparatorList.length; ++i) {
            Expr langExpr = sortList[i].getLang();
            if (langExpr == null) continue;
            String lang = langExpr.evalString(node, env);
            comparatorList[i] = this.getComparator(lang);
        }
        this.sort(values, sortList, comparatorList, ascendingList, 0, map.length, map, workMap);
        ArrayList sortedKeys = new ArrayList();
        for (int i = 0; i < map.length; ++i) {
            sortedKeys.add(sortKeys.get(map[i]));
        }
        return sortedKeys;
    }

    private Comparator getComparator(String lang) {
        Locale locale = this.getLocale(lang);
        return Collator.getInstance(locale);
    }

    private Locale getLocale(String lang) {
        int p = lang.indexOf(45);
        Locale locale = null;
        if (p < 0) {
            locale = new Locale(lang, "");
        } else {
            String language = lang.substring(0, p);
            int q = lang.indexOf(p + 1, 45);
            if (q < 0) {
                String country = lang.substring(p + 1);
                locale = new Locale(language, country);
            } else {
                String country = lang.substring(p + 1, q);
                String variant = lang.substring(q);
                locale = new Locale(language, country, variant);
            }
        }
        return locale;
    }

    private void sort(Object[] values, Sort[] sortList, Comparator[] comparatorList, boolean[] ascendingList, int head, int tail, int[] map, int[] workMap) {
        int i;
        int i2;
        int length = tail - head;
        if (length <= 1) {
            return;
        }
        if (length == 2) {
            int b = map[head + 1];
            int a = map[head];
            if (this.lessThan(values, sortList, comparatorList, ascendingList, b, a)) {
                map[head] = b;
                map[head + 1] = a;
            }
            return;
        }
        if (length == 3) {
            int a = map[head];
            int b = map[head + 1];
            int c = map[head + 2];
            if (this.lessThan(values, sortList, comparatorList, ascendingList, b, a)) {
                map[head] = b;
                map[head + 1] = a;
                a = map[head];
                b = map[head + 1];
            }
            if (this.lessThan(values, sortList, comparatorList, ascendingList, c, b)) {
                if (this.lessThan(values, sortList, comparatorList, ascendingList, c, a)) {
                    map[head] = c;
                    map[head + 1] = a;
                    map[head + 2] = b;
                } else {
                    map[head + 1] = c;
                    map[head + 2] = b;
                }
            }
            return;
        }
        int pivotIndex = (head + tail) / 2;
        int pivot = map[pivotIndex];
        int top = tail;
        for (i2 = tail - 1; i2 >= head; --i2) {
            if (!this.lessThan(values, sortList, comparatorList, ascendingList, pivot, map[i2])) continue;
            workMap[--top] = map[i2];
            map[i2] = -1;
        }
        if (top == tail) {
            for (i2 = tail - 1; i2 >= head; --i2) {
                if (this.lessThan(values, sortList, comparatorList, ascendingList, map[i2], pivot)) continue;
                workMap[--top] = map[i2];
                map[i2] = -1;
            }
            if (top == head) {
                for (i2 = head; i2 < tail; ++i2) {
                    map[i2] = workMap[i2];
                }
                return;
            }
        }
        int center = head;
        for (i = head; i < tail; ++i) {
            if (map[i] < 0) continue;
            map[center++] = map[i];
        }
        for (i = center; i < tail; ++i) {
            map[i] = workMap[i];
        }
        this.sort(values, sortList, comparatorList, ascendingList, head, center, map, workMap);
        this.sort(values, sortList, comparatorList, ascendingList, center, tail, map, workMap);
    }

    private void swap(int[] map, int a, int b) {
        int ka = map[a];
        int kb = map[b];
        map[b] = ka;
        map[a] = kb;
    }

    private boolean lessThan(Object[] values, Sort[] sortList, Comparator[] comparatorList, boolean[] ascendingList, int ai, int bi) {
        int len = sortList.length;
        for (int i = 0; i < len; ++i) {
            Object a = values[len * ai + i];
            Object b = values[len * bi + i];
            int cmp = sortList[i].cmp(a, b, comparatorList[i], ascendingList[i]);
            if (cmp < 0) {
                return true;
            }
            if (cmp <= 0) continue;
            return false;
        }
        return false;
    }

    public void singleNumber(XslWriter out, Node node, Env env, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (countPattern == null) {
            countPattern = XPath.parseMatch(node.getNodeName()).getPattern();
        }
        IntArray numbers = new IntArray();
        while (node != null) {
            if (countPattern.match(node, env)) {
                numbers.add(this.countPreviousSiblings(node, env, countPattern));
                break;
            }
            if (fromPattern != null && fromPattern.match(node, env)) break;
            node = node.getParentNode();
        }
        if (fromPattern != null && !this.findFromAncestor(node, env, fromPattern)) {
            numbers.clear();
        }
        format.format(out, numbers);
    }

    public void multiNumber(XslWriter out, Node node, Env env, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (countPattern == null) {
            countPattern = XPath.parseMatch(node.getNodeName()).getPattern();
        }
        IntArray numbers = new IntArray();
        while (node != null) {
            if (countPattern.match(node, env)) {
                numbers.add(this.countPreviousSiblings(node, env, countPattern));
            }
            if (fromPattern != null && fromPattern.match(node, env)) break;
            node = node.getParentNode();
        }
        if (fromPattern != null && !this.findFromAncestor(node, env, fromPattern)) {
            numbers.clear();
        }
        format.format(out, numbers);
    }

    public void anyNumber(XslWriter out, Node node, Env env, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
        if (countPattern == null) {
            countPattern = XPath.parseMatch(node.getNodeName()).getPattern();
        }
        IntArray numbers = new IntArray();
        int count = 0;
        while (node != null) {
            if (countPattern.match(node, env)) {
                ++count;
            }
            if (fromPattern != null && fromPattern.match(node, env)) break;
            node = XmlUtil.getPrevious(node);
        }
        numbers.add(count);
        if (fromPattern != null && !this.findFromAncestor(node, env, fromPattern)) {
            numbers.clear();
        }
        format.format(out, numbers);
    }

    public void exprNumber(XslWriter out, Node node, Env env, Expr expr, XslNumberFormat format) throws Exception {
        IntArray numbers = new IntArray();
        numbers.add((int)expr.evalNumber(node, env));
        format.format(out, numbers);
    }

    private int countPreviousSiblings(Node node, Env env, String name) {
        int count = 1;
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            ++count;
        }
        return count;
    }

    private int countPreviousSiblings(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int count = 1;
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (!pattern.match(node, env)) continue;
            ++count;
        }
        return count;
    }

    private boolean findFromAncestor(Node node, Env env, AbstractPattern pattern) throws XPathException {
        while (node != null) {
            if (pattern.match(node, env)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    boolean stripSpaces(Node node) {
        if (this.strip == null) {
            return false;
        }
        for (Node ptr = node; ptr != null; ptr = ptr.getParentNode()) {
            if (!(ptr instanceof Element)) continue;
            Element elt = (Element)ptr;
            String space = elt.getAttribute("xml:space");
            if (space != null && space.equals("preserve")) {
                return false;
            }
            if (space != null) break;
        }
        String name = node.getNodeName();
        if (this.preserve.get(node.getNodeName()) != null) {
            return false;
        }
        if (this.strip.get(node.getNodeName()) != null) {
            return true;
        }
        CauchoNode cnode = (CauchoNode)node;
        String nsStar = cnode.getPrefix();
        if (this.preservePrefix.get(nsStar) != null) {
            return false;
        }
        if (this.stripPrefix.get(nsStar) != null) {
            return true;
        }
        return this.strip.get("*") != null;
    }

    protected static Template[] mergeTemplates(Template[] star, Template[] templates) {
        Template[] merged = new Template[star.length + templates.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < star.length && j < templates.length) {
            if (star[i].compareTo(templates[j]) > 0) {
                merged[k++] = star[i++];
                continue;
            }
            merged[k++] = templates[j++];
        }
        while (i < star.length) {
            merged[k++] = star[i];
            ++i;
        }
        while (j < templates.length) {
            merged[k++] = templates[j];
            ++j;
        }
        return merged;
    }
}

