/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.AbstractColumn;
import com.caucho.jdbc.mysql.Connection;
import com.caucho.jdbc.mysql.ResultSetMetaData;
import com.caucho.jdbc.mysql.SQLExceptionWrapper;
import com.caucho.jdbc.mysql.Statement;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

abstract class AbstractResultSet
implements ResultSet {
    protected static WriteStream dbg = LogStream.open((String)"/caucho.com/jdbc/rs");
    protected Connection conn;
    protected Statement stmt;
    protected int rowNumber;
    protected CharBuffer cb;
    protected char[] charBuf = new char[256];
    private ResultSetMetaData metaData;
    protected boolean wasNull = false;
    private String encoding;
    private ByteToChar byteToChar;

    void init(Connection connection, Statement statement) {
        this.conn = connection;
        this.stmt = statement;
        this.rowNumber = -1;
        this.wasNull = false;
        this.encoding = connection.getEncoding();
        this.byteToChar = connection.getByteToChar();
    }

    public boolean absolute(int n) {
        System.out.println("rs");
        return false;
    }

    public void afterLast() {
        System.out.println("rs");
    }

    public void beforeFirst() {
        System.out.println("rs");
    }

    public void cancelRowUpdates() {
        System.out.println("rs");
    }

    public void clearWarnings() {
        System.out.println("rs");
    }

    public void deleteRow() {
        System.out.println("drs");
    }

    public int getRow() throws SQLException {
        if (this.rowNumber < 0) {
            throw new SQLException("can't call getRow() after close()");
        }
        System.out.println("grs");
        return this.rowNumber;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber == 0;
    }

    public boolean isAfterLast() {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return this.rowNumber == 1;
    }

    public boolean first() throws SQLException {
        return this.isFirst();
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return this.isLast();
    }

    public int getConcurrency() {
        System.out.println("gc");
        System.out.println("gc");
        return 0;
    }

    public String getCursorName() {
        System.out.println("gcn");
        return null;
    }

    public java.sql.Statement getStatement() throws SQLException {
        if (this.rowNumber < 0) {
            throw new SQLException("can't call getStatement() after close()");
        }
        System.out.println("stmt");
        return this.stmt;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.rowNumber < 0) {
            throw new SQLException("can't call getMetaData() after close()");
        }
        return this.metaData;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public boolean next() throws SQLException {
        return false;
    }

    protected abstract int getColumnCount();

    protected abstract AbstractColumn getColumn(int var1);

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.getColumnCount()) {
            if (this.getColumn(n + 1).getColumnName().equals(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new SQLException("No such column `" + string + "'");
    }

    protected abstract int getOffset(int var1) throws SQLException;

    protected abstract int getLength(int var1) throws SQLException;

    protected abstract byte[] getBuffer(int var1) throws SQLException;

    protected abstract InputStream getInputStream(int var1) throws SQLException;

    public int getType() {
        return 0;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return new BigDecimal(this.getDouble(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return new BigDecimal(this.getDouble(n));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public boolean getBoolean(int n) throws SQLException {
        switch (this.getMetaData().getColumnType(n)) {
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(n) != 0;
            }
            case -5: {
                return this.getLong(n) != 0L;
            }
            case 6: 
            case 7: 
            case 8: {
                return this.getDouble(n) != 0.0;
            }
        }
        String string = this.getString(n);
        return string != null && !string.equals("") && !string.equals("0");
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        int n2 = this.getLength(n);
        byte[] byArray = this.getBuffer(n);
        if (this.wasNull || n2 < 0) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        try {
            if (byArray != null) {
                System.arraycopy(byArray, this.getOffset(n), byArray2, 0, n2);
            } else {
                int n3;
                InputStream inputStream = this.getInputStream(n);
                int n4 = 0;
                while ((n3 = inputStream.read()) >= 0) {
                    byArray2[n4++] = (byte)n3;
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
        return byArray2;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    protected abstract long getDateAsLong(int var1) throws SQLException;

    public Date getDate(int n) throws SQLException {
        long l = this.getDateAsLong(n);
        if (l == 0L && (this.wasNull || this.getLength(n) < 0)) {
            return null;
        }
        return new Date(l);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        int n2;
        int n3 = this.getOffset(n);
        int n4 = this.getLength(n);
        int n5 = n3 + n4;
        byte[] byArray = this.getBuffer(n);
        double d = 0.0;
        int n6 = 1;
        int n7 = 0;
        if (n3 < n5 && byArray[n3] == 45) {
            n6 = -1;
            ++n3;
        }
        while (n3 < n5) {
            n2 = byArray[n3];
            if (n2 < 48 || n2 > 57) break;
            d = 10.0 * d + (double)n2 - 48.0;
            ++n3;
        }
        if (n3 >= n5) {
            return (double)n6 * d;
        }
        if (byArray[n3] == 46) {
            ++n3;
            while (n3 < n5) {
                n2 = byArray[n3];
                if (n2 < 48 || n2 > 57) break;
                d = 10.0 * d + (double)n2 - 48.0;
                --n7;
                ++n3;
            }
        }
        if (byArray[n3] == 101 || byArray[n3] == 69) {
            n2 = 1;
            if (++n3 < n5 && byArray[n3] == 45) {
                ++n3;
                n2 = -1;
            }
            if (n3 < n5 && byArray[n3] == 43) {
                ++n3;
            }
            int n8 = 0;
            while (n3 < n5) {
                byte by = byArray[n3];
                if (by < 48 || by > 57) break;
                n8 = 10 * n8 + by - 48;
                ++n3;
            }
            n7 += n2 * n8;
        }
        if (n3 < n5) {
            throw new SQLException("expected double at `" + this.getString(n) + "'");
        }
        if (n7 >= 0) {
            return (double)n6 * d * Math.pow(10.0, n7);
        }
        return (double)n6 * d / Math.pow(10.0, -n7);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() {
        return 0;
    }

    public int getFetchSize() {
        return 0;
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public float getFloat(String string) throws SQLException {
        return (float)this.getDouble(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        int n2 = this.getOffset(n);
        int n3 = this.getLength(n);
        int n4 = n2 + n3;
        byte[] byArray = this.getBuffer(n);
        int n5 = 0;
        int n6 = 1;
        if (n2 < n4 && byArray[n2] == 45) {
            n6 = -1;
            ++n2;
        }
        while (n2 < n4) {
            byte by = byArray[n2];
            if (by < 48 || by > 57) break;
            n5 = 10 * n5 + by - 48;
            ++n2;
        }
        if (n2 < n4) {
            throw new SQLException("bad integer: `" + this.getString(n) + "'");
        }
        return n6 * n5;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        int n2 = this.getOffset(n);
        int n3 = this.getLength(n);
        int n4 = n2 + n3;
        byte[] byArray = this.getBuffer(n);
        long l = 0L;
        int n5 = 1;
        if (n2 < n4 && byArray[n2] == 45) {
            n5 = -1;
            ++n2;
        }
        while (n2 < n4) {
            byte by = byArray[n2];
            if (by < 48 || by > 57) {
                throw new SQLException("expected long: `" + this.getString(n) + "'");
            }
            l = 10L * l + (long)by - 48L;
            ++n2;
        }
        return (long)n5 * l;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        switch (this.getMetaData().getColumnType(n)) {
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        int n2 = this.getOffset(n);
        int n3 = this.getLength(n);
        byte[] byArray = this.getBuffer(n);
        if (this.wasNull || n3 < 0) {
            return null;
        }
        try {
            int n4;
            if (this.encoding == null && n3 <= 256) {
                char[] cArray = this.charBuf;
                int n5 = n3 - 1;
                while (n5 >= 0) {
                    cArray[n5] = (char)(byArray[n2 + n5] & 0xFF);
                    --n5;
                }
                return new String(cArray, 0, n3);
            }
            if (n3 <= 256) {
                this.byteToChar.clear();
                int n6 = 0;
                while (n6 < n3) {
                    this.byteToChar.addByte(byArray[n2 + n6] & 0xFF);
                    ++n6;
                }
                return this.byteToChar.getConvertedString();
            }
            InputStream inputStream = this.getInputStream(n);
            this.byteToChar.clear();
            while ((n4 = inputStream.read()) >= 0) {
                this.byteToChar.addByte(n4);
            }
            return this.byteToChar.getConvertedString();
        }
        catch (IOException iOException) {
            throw new SQLExceptionWrapper(iOException);
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        long l = this.getDateAsLong(n);
        if (l == 0L && (this.wasNull || this.getLength(n) < 0)) {
            return null;
        }
        return new Time(l);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        long l = this.getDateAsLong(n);
        if (l == 0L && (this.wasNull || this.getLength(n) < 0)) {
            return null;
        }
        return new Timestamp(l);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        int n2 = this.getOffset(n);
        int n3 = this.getLength(n);
        byte[] byArray = this.getBuffer(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray, n2, n3);
        }
        return this.getInputStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        int n2 = this.getOffset(n);
        int n3 = this.getLength(n);
        byte[] byArray = this.getBuffer(n);
        byte[] byArray2 = new byte[2 * n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray2[2 * n4] = 0;
            byArray2[2 * n4 + 1] = byArray[n2 + n4];
            ++n4;
        }
        return new ByteArrayInputStream(byArray2);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void insertRow() {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() {
    }

    public void moveToInsertRow() {
    }

    public boolean previous() {
        return false;
    }

    public void refreshRow() {
    }

    public boolean relative(int n) {
        return false;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    public void setFetchDirection(int n) {
    }

    public void setFetchSize(int n) {
    }

    public void updateRow() {
    }

    public void updateObject(int n, Object object) {
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) {
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateNull(int n) {
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) {
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) {
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) {
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) {
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) {
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(int n, short s) {
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(int n, int n2) {
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) {
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(int n, float f) {
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(int n, double d) {
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateString(int n, String string) {
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(int n, byte[] byArray) {
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) {
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateTime(int n, Time time) throws SQLException {
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateDate(int n, Date date) throws SQLException {
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public void close() throws SQLException {
        this.rowNumber = -1;
    }

    AbstractResultSet() {
        this.cb = new CharBuffer();
        this.metaData = new ResultSetMetaData(this);
    }
}

