/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.ResultSet;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;

class DatabaseConnection {
    private static WriteStream dbg = LogStream.open((String)"/caucho.com/jdbc/vconn");
    private static int HEADER_LENGTH = 4;
    static final int SLEEP = 0;
    static final int QUIT = 1;
    static final int INIT_DB = 2;
    static final int QUERY = 3;
    static final int FIELD_LIST = 4;
    static final int CREATE_DB = 5;
    static final int DROP_DB = 6;
    static final int REFRESH = 7;
    static final int SHUTDOWN = 8;
    static final int STATISTICS = 9;
    static final int PROCESS_INFO = 10;
    static final int CONNECT = 11;
    static final int PROCESS_KILL = 12;
    static final int DEBUG = 13;
    static final int PING = 14;
    static final int TIME = 15;
    static final int DELAYED_INSERT = 16;
    static final int CHANGE_USER = 17;
    static final int CLIENT_LONG_PASSWORD = 1;
    static final int CLIENT_FOUND_ROWS = 2;
    static final int CLIENT_LONG_FLAG = 4;
    static final int CLIENT_CONNECT_WITH_DB = 8;
    static final int CLIENT_NO_SCHEMA = 16;
    static final int CLIENT_COMPRESS = 32;
    static final int CLIENT_ODBC = 64;
    static final int CLIENT_LOCAL_FILE = 128;
    static final int CLIENT_IGNORE_SPACE = 256;
    static final int CLIENT_CHANGE_USER = 512;
    static final int CLIENT_INTERACTIVE = 1024;
    static final int MAX_ROWS = 50000000;
    static final long SOCKET_TIMEOUT = 120000L;
    private static int count;
    private Socket socket;
    private ReadStream is;
    private WriteStream os;
    private long socketTimeout = 120000L;
    private boolean isAutoCommit = true;
    private boolean inTransaction;
    private boolean isClosed;
    private ByteBuffer packet = new ByteBuffer();
    private int outputSequence;
    private CharBuffer cb = new CharBuffer();
    private int inputSequence;
    private String database;
    private byte[] protoBuffer = new byte[32];
    private int readLength;
    private String version;
    private boolean isActive;

    String getVersion() {
        return this.version;
    }

    private final void login(String string, String string2) throws IOException, SQLException {
        this.readPacket();
        int n = this.read();
        this.version = this.readString();
        int n2 = this.readInt();
        String string3 = this.readString();
        if (dbg.canWrite()) {
            dbg.log("Protocol " + n + " " + this.version + " threadId " + n2 + " seed " + string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        int n3 = 16;
        int n4 = 1;
        this.writeShort(n4);
        this.writeInt24(string.length() + string2.length() + 6 + 4);
        this.writeString(string);
        this.writeString(this.scramble(string3, string2));
        this.send();
        this.readStatus();
    }

    private final String scramble(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            long[] lArray = this.hashPassword(string2);
            long[] lArray2 = this.hashPassword(string);
            long l = 0x3FFFFFFFL;
            long[] lArray3 = new long[]{(lArray[0] ^ lArray2[0]) % l, (lArray[1] ^ lArray2[1]) % l};
            CharBuffer charBuffer = CharBuffer.allocate();
            int n = 0;
            while (n < string.length()) {
                charBuffer.append((char)(Math.floor(this.rnd(lArray3, l) * 31.0) + 64.0));
                ++n;
            }
            n = (byte)Math.floor(this.rnd(lArray3, l) * 31.0);
            char[] cArray = charBuffer.getBuffer();
            int n2 = 0;
            while (n2 < charBuffer.length()) {
                int n3 = n2++;
                cArray[n3] = (char)(cArray[n3] ^ (char)n);
            }
            return charBuffer.close();
        }
        return "";
    }

    private final long[] hashPassword(String string) {
        long l = 1345345333L;
        long l2 = 7L;
        long l3 = 305419889L;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\t') {
                long l4 = c;
                l ^= ((l & 0x3FL) + l2) * l4 + (l << 8);
                l3 += l3 << 8 ^ l;
                l2 += l4;
            }
            ++n;
        }
        return new long[]{l & Integer.MAX_VALUE, l3 & Integer.MAX_VALUE};
    }

    private final double rnd(long[] lArray, long l) {
        lArray[0] = (lArray[0] * 3L + lArray[1]) % l;
        lArray[1] = (lArray[0] + lArray[1] + 33L) % l;
        return (double)lArray[0] / (double)l;
    }

    String getDatabase() {
        return this.database;
    }

    void setDatabase(String string) throws SQLException {
        if (string.equals(this.database)) {
            return;
        }
        this.database = string;
        try {
            this.outputSequence = -1;
            this.packet.clear();
            this.write(2);
            this.writeRawString(string);
            this.send();
            this.readStatus();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    boolean getAutoCommit() {
        return this.isAutoCommit;
    }

    void setAutoCommit(boolean bl) {
        this.isAutoCommit = bl;
    }

    int execute(String string, ResultSet resultSet) throws IOException, SQLException {
        boolean bl;
        boolean bl2 = bl = !this.isAutoCommit && !this.inTransaction;
        if (bl) {
            this.beginTransaction();
        }
        if (dbg.canWrite()) {
            dbg.log("sql: " + string);
        }
        this.outputSequence = -1;
        this.packet.clear();
        this.write(3);
        this.writeRawString(string);
        this.send();
        return this.fillResult(resultSet);
    }

    void completeResult() {
    }

    int execute(CharBuffer charBuffer, ResultSet resultSet) throws IOException, SQLException {
        boolean bl;
        boolean bl2 = bl = !this.isAutoCommit && !this.inTransaction;
        if (bl) {
            this.beginTransaction();
        }
        if (dbg.canWrite()) {
            dbg.log("sql: " + charBuffer);
        }
        this.outputSequence = -1;
        this.packet.clear();
        this.write(3);
        this.writeRawString(charBuffer.getBuffer(), 0, charBuffer.getLength());
        this.send();
        return this.fillResult(resultSet);
    }

    private final void beginTransaction() throws IOException, SQLException {
        if (dbg.canWrite()) {
            dbg.log("BEGIN");
        }
        this.inTransaction = true;
        this.outputSequence = -1;
        this.packet.clear();
        this.write(3);
        this.writeRawString("BEGIN");
        this.send();
        this.fillResult(null);
    }

    void commit() throws IOException, SQLException {
        if (this.inTransaction) {
            this.inTransaction = false;
            if (dbg.canWrite()) {
                dbg.log("COMMIT");
            }
            this.outputSequence = -1;
            this.packet.clear();
            this.write(3);
            this.writeRawString("COMMIT");
            this.send();
            this.fillResult(null);
        }
    }

    void rollback() throws IOException, SQLException {
        if (this.inTransaction) {
            this.inTransaction = false;
            if (dbg.canWrite()) {
                dbg.log("ROLLBACK");
            }
            this.outputSequence = -1;
            this.packet.clear();
            this.write(3);
            this.writeRawString("ROLLBACK");
            this.send();
            this.fillResult(null);
        }
    }

    private final int fillResult(ResultSet resultSet) throws IOException, SQLException {
        int n = this.readStatus();
        if (n < 0) {
            throw new SQLException("bad?");
        }
        if (n == 0) {
            int n2 = this.readLength();
            return n2;
        }
        if (resultSet == null) {
            int n3 = 0;
            while (n3 < n) {
                if (!this.readPacket()) {
                    throw new EOFException();
                }
                ++n3;
            }
            this.readStatus();
            while ((n3 = this.next()) >= 0) {
                this.is.skip((long)n3);
            }
            return 1;
        }
        resultSet.setColumns(n);
        int n4 = 0;
        while (n4 < n) {
            if (!this.readPacket()) {
                throw new EOFException();
            }
            resultSet.allocColumn(n4);
            this.readLenString(resultSet.getTable(n4));
            this.readLenString(resultSet.getName(n4));
            int n5 = this.readNBytes();
            int n6 = this.readNBytes();
            int n7 = this.readNBytes();
            int n8 = n7 >> 8;
            int n9 = n7 & 0xFF;
            resultSet.setColumn(n4, n5, n6, n8, n9);
            ++n4;
        }
        this.readStatus();
        resultSet.init(this);
        return -1;
    }

    int getReadLength() {
        return this.readLength;
    }

    int next() throws IOException, SQLException {
        int n = this.readStatus();
        if (n >= 254) {
            this.isActive = false;
            return Integer.MIN_VALUE;
        }
        switch (n) {
            case 251: {
                return -1;
            }
            case 252: {
                return this.readShort();
            }
            case 253: {
                return this.readShortInt();
            }
        }
        return n;
    }

    private final void write(int n) {
        this.packet.add(n);
    }

    private final void writeShort(int n) {
        this.packet.add(n);
        this.packet.add(n >> 8);
    }

    private final void writeInt24(int n) {
        this.packet.add(n);
        this.packet.add(n >> 8);
        this.packet.add(n >> 16);
    }

    private final void writeInt(int n) {
        this.packet.add(n);
        this.packet.add(n >> 8);
        this.packet.add(n >> 16);
        this.packet.add(n >> 24);
    }

    private final void writeRawString(String string) {
        this.packet.addString(string);
    }

    private final void writeRawString(char[] cArray, int n, int n2) {
        this.packet.add(cArray, n, n2);
    }

    private final void writeString(String string) {
        this.packet.addString(string);
        this.packet.add(0);
    }

    private final void send() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            int n = this.packet.length();
            this.os.write(n);
            this.os.write(n >> 8);
            this.os.write(n >> 16);
            this.os.write(++this.outputSequence);
            this.os.write(this.packet.getBuffer(), 0, n);
            this.packet.clear();
        }
        catch (IOException iOException) {
            this.close();
        }
    }

    private final int readStatus() throws IOException, SQLException {
        if (!this.readPacket()) {
            this.isClosed = true;
            throw new SQLException("Dropped connection");
        }
        int n = this.read();
        if (n == 255) {
            int n2 = this.readShort();
            String string = this.readString();
            throw new SQLException(string);
        }
        return n;
    }

    private final boolean readPacket() throws IOException {
        if (this.isClosed) {
            return false;
        }
        try {
            if (this.readLength > 0) {
                this.is.skip((long)this.readLength);
            }
            int n = this.is.read();
            int n2 = this.is.read();
            int n3 = this.is.read();
            this.inputSequence = this.is.read();
            this.readLength = n + (n2 << 8) + (n3 << 16);
            if (this.readLength <= 0 || this.inputSequence < 0) {
                this.close();
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public boolean isLastDataPacket() throws IOException {
        if (this.readLength <= 2) {
            --this.readLength;
            return this.is.read() == 254;
        }
        return false;
    }

    int skip(int n) throws IOException {
        this.is.skip((long)n);
        this.readLength -= n;
        return n;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readLength < n2) {
            n2 = this.readLength;
        }
        this.is.readAll(byArray, n, n2);
        this.readLength -= n2;
        return n2;
    }

    private final String readString() throws IOException {
        this.cb.clear();
        while (this.readLength > 0) {
            --this.readLength;
            int n = this.is.read();
            if (n == 0) {
                return this.cb.toString();
            }
            this.cb.append((char)n);
        }
        return this.cb.toString();
    }

    private final void read(CharBuffer charBuffer) throws IOException {
        while (this.readLength > 0) {
            --this.readLength;
            int n = this.is.read();
            if (n == 0) {
                return;
            }
            charBuffer.append((char)n);
        }
    }

    private final int readNBytes() throws IOException {
        --this.readLength;
        switch (this.is.read()) {
            case 1: {
                --this.readLength;
                return this.is.read();
            }
            case 2: {
                return this.readShort();
            }
            case 3: {
                return this.readShortInt();
            }
            case 4: {
                return this.readInt();
            }
        }
        return 255;
    }

    private final void readLenString(CharBuffer charBuffer) throws IOException {
        int n = this.readLength();
        if (n < 0) {
            return;
        }
        charBuffer.setLength(n);
        char[] cArray = charBuffer.getBuffer();
        this.readLength -= n;
        this.is.readAll(cArray, 0, n);
    }

    int readLength() throws IOException {
        --this.readLength;
        int n = this.is.read();
        switch (n) {
            case 251: {
                return -1;
            }
            case 252: {
                return this.readShort();
            }
            case 253: {
                return this.readShortInt();
            }
            case 254: {
                return this.readInt();
            }
        }
        return n;
    }

    int read() throws IOException {
        --this.readLength;
        return this.is.read();
    }

    private final int readShort() throws IOException {
        this.readLength -= 2;
        int n = this.is.read();
        int n2 = this.is.read();
        return n + (n2 << 8);
    }

    private final int readShortInt() throws IOException {
        this.readLength -= 3;
        int n = this.is.read();
        int n2 = this.is.read();
        int n3 = this.is.read();
        return n + (n2 << 8) + (n3 << 16);
    }

    private final int readInt() throws IOException {
        this.readLength -= 4;
        int n = this.is.read();
        int n2 = this.is.read();
        int n3 = this.is.read();
        int n4 = this.is.read();
        return n + (n2 << 8) + (n3 << 16) + (n4 << 24);
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        Socket socket = this.socket;
        this.socket = null;
        try {
            try {
                this.os.close();
                this.is.close();
            }
            finally {
                Object var3_2 = null;
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DatabaseConnection(String string, int n, String string2, String string3) throws IOException, SQLException {
        try {
            this.socket = new Socket(string, n);
            if (this.socketTimeout > 0L) {
                this.socket.setSoTimeout((int)this.socketTimeout);
            }
            SocketStream socketStream = new SocketStream(this.socket);
            this.os = new WriteStream((StreamImpl)socketStream);
            this.is = new ReadStream((StreamImpl)socketStream, this.os);
            this.readLength = 0;
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            this.login(string2, string3);
        }
        catch (IOException iOException) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw iOException;
        }
        catch (SQLException sQLException) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw sQLException;
        }
    }
}

