/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.AbstractColumn;
import com.caucho.jdbc.mysql.AbstractResultSet;
import com.caucho.regexp.Regexp;
import com.caucho.util.ByteBuffer;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;

class DummyResultSet
extends AbstractResultSet {
    private static Regexp csvRegexp;
    private ArrayList dummyColumns = new ArrayList();
    private ArrayList dummyRows = new ArrayList();
    private int i;

    public void addColumn(String string, int n) {
        this.dummyColumns.add(new DummyColumn(string, n));
    }

    public int getColumnCount() {
        return this.dummyColumns.size();
    }

    public AbstractColumn getColumn(int n) {
        return (AbstractColumn)this.dummyColumns.get(n - 1);
    }

    public void startRow() {
        DummyRow dummyRow = new DummyRow(this.dummyColumns.size());
        this.dummyRows.add(dummyRow);
    }

    public DummyResultSet add(String string) {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.dummyRows.size() - 1);
        dummyRow.add(string);
        return this;
    }

    public DummyResultSet add(int n) {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.dummyRows.size() - 1);
        dummyRow.add(String.valueOf(n));
        return this;
    }

    public DummyResultSet add() {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.dummyRows.size() - 1);
        dummyRow.add("");
        return this;
    }

    public void addRow(String string) {
        ArrayList arrayList;
        this.startRow();
        Regexp regexp = csvRegexp;
        synchronized (regexp) {
            arrayList = csvRegexp.split(string);
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.add((String)arrayList.get(n));
            ++n;
        }
    }

    protected int getOffset(int n) {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.i - 1);
        return dummyRow.getOffset(n - 1);
    }

    protected int getLength(int n) {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.i - 1);
        return dummyRow.getLength(n - 1);
    }

    protected byte[] getBuffer(int n) {
        DummyRow dummyRow = (DummyRow)this.dummyRows.get(this.i - 1);
        return dummyRow.getBuffer(n - 1);
    }

    protected InputStream getInputStream(int n) {
        throw new UnsupportedOperationException();
    }

    protected long getDateAsLong(int n) {
        return 0L;
    }

    public boolean next() throws SQLException {
        if (this.i >= this.dummyRows.size()) {
            return false;
        }
        ++this.i;
        return true;
    }

    DummyResultSet() {
    }

    static {
        try {
            csvRegexp = new Regexp(":");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class DummyColumn
    extends AbstractColumn {
        String name;
        int type;

        public String getColumnName() {
            return this.name;
        }

        public int getColumnType() {
            return this.type;
        }

        public String getColumnTypeName() {
            return "VARCHAR";
        }

        DummyColumn(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }

    static class DummyRow {
        private ByteBuffer buffer = new ByteBuffer();
        private int[] offsets;
        private int[] lengths;
        private int i;

        void add(String string) {
            this.offsets[this.i] = this.buffer.size();
            if (string == null) {
                this.buffer.addString("");
            } else {
                this.buffer.addString(string);
            }
            this.lengths[this.i] = this.buffer.size() - this.offsets[this.i];
            ++this.i;
        }

        protected int getOffset(int n) {
            return this.offsets[n];
        }

        protected int getLength(int n) {
            return this.lengths[n];
        }

        protected byte[] getBuffer(int n) {
            return this.buffer.getBuffer();
        }

        DummyRow(int n) {
            this.offsets = new int[n];
            this.lengths = new int[n];
            this.i = 0;
        }
    }
}

