/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.Connection;
import com.caucho.jdbc.mysql.SQLExceptionWrapper;
import com.caucho.jdbc.mysql.Statement;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private static WriteStream dbg = LogStream.open((String)"/caucho.com/jdbc/statement");
    private static LruCache cache = new LruCache(256);
    private CharBuffer cb = new CharBuffer();
    private char[][] staticChunks;
    private CharBuffer[] parameters;
    private Object[] values;

    static PreparedStatement create(Connection connection, String string) {
        PreparedStatement preparedStatement = new PreparedStatement();
        preparedStatement.init(connection);
        char[][] cArray = (char[][])cache.get((Object)string);
        if (cArray == null) {
            int n;
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            CharBuffer charBuffer = new CharBuffer();
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if (n == 63) {
                    char[] cArray2 = new char[charBuffer.getLength()];
                    System.arraycopy(charBuffer.getBuffer(), 0, cArray2, 0, cArray2.length);
                    arrayList.add(cArray2);
                    charBuffer.clear();
                } else if (n == 39) {
                    charBuffer.append('\'');
                    ++n2;
                    while (n2 < string.length() && string.charAt(n2) != '\'') {
                        charBuffer.append(string.charAt(n2));
                        ++n2;
                    }
                    charBuffer.append('\'');
                } else {
                    charBuffer.append((char)n);
                }
                ++n2;
            }
            char[] cArray3 = new char[charBuffer.getLength()];
            System.arraycopy(charBuffer.getBuffer(), 0, cArray3, 0, cArray3.length);
            arrayList.add(cArray3);
            cArray = new char[arrayList.size()][];
            n = 0;
            while (n < arrayList.size()) {
                cArray[n] = (char[])arrayList.get(n);
                ++n;
            }
            cache.put((Object)string, (Object)cArray);
        }
        preparedStatement.staticChunks = cArray;
        preparedStatement.parameters = new CharBuffer[cArray.length - 1];
        preparedStatement.values = new Object[cArray.length - 1];
        int n = 0;
        while (n < preparedStatement.parameters.length) {
            preparedStatement.parameters[n] = new CharBuffer();
            preparedStatement.values[n] = null;
            ++n;
        }
        return preparedStatement;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n].clear();
            ++n;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append("null");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(bl ? "'t'" : "'f'");
    }

    public void setByte(int n, byte by) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append((int)by);
    }

    public void setShort(int n, short s) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append((int)s);
    }

    public void setInt(int n, int n2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(n2);
    }

    public void setLong(int n, long l) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(l);
    }

    public void setFloat(int n, float f) throws SQLException {
        char c;
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(f);
        int n2 = charBuffer.indexOf('E');
        if (n2 > 0 && n2 + 1 < charBuffer.length() && (c = charBuffer.charAt(n2 + 1)) != '+' && c != '-') {
            charBuffer.insert(n2 + 1, '+');
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        char c;
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(d);
        int n2 = charBuffer.indexOf('E');
        if (n2 > 0 && n2 + 1 < charBuffer.length() && (c = charBuffer.charAt(n2 + 1)) != '+' && c != '-') {
            charBuffer.insert(n2 + 1, '+');
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append((Object)bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        if (string == null) {
            charBuffer.append("null");
        } else {
            charBuffer.append('\'');
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c == '\'') {
                    charBuffer.append("\\'");
                } else if (c == '\"') {
                    charBuffer.append("\\\"");
                } else if (c == '\u0000') {
                    charBuffer.append("\\0");
                } else if (c == '\\') {
                    charBuffer.append("\\\\");
                } else {
                    charBuffer.append(c);
                }
                ++n3;
            }
            charBuffer.append('\'');
            if (this.encoding != null) {
                try {
                    byte[] byArray = charBuffer.toString().getBytes(this.encoding);
                    charBuffer.clear();
                    charBuffer.append(byArray, 0, byArray.length);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLExceptionWrapper(unsupportedEncodingException);
                }
            }
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        if (byArray == null) {
            charBuffer.append("null");
            return;
        }
        charBuffer.append('\'');
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            if (by == 39) {
                charBuffer.append("\\'");
            } else if (by == 34) {
                charBuffer.append("\\\"");
            } else if (by == 0) {
                charBuffer.append("\\0");
            } else if (by == 92) {
                charBuffer.append("\\\\");
            } else {
                charBuffer.append((char)by);
            }
            ++n2;
        }
        charBuffer.append('\'');
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date != null) {
            this.setTime(n, date.getTime());
        } else {
            this.setNull(n, 0);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time != null) {
            this.setTime(n, time.getTime());
        } else {
            this.setNull(n, 0);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp != null) {
            this.setTime(n, timestamp.getTime());
        } else {
            this.setNull(n, 0);
        }
    }

    private final void setTime(int n, long l) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(QDate.formatLocal((long)l, (String)"'%Y-%m-%d %H:%M:%S'"));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        TempBuffer tempBuffer;
        TempBuffer tempBuffer2 = tempBuffer = TempBuffer.allocate();
        if (this.values[n - 1] instanceof TempBuffer) {
            TempBuffer.freeAll((TempBuffer)((TempBuffer)this.values[n]));
        }
        this.values[n - 1] = tempBuffer;
        byte[] byArray = tempBuffer.getBuffer();
        int n3 = 0;
        byArray[n3++] = 39;
        try {
            int n4;
            while ((n4 = inputStream.read()) >= 0) {
                if (n3 + 3 >= byArray.length) {
                    tempBuffer2.setLength(n3);
                    TempBuffer tempBuffer3 = TempBuffer.allocate();
                    tempBuffer2.setNext(tempBuffer3);
                    tempBuffer2 = tempBuffer3;
                    byArray = tempBuffer3.getBuffer();
                    n3 = 0;
                }
                if (n4 == 39) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 39;
                    continue;
                }
                if (n4 == 34) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 34;
                    continue;
                }
                if (n4 == 92) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 92;
                    continue;
                }
                if (n4 == 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 48;
                    continue;
                }
                byArray[n3++] = (byte)n4;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
        byArray[n3++] = 39;
        tempBuffer2.setLength(n3);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        TempBuffer tempBuffer;
        CharBuffer charBuffer = this.getParameterBuffer(n);
        TempBuffer tempBuffer2 = tempBuffer = TempBuffer.allocate();
        if (this.values[n - 1] instanceof TempBuffer) {
            TempBuffer.freeAll((TempBuffer)((TempBuffer)this.values[n]));
        }
        this.values[n - 1] = tempBuffer;
        byte[] byArray = tempBuffer.getBuffer();
        int n3 = 0;
        byArray[n3++] = 39;
        try {
            int n4;
            while ((n4 = reader.read()) >= 0) {
                if (n3 + 3 >= byArray.length) {
                    tempBuffer2.setLength(n3);
                    TempBuffer tempBuffer3 = TempBuffer.allocate();
                    tempBuffer2.setNext(tempBuffer3);
                    tempBuffer2 = tempBuffer3;
                    byArray = tempBuffer3.getBuffer();
                    n3 = 0;
                }
                if (n4 == 39) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 39;
                    continue;
                }
                if (n4 == 34) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 34;
                    continue;
                }
                if (n4 == 92) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 92;
                    continue;
                }
                if (n4 == 0) {
                    byArray[n3++] = 92;
                    byArray[n3++] = 48;
                    continue;
                }
                byArray[n3++] = (byte)n4;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(iOException));
        }
        byArray[n3++] = 39;
        tempBuffer2.setLength(n3);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        CharBuffer charBuffer = this.getParameterBuffer(n);
        charBuffer.append(object);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else {
            CharBuffer charBuffer = this.getParameterBuffer(n);
            charBuffer.append(object);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
    }

    public void setBlob(int n, Blob blob) throws SQLException {
    }

    public void setClob(int n, Clob clob) throws SQLException {
    }

    public void setArray(int n, Array array) throws SQLException {
    }

    private final CharBuffer getParameterBuffer(int n) throws SQLException {
        this.parameters[n - 1].clear();
        this.values[n - 1] = null;
        return this.parameters[n - 1];
    }

    public void addBatch() throws SQLException {
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        if (this.wasResultSet) {
            return this.resultSet;
        }
        throw new SQLException("missing result set");
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        return this.updateCount;
    }

    public boolean execute() throws SQLException {
        this.cb.clear();
        int n = 0;
        while (n < this.parameters.length) {
            this.cb.append(this.staticChunks[n]);
            if (this.values[n] != null) {
                if (this.values[n] instanceof TempBuffer) {
                    TempBuffer tempBuffer = (TempBuffer)this.values[n];
                    while (tempBuffer != null) {
                        this.cb.append(tempBuffer.getBuffer(), 0, tempBuffer.getLength());
                        tempBuffer = tempBuffer.getNext();
                    }
                }
            } else if (this.parameters[n].getLength() == 0) {
                this.cb.append("null");
            } else {
                this.cb.append(this.parameters[n]);
            }
            ++n;
        }
        this.cb.append(this.staticChunks[this.parameters.length]);
        this.clearParameters();
        return this.execute(this.cb);
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Statement.freeResultSets.free((Object)this.resultSet);
        this.conn = null;
        this.dbConn = null;
    }

    public void setURL(int n, URL uRL) {
        throw new UnsupportedOperationException();
    }

    public ParameterMetaData getParameterMetaData() {
        throw new UnsupportedOperationException();
    }

    PreparedStatement() {
    }
}

