/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.AbstractColumn;
import com.caucho.jdbc.mysql.AbstractResultSet;
import com.caucho.jdbc.mysql.Column;
import com.caucho.jdbc.mysql.DatabaseConnection;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.QDate;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

class ResultSet
extends AbstractResultSet {
    private static QDate date = new QDate();
    private int nColumns;
    private Column[] columns;
    private byte[] buf = new byte[8192];
    private int[] offsets;
    private int[] lengths;
    private int topColumn;
    private int topOffset;
    private DatabaseConnection dbConn;
    private ByteInputStream byteInputStream;
    private VfsStream streamImpl;
    private ReadStream readStream;
    int len;

    void init(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        this.dbConn = databaseConnection;
        this.rowNumber = 0;
        this.byteInputStream = null;
        if (this.readStream != null) {
            try {
                this.readStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public AbstractColumn getColumn(int n) {
        return this.columns[n - 1];
    }

    public int findColumn(String string) throws SQLException {
        this.cb.clear();
        this.cb.append(string);
        int n = 0;
        while (n < this.nColumns) {
            if (this.columns[n].name.equals((CharSegment)this.cb)) {
                return n + 1;
            }
            ++n;
        }
        throw new SQLException("No such column `" + string + "'");
    }

    protected int getOffset(int n) throws SQLException {
        while (this.topColumn < n - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        return this.offsets[n - 1];
    }

    protected int getLength(int n) throws SQLException {
        while (this.topColumn < n - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        int n2 = this.lengths[n - 1];
        this.wasNull = n2 < 0;
        return n2;
    }

    protected byte[] getBuffer(int n) throws SQLException {
        int n2 = this.getLength(n);
        if (n2 > 256) {
            return null;
        }
        if (this.topColumn < n) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        if (this.rowNumber > 0) {
            return n2 <= 256 ? this.buf : null;
        }
        if (this.rowNumber == 0) {
            throw new SQLException("expected next() before getting column");
        }
        throw new SQLException("can't get column after next() returns false");
    }

    protected InputStream getInputStream(int n) throws SQLException {
        while (this.topColumn < n - 1) {
            try {
                this.readColumns();
            }
            catch (IOException iOException) {
                throw new SQLException(String.valueOf(iOException));
            }
        }
        int n2 = this.lengths[n - 1];
        if (this.rowNumber == 0) {
            throw new SQLException("expected next() before getting column");
        }
        if (this.rowNumber < 0) {
            throw new SQLException("can't get column after next() returns false");
        }
        if (n2 <= 256) {
            return null;
        }
        if (this.topColumn != n - 1) {
            throw new SQLException("input stream no longer live");
        }
        this.byteInputStream = new ByteInputStream(this.dbConn, n2);
        return this.byteInputStream;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (this.readStream == null) {
            this.streamImpl = new VfsStream(null, null);
            this.readStream = new ReadStream();
            this.readStream.setReuseBuffer(true);
            this.readStream.init((StreamImpl)this.streamImpl, null);
        }
        this.streamImpl.init(this.getBinaryStream(n), null);
        this.readStream.init((StreamImpl)this.streamImpl, null);
        return this.readStream.getReader();
    }

    public boolean getBoolean(int n) throws SQLException {
        int n2 = this.getLength(n);
        int n3 = this.getOffset(n);
        byte[] byArray = this.getBuffer(n);
        Column column = this.columns[n - 1];
        switch (column.type) {
            case 0: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                if (n2 == 0) {
                    return false;
                }
                if (n2 > 1) {
                    return true;
                }
                return byArray[n3] != 48;
            }
            case 4: 
            case 5: {
                if (n2 == 0) {
                    return false;
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (byArray[n3 + n4] != 48 && byArray[n3 + n4] != 46) {
                        return true;
                    }
                    ++n4;
                }
                return false;
            }
        }
        if (n2 == 1) {
            return byArray[n3] != 48 && byArray[n3] != 110 && byArray[n3] != 78 && byArray[n3] != 102 && byArray[n3] != 70;
        }
        return n2 > 1;
    }

    public int getInt(int n) throws SQLException {
        switch (this.columns[n - 1].type) {
            case 4: 
            case 5: {
                return (int)this.getDouble(n);
            }
        }
        return super.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        switch (this.columns[n - 1].type) {
            case 4: 
            case 5: {
                return (long)this.getDouble(n);
            }
        }
        return super.getLong(n);
    }

    /*
     * Unable to fully structure code
     */
    protected long getDateAsLong(int var1_1) throws SQLException {
        block34: {
            block35: {
                block33: {
                    var2_2 = this.getOffset(var1_1);
                    var3_3 = this.getLength(var1_1);
                    var4_4 = var2_2 + var3_3;
                    var5_5 = this.getBuffer(var1_1);
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    var9_9 = 0;
                    var10_10 = 0;
                    var11_11 = 0;
                    var12_12 = var2_2;
                    var13_13 = 32;
                    if (!this.wasNull && var3_3 >= 0) ** GOTO lbl16
                    return 0L;
lbl-1000:
                    // 1 sources

                    {
                        ++var12_12;
lbl16:
                        // 2 sources

                        ** while (var12_12 < var4_4 && (var5_5[var12_12] == 32 || var5_5[var12_12] == 9))
                    }
lbl17:
                    // 1 sources

                    var14_14 = var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 4) {
                        var6_6 = 10 * var6_6 + var5_5[var12_12] - 48;
                        ++var12_12;
                    }
                    if (var13_13 != 45) break block33;
                    if (var6_6 <= 100) {
                        var6_6 = var6_6 < 50 ? (var6_6 += 2000) : (var6_6 += 1900);
                    }
                    ++var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var7_7 = 10 * var7_7 + var13_13 - 48;
                        ++var12_12;
                    }
                    if (var13_13 != 45 || var7_7 > 12) {
                        throw new SQLException("bad date " + this.getString(var1_1));
                    }
                    ++var12_12;
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var8_8 = 10 * var8_8 + var13_13 - 48;
                        ++var12_12;
                    }
                    if (var8_8 <= 0 || var8_8 > 31) {
                        throw new SQLException("bad date " + this.getString(var1_1));
                    }
                    --var8_8;
                    while (var12_12 < var4_4 && ((var13_13 = var5_5[var12_12]) < 48 || var13_13 > 57)) {
                        ++var12_12;
                    }
                    while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                        var9_9 = 10 * var9_9 + var13_13 - 48;
                        ++var12_12;
                    }
                    break block34;
                }
                if (var12_12 - var14_14 < 4 || var13_13 < 48 || var13_13 > 57) break block35;
                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var7_7 = 10 * var7_7 + var13_13 - 48;
                    ++var12_12;
                }
                if (var7_7 > 12) {
                    throw new SQLException("bad date " + this.getString(var1_1));
                }
                if (var13_13 == 45) {
                    ++var12_12;
                }
                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var8_8 = 10 * var8_8 + var13_13 - 48;
                    ++var12_12;
                }
                if (--var8_8 >= 0 && var8_8 < 31) ** GOTO lbl67
                throw new SQLException("bad date " + this.getString(var1_1));
lbl-1000:
                // 1 sources

                {
                    ++var12_12;
lbl67:
                    // 2 sources

                    ** while (var12_12 < var4_4 && ((var13_13 = var5_5[var12_12]) == 32 || var13_13 == 84))
                }
lbl68:
                // 1 sources

                var14_14 = var12_12;
                while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                    var9_9 = 10 * var9_9 + var13_13 - 48;
                    ++var12_12;
                }
                break block34;
            }
            if (var6_6 > 23) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
            var9_9 = var6_6;
            var6_6 = 0;
            if (var13_13 != 58) {
                throw new SQLException("bad date at `" + (char)var13_13 + "' " + var12_12 + " " + var14_14 + " " + this.getString(var1_1));
            }
        }
        if (var13_13 == 58) {
            ++var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                var10_10 = 10 * var10_10 + var13_13 - 48;
                ++var12_12;
            }
            if (var10_10 >= 60) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
        } else if (var13_13 >= 48 && var13_13 <= 57) {
            var14_14 = var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                var10_10 = 10 * var10_10 + var13_13 - 48;
                ++var12_12;
            }
        }
        if (var13_13 == 58) {
            ++var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57) {
                var11_11 = 10 * var11_11 + var13_13 - 48;
                ++var12_12;
            }
            if (var11_11 >= 60) {
                throw new SQLException("bad date " + this.getString(var1_1));
            }
        } else if (var13_13 >= 48 && var13_13 <= 57) {
            var14_14 = var12_12;
            while (var12_12 < var4_4 && (var13_13 = var5_5[var12_12]) >= 48 && var13_13 <= 57 && var12_12 - var14_14 < 2) {
                var11_11 = 10 * var11_11 + var13_13 - 48;
                ++var12_12;
            }
        }
        var15_15 = 0L;
        var17_16 = ResultSet.date;
        synchronized (var17_16) {
            ResultSet.date.setTime(0L);
            if (var6_6 > 0) {
                ResultSet.date.setDate((long)var6_6, (long)(var7_7 - 1), (long)var8_8);
            }
            ResultSet.date.setTime((long)var9_9, (long)var10_10, (long)var11_11, 0L);
            var15_15 = ResultSet.date.getTime() - ResultSet.date.getZoneOffset();
        }
        return var15_15;
    }

    void clear() {
    }

    void setColumns(int n) {
        this.nColumns = n;
        if (this.columns == null || n > this.columns.length) {
            int n2 = n < 16 ? 16 : n;
            this.columns = new Column[n2];
            this.offsets = new int[n2];
            this.lengths = new int[n2];
        }
    }

    void allocColumn(int n) {
        Column column = this.columns[n];
        if (column == null) {
            this.columns[n] = column = new Column();
        }
        column.table.clear();
        column.name.clear();
    }

    CharBuffer getName(int n) {
        return this.columns[n].name;
    }

    CharBuffer getTable(int n) {
        return this.columns[n].table;
    }

    void setColumn(int n, int n2, int n3, int n4, int n5) {
        Column column = this.columns[n];
        if (column == null) {
            this.columns[n] = column = new Column();
        }
        column.init(n2, n3, n4, n5);
    }

    public boolean next() throws SQLException {
        if (this.dbConn == null) {
            return false;
        }
        if (this.rowNumber < 0) {
            this.dbConn.completeResult();
            this.dbConn = null;
            return false;
        }
        try {
            int n = this.dbConn.next();
            if (n == Integer.MIN_VALUE) {
                this.rowNumber = -1;
                this.dbConn.completeResult();
                this.dbConn = null;
                return false;
            }
            ++this.rowNumber;
            this.offsets[0] = 0;
            this.lengths[0] = n;
            this.topColumn = 0;
            this.topOffset = 0;
            if (n <= 256) {
                this.readColumns();
            }
            return true;
        }
        catch (IOException iOException) {
            this.rowNumber = -1;
            if (this.dbConn != null) {
                this.dbConn.completeResult();
            }
            this.dbConn = null;
            throw new SQLException("io: " + iOException);
        }
    }

    void readColumns() throws IOException {
        int n = this.dbConn.getReadLength();
        int n2 = this.topOffset;
        int n3 = this.topColumn;
        do {
            int n4;
            if ((n4 = this.lengths[this.topColumn++]) > 0) {
                if (n4 <= 256) {
                    this.dbConn.read(this.buf, n2, n4);
                    n2 += n4;
                } else if (this.byteInputStream != null) {
                    this.byteInputStream.close();
                } else {
                    this.dbConn.skip(n4);
                }
            }
            if (this.topColumn >= this.nColumns) break;
            this.len = this.dbConn.readLength();
            this.offsets[this.topColumn] = n2;
            this.lengths[this.topColumn] = this.len;
        } while (this.len <= 256);
        this.topOffset = n2;
    }

    int getNColumns() {
        return this.nColumns;
    }

    void readColumn(int n, int n2) throws IOException {
        int n3;
        this.offsets[n] = n == 0 ? 0 : ((n3 = this.lengths[n - 1]) < 0 ? this.offsets[n - 1] : this.offsets[n - 1] + n3);
        if (n2 > 0) {
            this.dbConn.read(this.buf, this.offsets[n], n2);
            this.lengths[n] = n2;
        } else {
            this.lengths[n] = -1;
        }
    }

    public void close() throws SQLException {
        while (this.dbConn != null && this.rowNumber >= 0 && this.next()) {
        }
        this.rowNumber = -1;
    }

    ResultSet() {
    }

    static class ByteInputStream
    extends InputStream {
        DatabaseConnection dbConn;
        int length;

        public int read() throws IOException {
            if (this.length > 0) {
                --this.length;
                int n = this.dbConn.read();
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.length <= 0) {
                return -1;
            }
            if (this.length < n2) {
                n2 = this.length;
            }
            int n3 = this.dbConn.read(byArray, n, n2);
            this.length -= n3;
            return n3;
        }

        public void close() throws IOException {
            if (this.length > 0) {
                this.dbConn.skip(this.length);
            }
            this.length = -1;
        }

        ByteInputStream(DatabaseConnection databaseConnection, int n) {
            this.dbConn = databaseConnection;
            this.length = n;
        }
    }
}

