/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc.mysql;

import com.caucho.jdbc.mysql.Connection;
import com.caucho.jdbc.mysql.DatabaseConnection;
import com.caucho.jdbc.mysql.ResultSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;

class Statement
implements java.sql.Statement {
    private static WriteStream dbg = LogStream.open((String)"/caucho.com/jdbc/statement");
    protected static FreeList freeResultSets = new FreeList(16);
    protected Connection conn;
    protected DatabaseConnection dbConn;
    protected String encoding;
    protected boolean wasResultSet;
    protected int updateCount = -1;
    protected ResultSet resultSet;
    protected CharBuffer cb = new CharBuffer();
    protected int maxRows = 1;

    protected void init(Connection connection) {
        this.conn = connection;
        this.dbConn = connection.getDatabaseConnection();
        this.encoding = connection.getEncoding();
        this.resultSet.init(connection, this);
        this.updateCount = -1;
        this.wasResultSet = false;
    }

    public void addBatch(String string) {
    }

    public void cancel() {
    }

    public void clearBatch() {
    }

    public void clearWarnings() {
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Connection connection = this.conn;
        this.conn = null;
        this.dbConn = null;
        if (connection != null) {
            connection.free(this);
        }
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string);
        return this.wasResultSet ? this.resultSet : null;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string);
        if (this.wasResultSet) {
            this.resultSet.close();
        }
        return this.updateCount;
    }

    public boolean execute(String string) throws SQLException {
        this.cb.clear();
        this.cb.append(string);
        return this.execute(this.cb);
    }

    protected boolean execute(CharBuffer charBuffer) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("statement is closed");
        }
        this.updateCount = -1;
        this.wasResultSet = false;
        try {
            this.updateCount = this.dbConn.execute(charBuffer, this.resultSet);
            if (this.updateCount < 0) {
                this.wasResultSet = true;
            }
        }
        catch (IOException iOException) {
            dbg.log((Throwable)iOException);
            throw new SQLException(iOException.toString());
        }
        return this.wasResultSet;
    }

    public int[] executeBatch() throws SQLException {
        return null;
    }

    public java.sql.ResultSet getResultSet() {
        return this.wasResultSet ? this.resultSet : null;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public java.sql.Connection getConnection() {
        return this.conn;
    }

    public int getFetchDirection() {
        return 0;
    }

    public int getFetchSize() {
        return 0;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public boolean getMoreResults() {
        return false;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public int getResultSetConcurrency() {
        return 0;
    }

    public int getResultSetType() {
        return 0;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void setCursorName(String string) {
    }

    public void setEscapeProcessing(boolean bl) {
    }

    public void setFetchDirection(int n) {
    }

    public void setFetchSize(int n) {
    }

    public void setMaxFieldSize(int n) {
    }

    public void setQueryTimeout(int n) {
    }

    public boolean getMoreResults(int n) {
        throw new UnsupportedOperationException();
    }

    public java.sql.ResultSet getGeneratedKeys() {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String string, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String string, String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String string, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String string, String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    Statement() {
        this.resultSet = (ResultSet)freeResultSets.allocate();
        if (this.resultSet == null) {
            this.resultSet = new ResultSet();
        }
    }
}

