/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public abstract class SAXParserFactory {
    private static String FACTORY_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static String DEFAULT_FACTORY = "com.caucho.xml.parsers.XmlSAXParserFactory";
    private boolean isNamespaceAware = false;
    private boolean isValidating = false;

    public static SAXParserFactory newInstance() {
        String className = SAXParserFactory.getFactoryClassName();
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                cl = Class.forName(className, false, loader);
            }
        }
        catch (NoSuchMethodError e) {
        }
        catch (ClassNotFoundException e) {
            throw new FactoryConfigurationError(e);
        }
        if (cl == null) {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new FactoryConfigurationError(e);
            }
        }
        try {
            return (SAXParserFactory)cl.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new FactoryConfigurationError(e);
        }
        catch (InstantiationException e) {
            throw new FactoryConfigurationError(e);
        }
    }

    private static String getFactoryClassName() {
        String className = null;
        try {
            className = System.getProperty(FACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String serviceName = "META-INF/services/" + FACTORY_PROPERTY;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader != null ? loader.getResourceAsStream(serviceName) : ClassLoader.getSystemResourceAsStream(serviceName);
            InputStreamReader rawReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(rawReader);
            className = reader.readLine();
            reader.close();
            is.close();
            if (className != null) {
                className = className.trim();
            }
            if (className != null && !"".equals(className)) {
                return className;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String javaHome = System.getProperty("java.home");
            String sep = File.separator;
            String propFile = javaHome + sep + "lib" + sep + "jaxp.properties";
            FileInputStream is = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(is);
            ((InputStream)is).close();
            className = props.getProperty(FACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (Throwable e) {}
        return DEFAULT_FACTORY;
    }

    public abstract boolean getFeature(String var1) throws SAXNotRecognizedException;

    public abstract void setFeature(String var1, boolean var2) throws SAXNotRecognizedException;

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public void setNamespaceAware(boolean aware) {
        this.isNamespaceAware = aware;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setValidating(boolean validating) {
        this.isValidating = validating;
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;
}

