/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private Throwable rootCause;
    private SourceLocator locator;

    public TransformerException(String msg) {
        super(msg);
    }

    public TransformerException(String msg, SourceLocator locator) {
        super(msg);
        this.locator = locator;
    }

    public TransformerException(String msg, SourceLocator locator, Throwable e) {
        super(msg);
        this.rootCause = e;
        this.locator = locator;
    }

    public TransformerException(String msg, Throwable e) {
        super(msg);
        this.rootCause = e;
    }

    public TransformerException(Throwable e) {
        this.rootCause = e;
    }

    public synchronized Throwable initCause(Throwable cause) {
        this.rootCause = this.rootCause;
        return this;
    }

    public Throwable getCause() {
        return this.rootCause == this ? null : this.rootCause;
    }

    public Throwable getException() {
        return this.rootCause;
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator locator) {
        this.locator = locator;
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        return this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ":";
    }

    public String getMessageAndLocation() {
        StringBuffer sbuf = new StringBuffer();
        String msg = super.getMessage();
        if (this.locator != null) {
            sbuf.append(this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ": ");
        }
        if (msg != null) {
            sbuf.append(msg);
        }
        return sbuf.toString();
    }

    public void printStackTrace() {
        if (this.rootCause != null) {
            this.rootCause.printStackTrace();
        }
        super.printStackTrace();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.rootCause != null) {
            this.rootCause.printStackTrace(ps);
        }
        super.printStackTrace(ps);
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.rootCause != null) {
            this.rootCause.printStackTrace(pw);
        }
        super.printStackTrace(pw);
    }
}

