/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.sax;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SAXSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.sax.SAXSource/feature";
    private InputSource source;
    private XMLReader reader;

    public SAXSource() {
    }

    public SAXSource(InputSource source) {
        this.source = source;
    }

    public SAXSource(XMLReader reader, InputSource source) {
        this.reader = reader;
        this.source = source;
    }

    public InputSource getInputSource() {
        return this.source;
    }

    public void setInputSource(InputSource source) {
        this.source = source;
    }

    public String getSystemId() {
        if (this.source == null) {
            return null;
        }
        return this.source.getSystemId();
    }

    public void setSystemId(String systemId) {
        if (this.source == null) {
            this.source = new InputSource(systemId);
        } else {
            this.source.setSystemId(systemId);
        }
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    public void setXMLReader(XMLReader reader) {
        this.reader = reader;
    }

    public static InputSource sourceToInputSource(Source source) {
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource();
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            return isource;
        }
        return null;
    }
}

