/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;

public class StreamResult
implements Result {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamResult/feature";
    private OutputStream outputStream;
    private Writer writer;
    private String systemId;

    public StreamResult() {
    }

    public StreamResult(File file) {
        this.setSystemId(file);
    }

    public StreamResult(OutputStream os) {
        this.outputStream = os;
    }

    public StreamResult(Writer writer) {
        this.writer = writer;
    }

    public StreamResult(String systemId) {
        this.systemId = systemId;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setSystemId(File file) {
        this.systemId = this.normalizeFilename(file);
    }

    private String normalizeFilename(File file) {
        String path = file.getAbsolutePath();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("file:");
        if (!path.startsWith("/")) {
            sbuf.append('/');
        }
        int i = 0;
        while (i < path.length()) {
            char ch = path.charAt(i);
            if (ch == '\\') {
                if (i != 0) {
                    sbuf.append('/');
                }
            } else {
                sbuf.append(ch);
            }
            ++i;
        }
        return sbuf.toString();
    }
}

