/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;

public class StreamSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamSource/feature";
    private InputStream inputStream;
    private Reader reader;
    private String systemId;
    private String publicId;

    public StreamSource() {
    }

    public StreamSource(File file) {
        this.setSystemId(file);
    }

    public StreamSource(InputStream is) {
        this.inputStream = is;
    }

    public StreamSource(InputStream is, String systemId) {
        this.inputStream = is;
        this.systemId = systemId;
    }

    public StreamSource(Reader reader) {
        this.reader = reader;
    }

    public StreamSource(Reader reader, String systemId) {
        this.reader = reader;
        this.systemId = systemId;
    }

    public StreamSource(String systemId) {
        this.systemId = systemId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setSystemId(File file) {
        this.systemId = this.normalizeFilename(file);
    }

    private String normalizeFilename(File file) {
        String path = file.getAbsolutePath();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("file:");
        if (!path.startsWith("/")) {
            sbuf.append('/');
        }
        int i = 0;
        while (i < path.length()) {
            char ch = path.charAt(i);
            if (ch == '\\') {
                if (i != 0) {
                    sbuf.append('/');
                }
            } else {
                sbuf.append(ch);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }
}

