/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web;

import com.caucho.util.Tree;
import java.util.ArrayList;
import java.util.Iterator;

public class NavItem {
    Tree tree;
    String title;
    String link;
    String description;
    String brief;

    NavItem() {
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    Tree getTree() {
        return this.tree;
    }

    public NavItem getParent() {
        if (this.tree == null) {
            return null;
        }
        Tree tree = this.tree.getParent();
        return tree == null ? null : (NavItem)tree.getData();
    }

    public Iterator children() {
        return this.tree.iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getBrief() {
        return this.brief;
    }

    public void setBrief(String string) {
        this.brief = string;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public NavItem getPrevious() {
        Tree tree = this.tree.getPrevious();
        if (tree == null) {
            return null;
        }
        return (NavItem)tree.getData();
    }

    public NavItem getPreviousPreorder() {
        Tree tree = this.tree.getPreviousPreorder();
        if (tree == null) {
            return null;
        }
        return (NavItem)tree.getData();
    }

    public NavItem getNext() {
        Tree tree = this.tree.getNext();
        if (tree == null) {
            return null;
        }
        return (NavItem)tree.getData();
    }

    public NavItem getNextPreorder() {
        Tree tree = this.tree.getNextPreorder();
        if (tree == null) {
            return null;
        }
        return (NavItem)tree.getData();
    }

    public ArrayList familyNavigation() {
        ArrayList arrayList = new ArrayList();
        this.familyNavigation(this.tree, arrayList);
        return arrayList;
    }

    private boolean familyNavigation(Tree tree, ArrayList arrayList) {
        if (tree == null) {
            return false;
        }
        boolean bl = false;
        if (tree.getParent() != null) {
            bl = this.familyNavigation(tree.getParent(), arrayList);
        }
        Iterator iterator = tree.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            NavItem navItem = (NavItem)iterator.next();
            if (!bl2 && bl) {
                arrayList.add(null);
            }
            bl2 = true;
            arrayList.add(navItem);
        }
        return bl2 || bl;
    }

    public String toString() {
        return "[NavItem title='" + this.title + "' link='" + this.link + "']";
    }
}

