/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web;

import com.caucho.util.Tree;
import com.caucho.vfs.Path;
import com.caucho.web.NavItem;
import com.caucho.xml.LooseXml;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Navigation {
    private Element root;
    private String base;
    private Tree tree;
    static Expr linkPattern;
    static Expr titlePattern;
    static Expr descPattern;

    public Navigation() {
    }

    public Navigation(Path path, String string) throws Exception {
        Document document = new LooseXml().parseDocument(path);
        this.init(document.getDocumentElement(), string);
    }

    public Navigation(Element element, String string) throws Exception {
        this.init(element, string);
    }

    public void init(Element element, String string) throws Exception {
        this.tree = new Tree(null);
        this.root = element;
        if (string == null || string == "") {
            string = "/";
        }
        this.base = string;
        if (element != null) {
            this.fillChildren(this.tree, element.getFirstChild(), string);
        }
    }

    public static Navigation createNested(Path path, String string) throws Exception {
        Navigation navigation = null;
        Object var3_3 = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = string;
        while (true) {
            Path path2 = path.lookup(string2).lookup("toc.xml");
            Navigation navigation2 = null;
            if (path2.exists()) {
                navigation2 = new Navigation(path2, string2);
            }
            if (navigation == null) {
                navigation = navigation2;
            } else if (navigation2 != null) {
                navigation.linkParent(navigation2);
            }
            if (string2.equals("")) break;
            int n = string2.endsWith("/") ? string2.lastIndexOf(47, string2.length() - 2) : string2.lastIndexOf(47);
            if (n <= 0) {
                string2 = "";
                continue;
            }
            string2 = string2.substring(0, n + 1);
        }
        return navigation;
    }

    public static Navigation createNested(ArrayList arrayList, String string) throws Exception {
        Navigation navigation = null;
        Object var3_3 = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = string;
        int n = 0;
        while (n < arrayList.size()) {
            Path path = ((Path)arrayList.get(n)).lookup("toc.xml");
            Navigation navigation2 = null;
            if (path.exists()) {
                navigation2 = new Navigation(path, string2);
            }
            if (navigation == null) {
                navigation = navigation2;
            } else if (navigation2 != null) {
                navigation.linkParent(navigation2);
            }
            if (string2.equals("")) break;
            int n2 = string2.endsWith("/") ? string2.lastIndexOf(47, string2.length() - 2) : string2.lastIndexOf(47);
            string2 = n2 <= 0 ? "" : string2.substring(0, n2 + 1);
            ++n;
        }
        return navigation;
    }

    public Navigation linkParent(Navigation navigation) {
        if (this.tree == null) {
            this.tree = navigation.tree;
            return this;
        }
        if (this.tree.getFirst() == null) {
            return this;
        }
        NavItem navItem = (NavItem)this.tree.getFirst().getData();
        NavItem navItem2 = navigation.findURL(navItem.getLink());
        if (navItem2 == null) {
            return null;
        }
        Tree tree = navItem2.getTree();
        this.linkTree(navItem2.getTree(), this.tree.getFirst());
        this.tree = navigation.tree;
        return this;
    }

    private void linkTree(Tree tree, Tree tree2) {
        Tree tree3 = tree2.getFirst();
        while (tree3 != null) {
            NavItem navItem = (NavItem)tree3.getData();
            Tree tree4 = tree.append((Object)navItem);
            navItem.setTree(tree4);
            this.linkTree(tree4, tree3);
            tree3 = tree3.getNext();
        }
    }

    public String getAttribute(String string) {
        if (this.root == null) {
            return "";
        }
        return this.root.getAttribute(string);
    }

    public NavItem findURL(String string) {
        if (this.tree == null) {
            return null;
        }
        string = this.normalizeURL(string);
        Iterator iterator = this.tree.dfs();
        while (iterator.hasNext()) {
            Tree tree = (Tree)iterator.next();
            NavItem navItem = (NavItem)tree.getData();
            if (!navItem.getLink().equals(string)) continue;
            return navItem;
        }
        return null;
    }

    private void fillChildren(Tree tree, Node node, String string) throws Exception {
        while (node != null) {
            if (node.getNodeName().equals("item")) {
                Element element = (Element)node;
                NavItem navItem = new NavItem();
                String string2 = linkPattern.evalString((Node)element);
                navItem.setLink(this.resolveURL(string2, node, string));
                navItem.setTitle(titlePattern.evalString((Node)element));
                String string3 = descPattern.evalString((Node)element);
                navItem.setDescription(string3);
                Tree tree2 = tree.append((Object)navItem);
                navItem.setTree(tree2);
                this.fillChildren(tree2, node.getFirstChild(), string);
            }
            node = node.getNextSibling();
        }
    }

    /*
     * Unable to fully structure code
     */
    private String resolveURL(String var1_1, Node var2_2, String var3_3) {
        if (var1_1.length() == 0) {
            return "/";
        }
        if (!var1_1.startsWith("http:") && var1_1.charAt(0) != '/') ** GOTO lbl12
        return this.normalizeURL(var1_1);
lbl-1000:
        // 1 sources

        {
            var4_4 = (Element)var2_2;
            var5_5 = var4_4.getAttribute("xml:base");
            if (!var5_5.equals("")) {
                if (!var5_5.endsWith("/")) {
                    return this.resolveURL(var5_5 + "/" + var1_1, var4_4.getParentNode(), var3_3);
                }
                return this.resolveURL(var5_5 + var1_1, var4_4.getParentNode(), var3_3);
            }
            var2_2 = var2_2.getParentNode();
lbl12:
            // 2 sources

            ** while (var2_2 instanceof Element)
        }
lbl13:
        // 1 sources

        if (!var3_3.endsWith("/")) {
            return this.normalizeURL(var3_3 + "/" + var1_1);
        }
        return this.normalizeURL(var3_3 + var1_1);
    }

    private String normalizeURL(String string) {
        if (string.startsWith("/")) {
            return string;
        }
        if (!string.startsWith("http://")) {
            return "/" + string;
        }
        int n = "http://".length();
        while (n < string.length()) {
            if (string.charAt(n) == '/') {
                return string.substring(n);
            }
            ++n;
        }
        return "/";
    }

    static {
        try {
            linkPattern = XPath.parseExpr((String)"if(@link,@link,link)");
            titlePattern = XPath.parseExpr((String)"if(@title,@title,title)");
            descPattern = XPath.parseExpr((String)"if(@description,@description,description)");
        }
        catch (Exception exception) {}
    }
}

