/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.search;

import com.caucho.util.CharBuffer;
import com.caucho.web.search.Store;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class SearchServlet
extends HttpServlet {
    DataSource dataSource;
    Store store;

    public void init() throws ServletException {
        String string = this.getInitParameter("data-source");
        if (string == null) {
            string = "jdbc/search";
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.dataSource = (DataSource)initialContext.lookup("java:comp/env/" + string);
            if (this.dataSource == null) {
                throw new ServletException("no data source: " + string);
            }
            this.store = new Store(this.dataSource);
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("x-application/xsl");
        String string = httpServletRequest.getParameter("query");
        if (string == null || string.equals("")) {
            printWriter.println("<?xml version='1.0'?>");
            printWriter.println("<?xml-stylesheet href='search.xsl'?>");
            printWriter.println("<html><head>");
            printWriter.print("<title>");
            printWriter.print("No Search Results");
            printWriter.println("</title></head><body>");
            printWriter.println("<section title='No Search Results for empty query'/>");
            printWriter.println("</body></html>");
            return;
        }
        string = this.escapeQuery(string);
        String string2 = httpServletRequest.getParameter("index");
        int n = 0;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        Connection connection = null;
        try {
            try {
                block22: {
                    block21: {
                        Object object;
                        connection = this.dataSource.getConnection();
                        Statement statement = connection.createStatement();
                        ResultSet resultSet = this.store.search(statement, string, n, 11);
                        printWriter.println("<?xml version='1.0'?>");
                        printWriter.println("<?xml-stylesheet href='search.xsl'?>");
                        printWriter.println("<html><head>");
                        printWriter.print("<title>");
                        printWriter.print("Search Results");
                        printWriter.println("</title></head><body>");
                        int n2 = 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        while (true) {
                            if (resultSet == null || !resultSet.next()) {
                                if (!bl) break block21;
                                printWriter.println("</section>");
                                if (bl2) {
                                    break;
                                }
                                break block22;
                            }
                            if (++n2 > 10) {
                                bl2 = true;
                                continue;
                            }
                            if (!bl) {
                                printWriter.println("<section title='Query: " + this.escape(string) + "'>");
                            }
                            bl = true;
                            object = resultSet.getString(1);
                            String string3 = resultSet.getString(2);
                            String string4 = resultSet.getString(3);
                            printWriter.println("<item>");
                            printWriter.print("<url>");
                            printWriter.print(this.escape((String)object));
                            printWriter.println("</url>");
                            printWriter.print("<title>");
                            if (string3 != null && !string3.equals("")) {
                                printWriter.print(this.escape(string3));
                            }
                            printWriter.println("</title>");
                            printWriter.print("<description>");
                            printWriter.print(this.escape(string4));
                            printWriter.println("</description>");
                            printWriter.println("</item>");
                        }
                        object = CharBuffer.allocate();
                        n2 = 0;
                        while (true) {
                            if (n2 >= string.length()) {
                                printWriter.println("<br/><br/><a href='/search?query=" + object + "&amp;index=" + (n + 10) + "'>More Results</a>");
                                break block22;
                            }
                            char c = string.charAt(n2);
                            if (Character.isWhitespace(c)) {
                                object.append("+");
                            } else if (c != '\'' && c != '&' && c != '+' && c != '\\') {
                                object.append(c);
                            }
                            ++n2;
                        }
                    }
                    printWriter.println("<section>No Search Results</section>");
                }
                printWriter.println("</body></html>");
            }
            catch (SQLException sQLException) {
                throw new ServletException((Throwable)sQLException);
            }
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    String escapeQuery(String string) {
        if (string == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.allocate();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\'' && c != '\\' && c != '<' && c != '>') {
                charBuffer.append(c);
            }
            ++n;
        }
        return charBuffer.close();
    }

    String escape(String string) {
        if (string == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.allocate();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                charBuffer.append("&lt;");
            } else if (c == '&') {
                charBuffer.append("&amp;");
            } else if (c == '\"') {
                charBuffer.append("&quot;");
            } else if (c == '\'') {
                charBuffer.append("&apos;");
            } else if (c < '\u0080') {
                charBuffer.append(c);
            }
            ++n;
        }
        return charBuffer.close();
    }
}

