/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.search;

import com.caucho.util.IntMap;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.web.search.Page;
import com.caucho.web.search.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Spider {
    private static WriteStream dbg = LogStream.open((String)"/caucho.com/web/search");
    private static HashMap binaryExtensions = new HashMap();
    private IntMap completedPaths;
    private ArrayList pendingPaths;
    private Path root;
    private Store store;

    private Spider(Path path, Store store) {
        this.store = store;
        this.root = path;
        this.completedPaths = new IntMap();
        this.pendingPaths = new ArrayList();
        this.addPath(path);
    }

    public Store getStore() {
        return this.store;
    }

    public static Spider create(Path path, Store store) throws Exception {
        if (path.getScheme() == "file") {
            path = path.createRoot();
        }
        store.clearAll();
        return new Spider(path, store);
    }

    boolean hasNext() {
        return this.pendingPaths.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Path analyze() throws Exception {
        Object object;
        String string;
        ReadStream readStream;
        Page page;
        Path path;
        block23: {
            Path path2;
            block22: {
                Path path3;
                block21: {
                    if (this.pendingPaths.size() == 0) {
                        return null;
                    }
                    path = (Path)this.pendingPaths.remove(this.pendingPaths.size() - 1);
                    if (!this.isValidPage(path)) {
                        return null;
                    }
                    if (dbg.canWrite()) {
                        dbg.log("analyze : " + path);
                    }
                    page = null;
                    readStream = null;
                    try {
                        try {
                            readStream = path.openRead();
                            string = (String)readStream.getAttribute("status");
                            if (string != null && string.startsWith("302") && readStream.getAttribute("location") != null) {
                                block20: {
                                    String string2 = (String)readStream.getAttribute("location");
                                    try {
                                        path3 = path.getParent().lookup(string2);
                                        this.addPath(path3);
                                    }
                                    catch (RuntimeException runtimeException) {
                                        if (!dbg.canWrite()) break block20;
                                        dbg.log((Throwable)runtimeException);
                                    }
                                }
                                path3 = path;
                                Object var8_14 = null;
                                if (readStream == null) return path3;
                                break block21;
                            }
                            if (string != null && !string.equals("200")) {
                                if (dbg.canWrite()) {
                                    dbg.log("bad status from " + path + " " + string);
                                }
                                path2 = path;
                                break block22;
                            }
                            String string3 = (String)readStream.getAttribute("content-type");
                            page = Page.analyze(this, path, readStream, string3);
                            break block23;
                        }
                        catch (Exception exception) {
                            dbg.log((Throwable)exception);
                            Path path4 = path;
                            Object var8_17 = null;
                            if (readStream == null) return path4;
                            readStream.close();
                            return path4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_18 = null;
                        if (readStream != null) {
                            readStream.close();
                        }
                        throw throwable;
                    }
                }
                readStream.close();
                return path3;
            }
            Object var8_15 = null;
            if (readStream == null) return path2;
            readStream.close();
            return path2;
        }
        Path path5 = null;
        if (readStream != null) {
            readStream.close();
        }
        if (page == null) {
            return null;
        }
        string = page.getUrl();
        this.store.addPage(string, page.getTitle(), page.getDescription());
        int n = this.store.getPage(string);
        Iterator iterator = page.getWords();
        while (true) {
            if (!iterator.hasNext()) break;
            object = (Page.Word)iterator.next();
            try {
                this.store.addScore(n, ((Page.Word)object).getWord(), ((Page.Word)object).getScore());
            }
            catch (Exception exception) {
                if (!dbg.canWrite()) continue;
                dbg.log((Throwable)exception);
            }
        }
        object = page.getLinks();
        while (object.hasNext()) {
            path5 = (Path)object.next();
            this.addPath(path5);
        }
        return path;
    }

    boolean isValidPage(Path path) {
        String string;
        if (!path.getScheme().equals(this.root.getScheme())) {
            return false;
        }
        try {
            if (!path.getHost().equals(this.root.getHost())) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = path.getPath();
        int n = string2.lastIndexOf(46);
        return n <= 0 || binaryExtensions.get(string = string2.substring(n)) == null;
    }

    private void addPath(Path path) {
        if (path == null) {
            return;
        }
        if (this.completedPaths.get((Object)path) < 0) {
            this.pendingPaths.add(path);
            this.completedPaths.put((Object)path, 1);
        }
    }

    static {
        binaryExtensions.put(".gif", ".gif");
        binaryExtensions.put(".gz", ".gz");
        binaryExtensions.put(".zip", ".zip");
        binaryExtensions.put(".tgz", ".tgz");
        binaryExtensions.put(".jpg", ".jpg");
        binaryExtensions.put(".jar", ".jar");
        binaryExtensions.put(".rpm", ".rpm");
    }
}

