/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.search;

import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.web.search.Spider;
import com.caucho.web.search.Store;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.sql.DataSource;

public class SpiderServlet
extends GenericServlet {
    Store store;
    int count;

    public void init() throws ServletException {
        String string = this.getInitParameter("data-source");
        if (string == null) {
            string = "jdbc/search";
        }
        try {
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup("java:comp/env/" + string);
            if (dataSource == null) {
                throw new ServletException("no data source: " + string);
            }
            this.store = new Store(dataSource);
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (this.count++ % 4 != 0) {
            return;
        }
        servletResponse.setContentType("text/html");
        this.log("Starting Spider at " + QDate.formatLocal((long)System.currentTimeMillis()));
        PrintWriter printWriter = servletResponse.getWriter();
        String string = servletRequest.getServerName();
        int n = servletRequest.getServerPort();
        Path path = Vfs.lookup((String)("http://" + string + ":" + n));
        try {
            Spider spider = Spider.create(path, this.store);
            while (spider.hasNext()) {
                try {
                    Path path2 = spider.analyze();
                    if (path2 == null || printWriter == null) continue;
                    printWriter.println("<br>analyzing: " + path2);
                    printWriter.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (printWriter != null) {
            printWriter.println("done");
        }
        this.log("Finishing Spider at " + QDate.formatLocal((long)System.currentTimeMillis()));
    }
}

