/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.search;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Store {
    private DataSource dataSource;
    private IntMap wordMap = new IntMap();
    int oldVersion = -1;
    int version = -1;

    public Store(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        this.dataSource = dataSource;
    }

    public void clearAll() throws SQLException {
        this.wordMap = new IntMap();
        this.oldVersion = this.nextVersion();
        if (this.oldVersion <= 0) {
            this.createTables();
        }
        this.version = this.oldVersion <= 0 ? 1 : this.oldVersion + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextVersion() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        Statement statement = null;
        int n = -1;
        try {
            statement = connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT max(version) FROM pages");
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            statement.close();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.executeUpdate("drop table pages");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                statement.executeUpdate("create table pages (id integer default '0' primary key auto_increment,url varchar(255) not null,title varchar(255),description varchar(255),score integer,version integer,unique(url))");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                statement.executeUpdate("drop table words");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                statement.executeUpdate("create table words (id integer default '0' primary key auto_increment,word varchar(40) not null,unique(word))");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                statement.executeUpdate("drop table score");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                statement.executeUpdate("create table score (word integer not null,page integer not null,score integer,version integer,key(word, page))");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (statement != null) {
                statement.close();
            }
            Object var5_10 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPage(String string, String string2, String string3) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement("insert into pages (url,title,description,version) VALUES (?, ?, ?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setInt(4, this.version);
                preparedStatement.executeUpdate();
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                Object var8_6 = null;
                connection.close();
                return;
            }
            catch (Exception exception) {
                Object var8_7 = null;
                connection.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            connection.close();
            throw throwable;
        }
        try {
            block9: {
                try {
                    preparedStatement = connection.prepareStatement("update pages set version=?, title=?, descrption=? where url=?");
                    preparedStatement.setInt(1, this.version);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setString(3, string3);
                    preparedStatement.setString(4, string);
                    preparedStatement.executeUpdate();
                    if (preparedStatement == null) break block9;
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    Object var10_13 = null;
                    connection.close();
                    return;
                }
            }
            Object var10_12 = null;
            connection.close();
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            connection.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPage(String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block6: {
            block5: {
                int n;
                connection = this.dataSource.getConnection();
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("select id from pages where url=?");
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet != null) break block5;
                    n = -1;
                    Object var9_6 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    connection.close();
                    throw throwable;
                }
                connection.close();
                return n;
            }
            if (resultSet.next()) break block6;
            resultSet.close();
            int n = -1;
            Object var9_7 = null;
            connection.close();
            return n;
        }
        int n = resultSet.getInt(1);
        resultSet.close();
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        int n2 = n;
        Object var9_8 = null;
        connection.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWords(int n) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("delete from score where page=?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeQuery();
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScore(int n, String string, int n2) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            int n3 = this.getWordId(string);
            int n4 = 0;
            int n5 = 0;
            preparedStatement = connection.prepareStatement("select score, version from score where page=? and word=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n4 = resultSet.getInt(1);
                n5 = resultSet.getInt(1);
            }
            resultSet.close();
            if (n5 > 0) {
                if (n5 == this.version) {
                    n2 += n4;
                }
                preparedStatement = connection.prepareStatement("update score set score=?, version=? where page=? and word=?");
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, this.version);
                preparedStatement.setInt(3, n);
                preparedStatement.setInt(4, n3);
                preparedStatement.executeUpdate();
            } else {
                preparedStatement = connection.prepareStatement("insert into score (score, version, page, word) VALUES(?,?,?,?)");
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, this.version);
                preparedStatement.setInt(3, n);
                preparedStatement.setInt(4, n3);
                preparedStatement.executeUpdate();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWordId(String string) throws SQLException {
        int n = this.wordMap.get((Object)string);
        if (n > 0) {
            return n;
        }
        Connection connection = this.dataSource.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("select id from words where word=?");
            preparedStatement.setString(1, string);
            n = -1;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (n < 0) {
                preparedStatement = connection.prepareStatement("insert into words (word) values (?)");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                preparedStatement = connection.prepareStatement("select id from words where word=?");
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
                preparedStatement.close();
                if (n > 0) {
                    this.wordMap.put((Object)string, n);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
        return n;
    }

    public ResultSet search(Statement statement, String string, int n, int n2) throws SQLException {
        CharBuffer charBuffer;
        if (n2 < 10) {
            n2 = 10;
        }
        IntArray intArray = new IntArray();
        int n3 = 0;
        while (true) {
            if (n3 < string.length() && Character.isSpace(string.charAt(n3))) {
                ++n3;
                continue;
            }
            if (n3 >= string.length()) break;
            charBuffer = CharBuffer.allocate();
            while (n3 < string.length() && !Character.isSpace(string.charAt(n3))) {
                char c = string.charAt(n3);
                if (c == '\'') {
                    charBuffer.append("''");
                } else {
                    charBuffer.append(string.charAt(n3));
                }
                ++n3;
            }
            String string2 = charBuffer.close();
            int n4 = this.wordMap.get((Object)string2);
            if (n4 > 0) {
                intArray.add(n4);
                continue;
            }
            if (n4 == 0) continue;
            String string3 = "select id from words where word='" + string2 + "'";
            try {
                ResultSet resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    intArray.add(resultSet.getInt(1));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        if (intArray.size() == 0) {
            return null;
        }
        charBuffer = CharBuffer.allocate();
        charBuffer.append("select url,title,description from ");
        n3 = 0;
        while (n3 < intArray.size()) {
            charBuffer.append("score as score" + n3 + ", ");
            ++n3;
        }
        charBuffer.append("pages");
        charBuffer.append(" where");
        n3 = 0;
        while (n3 < intArray.size()) {
            if (n3 != 0) {
                charBuffer.append(" and");
            }
            int n5 = intArray.get(n3);
            charBuffer.append(" score");
            charBuffer.append(n3);
            charBuffer.append(".word=");
            charBuffer.append(intArray.get(n3));
            charBuffer.append(" and pages.id = score" + n3 + ".page");
            ++n3;
        }
        charBuffer.append(" order by score0.score desc");
        charBuffer.append(" limit ");
        charBuffer.append(n);
        charBuffer.append(", ");
        charBuffer.append(n2);
        try {
            return statement.executeQuery(charBuffer.close());
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
    }
}

