/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.caucho.jmx.AbstractMBeanServerFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.management.MBeanServer;

public class MBeanServerFactory {
    private static String FACTORY_PROPERTY = "javax.management.MBeanServerFactory";
    private static String DEFAULT_FACTORY = "com.caucho.jmx.MBeanServerFactoryImpl";

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String domain) {
        return MBeanServerFactory.getMBeanServerFactory().createMBeanServer(domain);
    }

    public static ArrayList findMBeanServer(String agentId) {
        return MBeanServerFactory.getMBeanServerFactory().findMBeanServer(agentId);
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String domain) {
        return MBeanServerFactory.getMBeanServerFactory().newMBeanServer(domain);
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.getMBeanServerFactory().releaseMBeanServer(mbeanServer);
    }

    static AbstractMBeanServerFactory getMBeanServerFactory() {
        String className = MBeanServerFactory.getFactoryClassName();
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                cl = Class.forName(className, false, loader);
            }
        }
        catch (NoSuchMethodError e) {
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(String.valueOf(e));
        }
        if (cl == null) {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(String.valueOf(e));
            }
        }
        try {
            return (AbstractMBeanServerFactory)cl.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.valueOf(e));
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(String.valueOf(e));
        }
    }

    private static String getFactoryClassName() {
        String className = null;
        try {
            className = System.getProperty(FACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String serviceName = "META-INF/services/" + FACTORY_PROPERTY;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader != null ? loader.getResourceAsStream(serviceName) : ClassLoader.getSystemResourceAsStream(serviceName);
            InputStreamReader rawReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(rawReader);
            className = reader.readLine();
            reader.close();
            is.close();
            if (className != null) {
                className = className.trim();
            }
            if (className != null && !"".equals(className)) {
                return className;
            }
        }
        catch (Throwable e) {}
        return DEFAULT_FACTORY;
    }
}

