/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.VersionHelper;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap factoryCache = new WeakHashMap(11);
    private static final WeakHashMap urlFactoryCache = new WeakHashMap(11);

    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader classLoader;
        try {
            classLoader = helper.getContextClassLoader();
        }
        catch (SecurityException securityException) {
            return new Hashtable(1);
        }
        Object object = classLoader == null ? "bootstrap" : classLoader;
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Object object2;
            Properties properties = (Properties)propertiesCache.get(object);
            if (properties != null) {
                Properties properties2;
                Properties properties3 = properties2 = properties;
                Object var3_10 = null;
                return properties3;
            }
            try {
                Properties properties4;
                object2 = helper.getResources(classLoader, "jndi.properties");
                while (object2.hasMore()) {
                    properties4 = new Properties();
                    properties4.load((InputStream)object2.next());
                    if (properties == null) {
                        properties = properties4;
                        continue;
                    }
                    ResourceManager.mergeTables(properties, properties4);
                }
                object2 = helper.getJavaHomeLibStream("jndi.properties");
                if (object2 != null) {
                    properties4 = new Properties();
                    properties4.load((InputStream)object2);
                    if (properties == null) {
                        properties = properties4;
                    } else {
                        ResourceManager.mergeTables(properties, properties4);
                    }
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            if (properties == null) {
                properties = new Hashtable(11);
            }
            propertiesCache.put(object, properties);
            object2 = properties;
            Hashtable hashtable = (Hashtable)object2;
            Object var3_11 = null;
            return hashtable;
        }
    }

    public static FactoryEnumeration getFactories(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        FactoryKey factoryKey = new FactoryKey(string2);
        WeakHashMap weakHashMap = factoryCache;
        synchronized (weakHashMap) {
            FactoryEnumeration factoryEnumeration;
            Vector<Class> vector = (Vector<Class>)factoryCache.get(factoryKey);
            if (vector != null) {
                FactoryEnumeration factoryEnumeration2;
                FactoryEnumeration factoryEnumeration3 = factoryEnumeration2 = vector.size() != 0 ? new FactoryEnumeration(vector) : null;
                Object var6_11 = null;
                return factoryEnumeration3;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            vector = new Vector<Class>(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    vector.addElement(helper.loadClass(stringTokenizer.nextToken(), factoryKey.loader));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            factoryCache.put(factoryKey, vector);
            FactoryEnumeration factoryEnumeration4 = factoryEnumeration = new FactoryEnumeration(vector);
            Object var6_12 = null;
            return factoryEnumeration4;
        }
    }

    public static Object getFactory(String string, Hashtable hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? string4 + ":" + string3 : string3;
        FactoryKey factoryKey = new FactoryKey(string2 + string4);
        WeakHashMap weakHashMap = urlFactoryCache;
        synchronized (weakHashMap) {
            Object object = urlFactoryCache.get(factoryKey);
            if (object != null) {
                Object var11_9;
                Object var9_11 = var11_9 = object.equals("none") ? null : object;
                Object var8_13 = null;
                return var9_11;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (object == null && stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken() + string2;
                try {
                    object = helper.loadClass(string5, factoryKey.loader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string5);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string5);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object != null) {
                urlFactoryCache.put(factoryKey, object);
            } else {
                urlFactoryCache.put(factoryKey, "none");
            }
            StringTokenizer stringTokenizer2 = stringTokenizer = object;
            Object var8_14 = null;
            return stringTokenizer2;
        }
    }

    public static Hashtable getInitialEnvironment(Hashtable hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Applet applet = (Applet)hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        int n = 0;
        while (n < stringArray.length) {
            Object object = hashtable.get(stringArray[n]);
            if (object == null) {
                if (applet != null) {
                    object = applet.getParameter(stringArray[n]);
                }
                if (object == null) {
                    String string = object = stringArray2 == null ? helper.getJndiProperty(n) : stringArray2[n];
                }
                if (object != null) {
                    hashtable.put(stringArray[n], object);
                }
            }
            ++n;
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable hashtable, Context context, boolean bl) throws NamingException {
        String string2;
        String string3 = string2 = hashtable == null ? null : (String)hashtable.get(string);
        if (context == null || string2 != null && !bl) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl) {
            return string2;
        }
        return string2 + ":" + string4;
    }

    private static Hashtable getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Properties properties;
            Class<?> clazz = object.getClass();
            Hashtable hashtable = (Hashtable)propertiesCache.get(clazz);
            if (hashtable != null) {
                Hashtable hashtable2;
                Hashtable hashtable3 = hashtable2 = hashtable;
                Object var2_8 = null;
                return hashtable3;
            }
            hashtable = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    ((Properties)hashtable).load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, hashtable);
            Properties properties2 = properties = (Properties)hashtable;
            Object var2_9 = null;
            return properties2;
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        int n = 0;
        while (n < listProperties.length) {
            if (string == listProperties[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void mergeTables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!ResourceManager.isListProperty(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)v + ":" + string2);
        }
    }

    private ResourceManager() {
    }

    private static final class FactoryKey {
        private String propVal;
        private ClassLoader loader;

        public boolean equals(Object object) {
            if (!(object instanceof FactoryKey)) {
                return false;
            }
            FactoryKey factoryKey = (FactoryKey)object;
            return this.propVal.equals(factoryKey.propVal) && (this.loader == factoryKey.loader || this.loader != null && this.loader.equals(factoryKey.loader));
        }

        public int hashCode() {
            return this.propVal.hashCode() + (this.loader == null ? 0 : this.loader.hashCode());
        }

        FactoryKey(String string) {
            try {
                this.loader = helper.getContextClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.propVal = string;
        }
    }
}

