/*
 * Copyright (c) 1999 Caucho Technology.  All rights reserved.
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Developer Source License ("the License").  In particular, the following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.

 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL CAUCHO OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 *
 * @author Scott Ferguson
 *
 * $Id: alloc.c,v 1.2 2000/10/13 01:50:38 ferg Exp $
 */

#include <stdlib.h>
#include <errno.h>
#include "rws.h"

struct pool_t {
  char *chunk;
  int ptr;
  int size;
  pool_t *next;
};

static pool_t *g_free_pools;

/* XXX: will need sync */
pool_t *
rws_create_pool()
{
  pool_t *pool;
  
  if (g_free_pools) {
    pool = g_free_pools;
    g_free_pools = g_free_pools->next;
  }
  else {
    pool = malloc(sizeof(pool_t));
    pool->size = 0x4000;
    pool->chunk = malloc(pool->size);
  }

  pool->ptr = 0;
  return pool;
}

/* XXX: will need sync */
void
rws_free_pool(pool_t *pool)
{
  pool->next = g_free_pools;
  g_free_pools = pool;
}

void *
rws_pin_alloc(pool_t *pool, int size)
{
  int allow_size = pool->size - pool->ptr;
  void *ptr;
  
  if (size > allow_size) {
    if (size < 0x4000)
      pool->size = 0x4000;
    else
      pool->size = size;
    pool->chunk = malloc(pool->size);
    pool->ptr = 0;
  }

  ptr = pool->chunk + pool->ptr;

  return ptr;
}

void
rws_free_pin(pool_t *pool, int size)
{
  pool->ptr = (pool->ptr + size + 7) & 0xfffffff8;
}

void *
rws_malloc(pool_t *pool, int size)
{
  void *ptr;

  ptr = rws_pin_alloc(pool, size);
  pool->ptr = (pool->ptr + size + 7) & 0xfffffff8;
  
  return ptr;
}

char *
rws_strdup(pool_t *pool, const char *string)
{
  int length = strlen(string);
  char *ptr = rws_malloc(pool, length + 1);

  memcpy(ptr, string, length + 1);

  return ptr;
}
