/*
 * Copyright (c) 1998-2001 Caucho Technology -- all rights reserved
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Developer Source License ("the License").  The following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 *
 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL CAUCHO OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 *
 * @author Scott Ferguson
 */

#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/in.h>

#include "hardcore.h"

static char g_log_buf[8192];
static char g_lf_buf[8192];

char *g_browser_state_names[] = {
  "RHC_IDLE",
  
  "RHC_BROWSER_START",
  "RHC_BROWSER_SPACE",
  "RHC_BROWSER_METHOD",
  "RHC_BROWSER_URL",
  "RHC_BROWSER_PROTOCOL",
  
  "RHC_BROWSER_EOL",
  
  "RHC_BROWSER_KEY",
  "RHC_BROWSER_VALUE",
  "RHC_BROWSER_HEADER_DONE",
  
  "RHC_BROWSER_BODY",

  "RHC_SRUN_CONNECTING",
  "RHC_SRUN_SEND",
  "RHC_SRUN_START",

  "RHC_SRUN_RECV_HEADER",
  "RHC_SRUN_RECV_STATUS",
  "RHC_SRUN_RECV_KEY",
  "RHC_SRUN_RECV_VALUE",
  
  "RHC_SRUN_RECV_SKIP",
  
  "RHC_SRUN_POST",
  
  "RHC_SRUN_BODY",
  "RHC_SRUN_RECV_BODY",
  "RHC_SRUN_RECV_DATA",

  "RHC_CACHE_WRITE",
  
  "RHC_BROWSER_READ",
  "RHC_BROWSER_WRITE",
  
  "RHC_BROWSER_QUIT",
};

static int
lf_rewrite(char *newbuf, char *str)
{
  int length = 0;

  for (; *str; str++) {
    int ch = *str;

    if (ch == '\n') {
      newbuf[length++] = '\r';
      newbuf[length++] = '\n';
    }
    else
      newbuf[length++] = ch;
  }
  newbuf[length] = 0;

  return length;
}

/**
 * Log to the current tty.
 *
 * @param fmt formatting string for the printing
 * @param ... args to the format
 */
void
log(char *fmt, ...)
{
  int len;
  va_list args;
  struct tty_struct *tty = g_resin.tty;

  if (! tty)
    return;
    
  va_start(args, fmt);
  vsprintf(g_log_buf, fmt, args);
  va_end(args);

  len = lf_rewrite(g_lf_buf, g_log_buf);

  tty->driver.write(tty, 0, g_lf_buf, len);
}

/**
 * Returns the readable representation of the browser state name.
 *
 * @param browser the current connection to the browser client.
 * @return a printable name
 */
char *
browser_state_name(browser_t *browser)
{
  int state;

  if (! browser)
    return "null";
  
  state = browser->state;
  
  if (state < 0 || state >= sizeof(g_browser_state_names) / 4)
    return "unknown";
  else
    return g_browser_state_names[state];
}
