/*
 * Copyright (c) 1999-2003 Caucho Technology.  All rights reserved.
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Public License ("the License").  In particular, the following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 *
 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL Caucho OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.
 *
 * @author Scott Ferguson
 */

/*
 * SSL client certificate contributed by Ahn Le
 */

/*
 * Anh: We have to define _WIN32_WINNT as 0x0400 to have access to
 * the Crypto API.  By definning as this way, the dll can only work
 * with Windows 95 OEM Service Release 2 or above.
 */ 
#define _WIN32_WINNT 0x0400

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <windows.h>
#include "httpext.h"
#include <errno.h>
#include <ctype.h>
#include <string.h>

#define ISAPI_SCRIPT "/scripts/isapi_srun.dll"

extern "C" {
#include "../common/cse.h"
#include "../common/version.h"
}

extern "C" {

void
cse_error(config_t *config, char *fmt, ...)
{
	va_list arg;
	char buf[1024];

	va_start(arg, fmt);
	if (fmt)
		vsprintf(buf, fmt, arg);
	else
		buf[0] = 0;

	va_end(arg);

	if (buf[0]) {
		config->error = strdup(buf);
                config->disable_caucho_status = 0;
        }
#ifdef DEBUG
	{
		FILE *file;
	    file = fopen("/temp/isapi.log", "a+b");
		fprintf(file, "%s\n", buf);
		fclose(file);
	}
#endif
}

void *
cse_malloc(int size)
{
  return malloc(size);
}

void cse_free(config_t *config, void *value) {}

void
cse_set_socket_cleanup(int socket, void *pool)
{
}

void
cse_kill_socket_cleanup(int socket, void *pool)
{
}

}

void
cse_log(char *fmt, ...)
{
#ifdef DEBUG
	va_list arg;
	FILE *file;
	file = fopen("/temp/isapi.log", "a+");
	va_start(arg, fmt);
	if (file)
		vfprintf(file, fmt, arg);
	va_end(arg);
	fclose(file);
#endif
}

void *
cse_create_lock(config_t *config)
{
	return CreateMutex(0, false, 0);
}

int
cse_lock(void *lock)
{
	if (lock) {
		WaitForSingleObject(lock, INFINITE);
	}

	return 1;
}

void
cse_unlock(void *lock)
{
	if (lock) {
		ReleaseMutex(lock);
	}
}

static void
cse_printf(EXTENSION_CONTROL_BLOCK *r, char *fmt, ...)
{
  va_list args;
  char buf[4096];
  unsigned long len;

  va_start(args, fmt);
  vsprintf(buf, fmt, args);

  va_end(args);

  len = strlen(buf);

  r->WriteClient(r->ConnID, buf, &len, 0);
}

static void
cse_pad(EXTENSION_CONTROL_BLOCK *r)
{
  cse_printf(r, "\n\n\n\n");
  cse_printf(r, "<!--\n");
  cse_printf(r, "   - Unfortunately, Microsoft has added a clever new\n");
  cse_printf(r, "   - \"feature\" to Internet Explorer.  If the text in\n");
  cse_printf(r, "   - an error's message is \"too small\", specifically\n");
  cse_printf(r, "   - less than 512 bytes, Internet Explorer returns\n");
  cse_printf(r, "   - its own error message.  Yes, you can turn that\n");
  cse_printf(r, "   - off, but *surprise* it's pretty tricky to find\n");
  cse_printf(r, "   - buried as a switch called \"smart error\n");
  cse_printf(r, "   - messages\"  That means, of course, that many of\n");
  cse_printf(r, "   - Resin's error messages are censored by default.\n");
  cse_printf(r, "   - And, of course, you'll be shocked to learn that\n");
  cse_printf(r, "   - IIS always returns error messages that are long\n");
  cse_printf(r, "   - enough to make Internet Explorer happy.  The\n");
  cse_printf(r, "   - workaround is pretty simple: pad the error\n");
  cse_printf(r, "   - message with a big comment to push it over the\n");
  cse_printf(r, "   - five hundred and twelve byte minimum.  Of course,\n");
  cse_printf(r, "   - that's exactly what you're reading right now.\n");
  cse_printf(r, "   -->\n");
}


static int
connection_error(config_t *config, EXTENSION_CONTROL_BLOCK *r)
{
  // r->content_type = "text/html";
  // ap_send_http_header(r);
  char *hostname = 0;
  int port = 0;

  if (config->error_page) {
	  DWORD size = strlen(config->error_page);
	  DWORD type = 0;

          cse_printf(r, "HTTP/1.0 302 Redirect\r\n");
          cse_printf(r, "Location: %s\r\n", config->error_page);
          cse_printf(r, "\r\n");
          
	  return 1;
  }

  cse_printf(r, "HTTP/1.0 503 Server Error\n\n");
  cse_printf(r, "<html><body bgcolor='white'>\n");
  cse_printf(r, "<h1>Can't contact Servlet Runner at %s:%d\n",
	     (hostname ? hostname : "localhost"),
	     (port ? port : 6802));
  cse_printf(r, "</h1>\n");
  cse_printf(r, "</body></html>\n");
  
  cse_pad(r);

   return 1;
}

static int
cse_error(config_t *config, EXTENSION_CONTROL_BLOCK *r)
{
  // r->content_type = "text/html";
  // ap_send_http_header(r);

  if (config->error_page) {
	  DWORD size = strlen(config->error_page);
	  DWORD type = 0;

		cse_printf(r, "HTTP/1.0 302 Redirect\n");
		cse_printf(r, "Location: %s\n", config->error_page);
		cse_printf(r, "\n");

		return 1;
  }

  cse_printf(r, "HTTP/1.0 500 Server Error\n\n");
  cse_printf(r, "<html><body bgcolor='white'>\n");
  cse_printf(r, "<h1>Can't access URL</h1>\n");
  if (config->error)
	  cse_printf(r, "<pre>%s</pre>", config->error);
  cse_printf(r, "</body></html>\n");
  
  cse_pad(r);

   return 1;
}

static void
write_var(stream_t *s, EXTENSION_CONTROL_BLOCK *r, char *name, int code)
{
	char buf[8192];
        char *ptr;
	unsigned long size = sizeof(buf);

	buf[0] = 0;
	if (r->GetServerVariable(r->ConnID, name, buf, &size) && size > 0 && buf[0]) {
		buf[size] = 0;
                
                for (ptr = buf; isspace(*ptr); ptr++) {
                }
                
		cse_write_string(s, code, ptr);
	}
}

static void
write_header(stream_t *s, EXTENSION_CONTROL_BLOCK *r, char *name)
{
  char buf[8192];
  unsigned long size = sizeof(buf);
  char *ptr = buf;

  buf[0] = 0;
	if (r->GetServerVariable(r->ConnID, name, buf, &size) && size > 0 && buf[0]) {
                for (; size > 0 && buf[size - 1] <= ' '; size--) {
                }
		buf[size] = 0;
		cse_write_string(s, CSE_HEADER, name);
                for (ptr = buf; isspace(*ptr); ptr++) {
                }
                
		cse_write_string(s, CSE_VALUE, ptr);
 	}
}

/**
 * Writes SSL data, including client certificates.
 */
static void
write_ssl(stream_t *s, EXTENSION_CONTROL_BLOCK *r)
{
  char buf[8192];
  unsigned long size = sizeof(buf);

	if (! r->GetServerVariable(r->ConnID, "SERVER_PORT_SECURE", buf, &size) ||
            size <= 0 || buf[0] != '1')
          return;

	cse_write_string(s, CSE_IS_SECURE, "");

	// Anh : Add SSL connection informations
	cse_write_string(s, CSE_HEADER, "HTTPS");
	cse_write_string(s, CSE_VALUE, "on");
	write_header(s, r, "HTTPS_KEYSIZE");
	write_header(s, r, "HTTPS_SECRETKEYSIZE");
			
	// Anh : Check client certificate existence
	size = sizeof(buf);
	buf[0] = 0;

	if (! r->GetServerVariable(r->ConnID, "CERT_FLAGS", buf, &size) || 
		size <= 0 || buf[0] != '1')
		return;

	// There is a client certificate
    char cert_buf[8192]={0};
    CERT_CONTEXT_EX cert;
    cert.cbAllocated = sizeof(cert_buf);
    cert.CertContext.pbCertEncoded = (BYTE*) cert_buf;
    cert.CertContext.cbCertEncoded = 0;
    DWORD dwSize = sizeof(cert);

    if (r->ServerSupportFunction(r->ConnID,
                                 (DWORD)HSE_REQ_GET_CERT_INFO_EX,                               
                                 (LPVOID)&cert, &dwSize,NULL) != FALSE)
    {
      // cert now contains valid client certificate information	
      LOG(("\ndwCertEncodingType = %d (%d) %ld\n",
                    cert.CertContext.dwCertEncodingType & X509_ASN_ENCODING ,
                    cert.CertContext.cbCertEncoded,
                    cert.dwCertificateFlags));
               
      cse_write_packet(s, CSE_CLIENT_CERT, 
                       (char *)cert.CertContext.pbCertEncoded,
                       cert.CertContext.cbCertEncoded);
               
      write_header(s, r, "CERT_ISSUER");
      write_header(s, r, "CERT_SERIALNUMBER");
      write_header(s, r, "CERT_SUBJECT");
      write_header(s, r, "CERT_SERVER_ISSUER");
      write_header(s, r, "CERT_SERVER_SUBJECT");
	}
}

static int 
write_env(stream_t *s, EXTENSION_CONTROL_BLOCK *r)
{
	int isHttp11 = 0;

	char protocol[8192];
	char rawUri[8192];
	char *uri = rawUri;
	char buf[1024];
	unsigned long size = sizeof(protocol);

	if (r->GetServerVariable(r->ConnID, "SERVER_PROTOCOL", protocol, &size) && size > 0) {
		protocol[size] = 0;
		isHttp11 = ! strcmp(protocol, "HTTP/1.1");
	}
	size = sizeof(rawUri);
	if (r->GetServerVariable(r->ConnID, "PATH_INFO", uri, &size) && size > 0) {
		uri[size] = 0;
		if (! strncmp(uri, ISAPI_SCRIPT, sizeof(ISAPI_SCRIPT) - 1))
			uri += sizeof(ISAPI_SCRIPT) - 1;
	}
	else
		uri[size] = 0;
	
	write_var(s, r, "SERVER_PROTOCOL", CSE_PROTOCOL);
	write_var(s, r, "REQUEST_METHOD", CSE_METHOD);
	cse_write_string(s, CSE_URI, uri);
	//	write_var(s, r, "PATH_TRANSLATED", CSE_PATH_TRANSLATED);
	write_var(s, r, "QUERY_STRING", CSE_QUERY_STRING);
	write_var(s, r, "SERVER_NAME", CSE_SERVER_NAME);
	write_var(s, r, "SERVER_PORT", CSE_SERVER_PORT);
	write_var(s, r, "REMOTE_HOST", CSE_REMOTE_HOST);
	write_var(s, r, "REMOTE_ADDR", CSE_REMOTE_ADDR);
	write_var(s, r, "REMOTE_USER", CSE_REMOTE_USER);
	write_var(s, r, "AUTH_TYPE", CSE_AUTH_TYPE);

	// write_var(s, r, "CONTENT_TYPE", CSE_CONTENT_TYPE);
	// write_var(s, r, "CONTENT_LENGTH", CSE_CONTENT_LENGTH);
  // cse_write_string(s, CSE_DOCROOT, ap_document_root(r));
	sprintf(buf, "%d", s->srun->session);
	cse_write_string(s, CSE_SESSION_GROUP, buf);
	cse_write_string(s, CSE_SERVER_TYPE, "ISAPI");

	size = sizeof(buf);

	write_ssl(s, r);

	return isHttp11;
}

static void
write_headers(stream_t *s, EXTENSION_CONTROL_BLOCK *r)
{
	char buf[16384];
	unsigned long i = 0;
	unsigned long len = sizeof(buf);

	if (! r->GetServerVariable(r->ConnID, "ALL_RAW", buf, &len))
		return;

	while (i < len) {
		for (; i < len && isspace(buf[i]); i++) {
		}

		int head = i;
		int tail;

		for (; i < len && buf[i] != ':'; i++) {
		}
		buf[i] = 0;

		for (i++; i < len && buf[i] == ' ' && buf[i] != '\n'; i++) {
		}

		tail = i;
		for (; i < len && (buf[i] != '\n' || isspace(buf[i+1])); i++) {
			if (isspace(buf[i]))
				buf[i] = ' ';
		}
		if (buf[i - 1] == ' ')
			buf[i - 1] = 0;
		buf[i++] = 0;
		if (buf[head]) {
			cse_write_string(s, CSE_HEADER, buf + head);
			cse_write_string(s, CSE_VALUE, buf + tail);
		}
	}
}

static int
cse_write_response(stream_t *s, unsigned long len, EXTENSION_CONTROL_BLOCK *r)
{
	while (len > 0) {
		unsigned long sublen;

		if (s->read_offset >= s->read_length) {
			if (cse_fill_buffer(s) < 0)
				return -1;
		}

		sublen = s->read_length - s->read_offset;
		if (len < sublen)
			sublen = len;

		s->read_buf[s->read_length] = 0;
		unsigned long writelen = sublen;
		while (writelen > 0) {
			unsigned long sentlen = writelen;

			if (! r->WriteClient(r->ConnID, s->read_buf + s->read_offset, &sentlen, HSE_IO_SYNC) || 
				sentlen <= 0) {
				cse_close(s, "response");
				return -1;
			}

			writelen -= sentlen;
			s->read_offset += sentlen;
		}
		len -= sublen;
	}

	return 1;
}

static int
cse_copy_results(stream_t *s, EXTENSION_CONTROL_BLOCK *r, config_t *config)
{
	char headers[32 * 1024];
	char status[8192];
	char *status_ptr = status;
    char *header_ptr = headers;
    char *header_end = header_ptr + sizeof(headers) - 256;
	int code;

	*header_ptr = 0;
	do {
		int i;
		int l1, l2, l3;
		int read_len;
		unsigned long size;

		code = cse_read_byte(s);
		l1 = cse_read_byte(s) & 0xff;
		l2 = cse_read_byte(s) & 0xff;
		l3 = cse_read_byte(s);
		read_len = (l1 << 16) + (l2 << 8) + (l3 & 0xff);

		if (l3 < 0 || s->socket < 0)
			return -1;

		LOG(("code %c(%d) %d\n", code, code, read_len));

		switch (code) {
		case CSE_DATA:
			if (cse_write_response(s, read_len, r) < 0)
				code = -1;
			break;

		case CSE_STATUS:
            cse_read_limit(s, status, sizeof(status), read_len);

			for (i = 0; status[i] && status[i] != ' '; i++) {
			}
			i++;

			status_ptr = status + i;
			break;

		case CSE_HEADER:
			header_ptr += cse_read_limit(s, header_ptr,
                                                     header_end - header_ptr,
                                                     read_len);
            *header_ptr++ = ':';
            *header_ptr++ = ' ';
            code = cse_read_byte(s);
            l1 = cse_read_byte(s) & 0xff;
            l2 = cse_read_byte(s) & 0xff;
            l3 = cse_read_byte(s);
            read_len = (l1 << 16) + (l2 << 8) + (l3 & 0xff);
            if (l3 < 0 || s->socket < 0)
				return -1;
                        
			header_ptr += cse_read_limit(s, header_ptr,
                                                     header_end - header_ptr,
                                                     read_len);
                        *header_ptr++ = '\r';
                        *header_ptr++ = '\n';
			break;

		case CSE_SEND_HEADER:
                        *header_ptr++ = '\r';
                        *header_ptr++ = '\n';
                        *header_ptr++ = 0;
			size = header_ptr - headers;
			r->dwHttpStatusCode = atoi(status_ptr);
			r->ServerSupportFunction(r->ConnID, HSE_REQ_SEND_RESPONSE_HEADER, status, &size, (unsigned long *) headers);
			break;

		default:
			if (code < 0 || read_len < 0 || read_len > 8192) {
				code = -1;
				break;
			}

			cse_skip(s, read_len);
			break;
		}
	} while (code > 0 && code != CSE_END && code != CSE_ACK && code != CSE_CLOSE);

	return code;
}

static void
cse_get_ip(EXTENSION_CONTROL_BLOCK *r, char *ip, unsigned long length)
{
	ip[0] = 0;
	if (r->GetServerVariable(r->ConnID, "REMOTE_ADDR", ip, &length) && length >= 0)
		ip[length] = 0;
	else
		ip[0] = 0;
}

static int
get_session_index(config_t *config, EXTENSION_CONTROL_BLOCK *r, int *backup)
{
	char buf[16384];
	unsigned long i = 0;
	unsigned long len = sizeof(buf);
	int session;

	if (r->GetServerVariable(r->ConnID, "HTTP_COOKIE", buf, &len)) {
	    session = cse_session_from_string(buf, config->session_cookie, backup);
		LOG(("session %d %s\n", session, buf));
      	if (session >= 0)
			return session;
	}

	len = sizeof(buf);

	buf[0] = 0;
	if (! r->GetServerVariable(r->ConnID, "PATH_INFO", buf, &len))
		return -1;
	
	buf[len] = 0;
	return cse_session_from_string(buf, config->session_url_prefix, backup);
}

static int
get_session_from_raw(config_t *config, EXTENSION_CONTROL_BLOCK *r, int *backup)
{
	char buf[16384];
	unsigned long i = 0;
	unsigned long len = sizeof(buf);
	int session;

	if (! r->GetServerVariable(r->ConnID, "ALL_RAW", buf, &len))
		return -1;

	while (i < len) {
		int head = i + 5;
		int tail;
		i = head;
		for (; i < len && buf[i] != ':'; i++) {
		}
		tail = i;

		for (i++; i < len && buf[i] != '\r' && buf[i] != '\n'; i++) {
		}

		if (head >= tail)
			continue;

		buf[tail] = 0;
		buf[i] = 0;

		if (stricmp(buf + head, "cookie"))
			continue;

	    session = cse_session_from_string(buf + tail + 1, config->session_cookie, backup);
		if (session >= 0)
			return session;
	}

	return -1;
}

static int
write_request(stream_t *s, EXTENSION_CONTROL_BLOCK *r, config_t *config)
{
	int code;
	int backup_index = 0;
	int session_index = get_session_index(config, r, &backup_index);
	srun_t *srun;

	DWORD now = GetTickCount() / 1000;

	if (! cse_open_connection(s, config, session_index, backup_index, now, 0))
		return connection_error(config, r);

	srun = s->srun->srun;
	cse_lock(srun->lock);
	srun->active_sockets++;
	cse_unlock(srun->lock);

	int isHttp11 = write_env(s, r);
	write_headers(s, r);

	// read post data
	char buf[BUF_LENGTH + 8];
	int isFirst = 1;
	unsigned long totalLen = 0;
		
	while (totalLen < r->cbTotalBytes) {
		unsigned long len = BUF_LENGTH;

		if (r->cbAvailable > 0) {
			if (len > r->cbAvailable)
				len = r->cbAvailable;
			memcpy(buf, r->lpbData + totalLen, len);
			r->cbAvailable -= len;
		}
		else if (! r->ReadClient(r->ConnID, buf, &len) || len <= 0)
			break;

		totalLen += len;
		cse_write_packet(s, CSE_DATA, buf, len);

		if (! isFirst) {
			code = cse_copy_results(s, r, config);

			if (code < 0 || code == CSE_END || code == CSE_CLOSE)
				break;
		}

		isFirst = 0;
	}	

	cse_write_packet(s, CSE_END, 0, 0);

	code = cse_copy_results(s, r, config);

	if (code == CSE_END)
		cse_recycle(s, now);
	else
		cse_close(s, "write");

	cse_lock(srun->lock);
	srun->active_sockets--;
	cse_unlock(srun->lock);

	return code == CSE_END || code == CSE_CLOSE;
}

static int g_count;

static void
jvm_status(config_t *config, EXTENSION_CONTROL_BLOCK *r)
{
  int i;
  stream_t s;

  cse_printf(r, "<p><center><table border=2 width=\"80%%\">\n");
  cse_printf(r, "<tr><th>Host</th>\n");
  cse_printf(r, "    <th>Active</th>\n");
  cse_printf(r, "    <th>Pooled</th>\n");
  cse_printf(r, "    <th>Connect<br>Timeout</th>\n");
  cse_printf(r, "    <th>Live<br>Time</th>\n");
  cse_printf(r, "    <th>Dead<br>Time</th>\n");
  cse_printf(r, "</tr>\n");

  for (i = 0; i < config->srun_size; i++) {
    srun_item_t *srun_item = config->srun_list + i;
	srun_t *srun = srun_item->srun;
    int port;
	int pool_count;
    char group_buf[1024];

    if (! srun)
      continue;

	port = srun->port;
	pool_count = ((srun->conn_head - srun->conn_tail + CONN_POOL_SIZE) %
				  CONN_POOL_SIZE);

    cse_printf(r, "<tr>");

    if (srun_item->id && *srun_item->id &&
        srun_item->group && *srun_item->group)
      sprintf(group_buf, " (%s, %s)", srun_item->id, srun_item->group);
    else if (srun_item->group && *srun_item->group)
      sprintf(group_buf, " (%s)", srun_item->group);
    else if (srun_item->id && *srun_item->id)
      sprintf(group_buf, " (%s)", srun_item->id);
    else
      group_buf[0] = 0;

    if (! cse_open(&s, config, srun_item, 0, 1)) {
      cse_printf(r, "<td bgcolor='#ff6666'>%d. %s:%d%s (down)</td>",
                 srun_item->session + 1,
		 srun->hostname ? srun->hostname : "localhost",
		 port, srun_item->is_backup ? "*" : "");
    }
    else {
      cse_printf(r, "<td bgcolor='#66ff66'>%d. %s:%d%s (ok)</td>",
                 srun_item->session + 1,
		 srun->hostname ? srun->hostname : "localhost",
		 port, srun_item->is_backup ? "*" : "");
    }

	cse_close(&s, "caucho-status");

	cse_printf(r, "<td align=right>%d</td><td align=right>%d</td>",
		       srun->active_sockets, pool_count);
    cse_printf(r, "<td align=right>%d</td><td align=right>%d</td><td align=right>%d</td>",
               srun->connect_timeout, srun->live_time, srun->dead_time);
    cse_printf(r, "</tr>\n");
  }

  cse_printf(r, "</table></center>\n");
}

static void
cse_caucho_status(config_t *config, EXTENSION_CONTROL_BLOCK *r)
{
	web_app_t *app;
  location_t *loc;
  char *headers = "200 OK\r\nContent-Type: text/html";
  unsigned long size = strlen(headers);

  if (config->disable_caucho_status)
	  return;

  r->ServerSupportFunction(r->ConnID, HSE_REQ_SEND_RESPONSE_HEADER, headers, &size, 0);
 
  cse_printf(r, "<html><title>Status : Caucho Servlet Engine</title>\n");
  cse_printf(r, "<body bgcolor=white>\n");
  cse_printf(r, "<h1>Status : Caucho Servlet Engine</h1>\n");
 
  if (config->path)
	  cse_printf(r, "<b>Config:</b> %s<br>", config->path);

  if (config->resin_home)
	  cse_printf(r, "<b>Resin-Home:</b> %s<br>", config->resin_home);

  if (config->error) {
	  cse_printf(r, "<b><font color=\"red\">%s</font></b><br>",
			     config->error);
  }

  jvm_status(config, r);

  cse_printf(r, "<p><center><table border=2 cellspacing=0 cellpadding=2 width=\"80%%\">\n");
  cse_printf(r, "<tr><th width='50%'>Host\n");
  cse_printf(r, "    <th>url-pattern\n");
  
  app = config ? config->applications : 0;
  for (; app; app = app->next) {
      char port[16];
      char *host = 0;
      if (app->host_alias_length > 0 && app->host_aliases[0]->port > 0)
        sprintf(port, ":%d", app->host_aliases[0]->port);
      else
        port[0] = 0;
      
      if (app->host_alias_length > 0)
        host = app->host_aliases[0]->host;

	  for (loc = app->locations; loc; loc = loc->next) {
	    cse_printf(r, "<tr bgcolor='#ffcc66'><td>%s%s%s<td>%s%s%s%s</tr>\n", 
                       host ? host : "", port,
               *app->prefix ? app->prefix : "/",
	       loc->prefix,
	       ! loc->is_exact && ! loc->suffix ? "/*" : 
	       loc->suffix && loc->prefix[0] ? "/" : "",
	       loc->suffix ? "*" : "",
	       loc->suffix ? loc->suffix : "");
	  }
  }

  cse_printf(r, "</table></center>\n");
  cse_printf(r, "<hr/><em>%s</em>\n", VERSION);
  cse_printf(r, "</body></html>\n");
}

int
cse_handle_request(config_t *config, EXTENSION_CONTROL_BLOCK *r)
{
	char host[1024];
	char port_buf[80];
	int port = 0;
	char url[8192];
	char *ptr = url;
	unsigned long size;

	size = sizeof(host);
	host[0] = 0;
	r->GetServerVariable(r->ConnID, "SERVER_NAME", host, &size);

	size = sizeof(port_buf);
	if (r->GetServerVariable(r->ConnID, "SERVER_PORT", port_buf, &size) && size > 0) {
		port = atoi(port_buf);
	}

	size = sizeof(url);

	url[0] = 0;
	if (r->GetServerVariable(r->ConnID, "PATH_INFO", url, &size) && size > 0 && url[0]) {
		url[size] = 0;

		if (! strcmp(url, "/caucho-status")) {
			cse_caucho_status(config, r);
			return 1;
		}
		else if (! cse_match_request(config, host, port, ptr, 0))
			return cse_error(config, r);
	}
	else
		return cse_error(config, r);

	stream_t s;

	return write_request(&s, r, config);
}
