/*
 * Copyright (c) 1999-2000 Caucho Technology.  All rights reserved.
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Public License ("the License").  In particular, the following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.

 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL Caucho OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 */

#ifndef PROXY_H
#define PROXY_H

#define HTTP_0_9 0x0009
#define HTTP_1_0 0x0100
#define HTTP_1_1 0x0101

typedef struct request_t {
  struct response_t *response;
  
  char *buffer;
  int capacity;
  int offset;
  int length;

  int sock;
  struct sockaddr_in server_addr;
  struct sockaddr_in remote_addr;

  int keepalive;
  
  char method[32];
  char uri[4096];
  char *host;
  char protocol[64];

  char headers[8192];
  int header_length;
  int header_keys[256];
  int header_values[256];
  int header_size;

  int version;

  int content_length;
  int content_offset;
  
  int chunked;
} request_t;

typedef struct response_t {
  struct request_t *request;

  int sock;
  
  char buffer[8192];
  int offset;
  int length;

  int after_headers;
  int chunked;

  struct cache_entry_t *entry;
} response_t;

typedef struct cache_entry_t {
  mem_pool_t *pool;
  
  char *host;
  char *uri;

  int is_cacheable;

  int header_size;
  int header_capacity;
  char *headers;

  char *cache_file;
  int fd;
  int length;
  // headers

  char *data;

  int is_dead;
  int use_count;
} cache_entry_t;

typedef struct cache_t cache_t;
typedef struct int_map_t int_map_t;

cache_t *cache_create(int capacity);
int cache_fill(cache_t *cache, request_t *req, response_t *res);

int_map_t *int_map_create();
void int_map_set(int_map_t *map, char *name, int value);
int int_map_get(int_map_t *map, char *name);

request_t *request_create();
void request_parse(request_t *req, int sock);

response_t *response_create();
void response_start(response_t *res, int sock);
void cse_rprintf(response_t *res, char *fmt, ...);
int cse_rwrite(response_t *res, char *buf, int length);
void cse_flush_headers(response_t *res, int length);
int cse_flush_request(response_t *res);

extern int_map_t *g_header_map;

#define CONTENT_LENGTH 1
#define HOST 2
#define CONNECTION 3

#endif /* PROXY_H */

