/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web;

import com.caucho.util.Tree;
import com.caucho.vfs.Path;
import com.caucho.web.NavItem;
import com.caucho.xml.LooseXml;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathFun;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Navigation {
    private Element root;
    private String base;
    private Tree tree;
    static Expr linkPattern;
    static Expr titlePattern;
    static Expr descPattern;
    static Expr _productPattern;

    public Navigation() {
    }

    public Navigation(Path path, String base) throws Exception {
        Document doc = new LooseXml().parseDocument(path);
        this.init(doc.getDocumentElement(), base);
    }

    public Navigation(Env env, Path path, String base) throws Exception {
        Document doc = new LooseXml().parseDocument(path);
        this.init(env, doc.getDocumentElement(), base);
    }

    public Navigation(Env env, Element root, String base) throws Exception {
        this.init(env, root, base);
    }

    public Navigation(Element root, String base) throws Exception {
        this.init(root, base);
    }

    public void init(Element root, String base) throws Exception {
        this.init(null, root, base);
    }

    public void init(Env env, Element root, String base) throws Exception {
        this.tree = new Tree(null);
        this.root = root;
        if (base == null || base == "") {
            base = "/";
        }
        this.base = base;
        if (root != null) {
            this.fillChildren(env, this.tree, root.getFirstChild(), base);
        }
    }

    public static Navigation createNested(Path pwd, String base) throws Exception {
        return Navigation.createNested(null, pwd, base);
    }

    public static Navigation createNested(Env env, Path pwd, String base) throws Exception {
        Navigation baseNav = null;
        Object subNav = null;
        if (base.startsWith("/")) {
            base = base.substring(1);
        }
        String dir = base;
        while (true) {
            Path path = pwd.lookup(dir).lookup("toc.xml");
            Navigation nav = null;
            if (path.exists()) {
                nav = new Navigation(env, path, dir);
            }
            if (baseNav == null) {
                baseNav = nav;
            } else if (nav != null) {
                baseNav.linkParent(nav);
            }
            if (dir.equals("")) break;
            int p = dir.endsWith("/") ? dir.lastIndexOf(47, dir.length() - 2) : dir.lastIndexOf(47);
            if (p <= 0) {
                dir = "";
                continue;
            }
            dir = dir.substring(0, p + 1);
        }
        return baseNav;
    }

    public static Navigation createNested(ArrayList paths, String base) throws Exception {
        return Navigation.createNested(null, paths, base);
    }

    public static Navigation createNested(Env env, ArrayList paths, String base) throws Exception {
        Navigation baseNav = null;
        Object subNav = null;
        if (base.startsWith("/")) {
            base = base.substring(1);
        }
        String dir = base;
        for (int i = 0; i < paths.size(); ++i) {
            Path path = ((Path)paths.get(i)).lookup("toc.xml");
            Navigation nav = null;
            if (path.exists()) {
                nav = new Navigation(env, path, dir);
            }
            if (baseNav == null) {
                baseNav = nav;
            } else if (nav != null) {
                baseNav.linkParent(nav);
            }
            if (dir.equals("")) break;
            int p = dir.endsWith("/") ? dir.lastIndexOf(47, dir.length() - 2) : dir.lastIndexOf(47);
            dir = p <= 0 ? "" : dir.substring(0, p + 1);
        }
        return baseNav;
    }

    public Navigation linkParent(Navigation parent) {
        if (this.tree == null) {
            this.tree = parent.tree;
            return this;
        }
        if (this.tree.getFirst() == null) {
            return this;
        }
        NavItem test = (NavItem)this.tree.getFirst().getData();
        NavItem link = parent.findURL(test.getLink());
        if (link == null) {
            return null;
        }
        Tree parentTree = link.getTree();
        this.linkTree(link.getTree(), this.tree.getFirst());
        this.tree = parent.tree;
        return this;
    }

    private void linkTree(Tree destTree, Tree subTree) {
        for (Tree child = subTree.getFirst(); child != null; child = child.getNext()) {
            NavItem item = (NavItem)child.getData();
            Tree childTree = destTree.append((Object)item);
            item.setTree(childTree);
            this.linkTree(childTree, child);
        }
    }

    public String getAttribute(String name) {
        if (this.root == null) {
            return "";
        }
        return this.root.getAttribute(name);
    }

    public NavItem findURL(String url) {
        if (this.tree == null) {
            return null;
        }
        url = this.normalizeURL(url);
        Iterator iter = this.tree.dfs();
        while (iter.hasNext()) {
            Tree tree = (Tree)iter.next();
            NavItem item = (NavItem)tree.getData();
            if (!item.getLink().equals(url)) continue;
            return item;
        }
        return null;
    }

    private void fillChildren(Env env, Tree tree, Node childNode, String base) throws Exception {
        XPathFun docShouldDisplay;
        XPathFun xPathFun = docShouldDisplay = env == null ? null : env.getFunction("doc-should-display");
        while (childNode != null) {
            if (childNode.getNodeName().equals("item") && (docShouldDisplay == null || Expr.toBoolean((Object)docShouldDisplay.eval(childNode, (ExprEnvironment)env, null, null)))) {
                Element elt = (Element)childNode;
                NavItem item = new NavItem();
                String href = linkPattern.evalString((Node)elt);
                item.setLink(this.resolveURL(href, childNode, base));
                item.setTitle(titlePattern.evalString((Node)elt));
                String desc = descPattern.evalString((Node)elt);
                item.setDescription(desc);
                item.setProduct(_productPattern.evalString((Node)elt));
                Tree childTree = tree.append((Object)item);
                item.setTree(childTree);
                this.fillChildren(env, childTree, childNode.getFirstChild(), base);
            }
            childNode = childNode.getNextSibling();
        }
    }

    private String resolveURL(String url, Node node, String base) {
        if (url.length() == 0) {
            return "/";
        }
        if (url.startsWith("http:") || url.charAt(0) == '/') {
            return this.normalizeURL(url);
        }
        while (node instanceof Element) {
            Element elt = (Element)node;
            String nodeBase = elt.getAttribute("xml:base");
            if (!nodeBase.equals("")) {
                if (!nodeBase.endsWith("/")) {
                    return this.resolveURL(nodeBase + "/" + url, elt.getParentNode(), base);
                }
                return this.resolveURL(nodeBase + url, elt.getParentNode(), base);
            }
            node = node.getParentNode();
        }
        if (!base.endsWith("/")) {
            return this.normalizeURL(base + "/" + url);
        }
        return this.normalizeURL(base + url);
    }

    private String normalizeURL(String url) {
        if (url.startsWith("/")) {
            return url;
        }
        if (!url.startsWith("http://")) {
            return "/" + url;
        }
        for (int i = "http://".length(); i < url.length(); ++i) {
            if (url.charAt(i) != '/') continue;
            return url.substring(i);
        }
        return "/";
    }

    static {
        try {
            linkPattern = XPath.parseExpr((String)"if(@link,@link,link)");
            titlePattern = XPath.parseExpr((String)"if(@title,@title,title)");
            descPattern = XPath.parseExpr((String)"if(@description,@description,description)");
            _productPattern = XPath.parseExpr((String)"if(@product,@product,product)");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

