/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.webmail;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.web.webmail.MboxMessage;
import com.caucho.web.webmail.MboxStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MboxArchive {
    private Path path;
    private ArrayList threads;
    private ArrayList messages;

    public MboxArchive(Path path) throws IOException {
        this.path = path;
    }

    public ArrayList getThreads() {
        return this.threads;
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public void analyzeMessages() throws IOException {
        ReadStream message;
        this.threads = new ArrayList();
        this.messages = new ArrayList();
        int count = 0;
        HashMap<String, MboxMessage> map = new HashMap<String, MboxMessage>();
        HashMap subjectMap = new HashMap();
        ReadStream rawIs = this.path.openRead();
        MboxStream mboxStream = new MboxStream(rawIs);
        while ((message = mboxStream.openRead()) != null) {
            MboxMessage msg = new MboxMessage(count++);
            String id = (String)message.getAttribute("Message-Id");
            id = this.normalizeMessageId(id);
            msg.setMessageId(id);
            msg.setFrom((String)message.getAttribute("From"));
            String subject = (String)message.getAttribute("Subject");
            msg.setSubject(subject);
            this.messages.add(msg);
            String inReplyTo = (String)message.getAttribute("In-Reply-To");
            inReplyTo = this.normalizeMessageId(inReplyTo);
            MboxMessage parent = null;
            if (inReplyTo != null) {
                parent = (MboxMessage)map.get(inReplyTo);
            }
            if (parent == null) {
                parent = this.getParentBySubject(subjectMap, subject);
            }
            if (parent != null) {
                msg.setParent(parent);
            } else {
                this.threads.add(msg);
            }
            map.put(id, msg);
            this.setParentBySubject(subjectMap, subject, msg);
        }
        rawIs.close();
    }

    private void generateThread(WriteStream os, MboxMessage threadHeader) {
    }

    private String normalizeMessageId(String id) {
        if (id == null) {
            return id;
        }
        int start = id.indexOf(id, 60);
        if (start < 0) {
            return id;
        }
        int end = id.indexOf(id, 62);
        if (end < start) {
            return id;
        }
        return id.substring(start, end);
    }

    private MboxMessage getParentBySubject(Map subjectMap, String subject) {
        if (subject == null || subject.equals("")) {
            return null;
        }
        MboxMessage message = (MboxMessage)subjectMap.get(subject);
        if (message != null) {
            return message;
        }
        while (subject.length() > 4) {
            String prefix = subject.substring(0, 4).toLowerCase();
            if (!prefix.equals("re: ") && !prefix.equals("aw: ")) {
                return null;
            }
            message = (MboxMessage)subjectMap.get(subject = subject.substring(4));
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private void setParentBySubject(Map subjectMap, String subject, MboxMessage message) {
        if (subject == null || subject.equals("")) {
            return;
        }
        while (subject.length() > 4) {
            String prefix = subject.substring(0, 4).toLowerCase();
            if (!prefix.equals("re: ") && !prefix.equals("aw: ")) {
                subjectMap.put(subject, message);
                return;
            }
            subject = subject.substring(4);
        }
        if (subject == null || subject.equals("")) {
            return;
        }
        subjectMap.put(subject, message);
    }
}

