/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.web.webmail;

import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class MboxStream
extends StreamImpl {
    private byte[] boundaryBuffer = "From ".getBytes();
    private int boundaryLength = 5;
    private ByteBuffer peekBuffer = new ByteBuffer();
    private byte[] peek;
    private int peekOffset;
    private int peekLength;
    private byte[] dummyBuffer = new byte[32];
    private ReadStream is;
    private ReadStream readStream;
    private boolean isPartDone;
    private boolean isDone;
    private HashMap headers = new HashMap();
    private CharBuffer line = new CharBuffer();
    private String defaultEncoding;

    public MboxStream() throws IOException {
    }

    public MboxStream(ReadStream is) throws IOException {
        this();
        this.init(is);
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public void setEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public void init(ReadStream is) throws IOException {
        this.is = is;
        this.peekBuffer.setLength(this.boundaryLength + 5);
        this.peek = this.peekBuffer.getBuffer();
        this.peekOffset = 0;
        this.peekLength = 0;
        this.peek[this.peekLength++] = 10;
        this.isPartDone = false;
        this.isDone = false;
        while (this.read(this.dummyBuffer, 0, this.dummyBuffer.length) >= 0) {
        }
        this.isPartDone = true;
    }

    public ReadStream openRead() throws IOException {
        if (this.isDone) {
            return null;
        }
        if (this.readStream == null) {
            this.readStream = new ReadStream((StreamImpl)this, null);
        } else if (!this.isPartDone) {
            int len;
            while ((len = this.read(this.dummyBuffer, 0, this.dummyBuffer.length)) >= 0) {
            }
            if (this.isDone) {
                return null;
            }
        }
        this.readStream.init((StreamImpl)this, null);
        this.isPartDone = false;
        if (this.scanHeaders()) {
            String contentType = (String)this.getAttribute("content-type");
            String charset = MboxStream.getAttributePart(contentType, "charset");
            if (charset != null) {
                this.readStream.setEncoding(charset);
            } else if (this.defaultEncoding != null) {
                this.readStream.setEncoding(this.defaultEncoding);
            }
            return this.readStream;
        }
        this.isDone = true;
        this.readStream.close();
        return null;
    }

    public Object getAttribute(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public Iterator getAttributeNames() {
        return this.headers.keySet().iterator();
    }

    private boolean scanHeaders() throws IOException {
        int ch = this.read();
        this.headers.clear();
        while (ch > 0 && ch != 10 && ch != 13) {
            int i;
            this.line.clear();
            this.line.append((char)ch);
            ch = this.read();
            while (ch >= 0 && ch != 10 && ch != 13) {
                this.line.append((char)ch);
                ch = this.read();
            }
            if (ch == 13) {
                ch = this.read();
                if (ch == 10) {
                    ch = this.read();
                }
            } else if (ch == 10) {
                ch = this.read();
            }
            for (i = 0; i < this.line.length() && this.line.charAt(i) != ':'; ++i) {
            }
            String key = null;
            String value = null;
            if (i >= this.line.length()) continue;
            key = this.line.substring(0, i).trim().toLowerCase();
            value = this.line.substring(i + 1).trim();
            this.headers.put(key, value);
        }
        if (ch == 13 && (ch = this.read()) != 10) {
            this.peek[0] = (byte)ch;
            this.peekOffset = 0;
            this.peekLength = 1;
        }
        return true;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int b = -1;
        if (this.isPartDone) {
            return -1;
        }
        int i = 0;
        while (i < length && (b = this.read()) >= 0) {
            int j;
            boolean hasCr = false;
            if (b == 13) {
                hasCr = true;
                b = this.read();
                if (b != 10) {
                    buffer[offset + i++] = 13;
                    this.peek[0] = (byte)b;
                    this.peekOffset = 0;
                    this.peekLength = 1;
                    continue;
                }
            } else if (b != 10) {
                buffer[offset + i++] = (byte)b;
                continue;
            }
            for (j = 0; j < this.boundaryLength && (b = this.read()) >= 0 && this.boundaryBuffer[j] == b; ++j) {
            }
            if (j == this.boundaryLength) {
                this.isPartDone = true;
                while ((b = this.read()) >= 0 && b != 13 && b != 10) {
                }
                return 1;
            }
            this.peekLength = 0;
            if (hasCr && i + 1 < length) {
                buffer[offset + i++] = 13;
                buffer[offset + i++] = 10;
            } else if (hasCr) {
                buffer[offset + i++] = 13;
                this.peek[this.peekLength++] = 10;
            } else {
                buffer[offset + i++] = 10;
            }
            int k = 0;
            while (k < j && i + 1 < length) {
                buffer[offset + i++] = this.boundaryBuffer[k++];
            }
            while (k < j) {
                this.peek[this.peekLength++] = this.boundaryBuffer[k++];
            }
            this.peek[this.peekLength++] = (byte)b;
            this.peekOffset = 0;
        }
        if (i <= 0) {
            this.isPartDone = true;
            if (b < 0) {
                this.isDone = true;
            }
            return -1;
        }
        return i;
    }

    private int read() throws IOException {
        if (this.peekOffset < this.peekLength) {
            return this.peek[this.peekOffset++] & 0xFF;
        }
        return this.is.read();
    }

    private static String getAttributePart(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }
}

