/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber;

import com.caucho.amber.AmberConnection;
import com.caucho.amber.AmberException;
import com.caucho.amber.AmberFactory;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;

public class AmberContext {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/AmberContext"));
    private static final ThreadLocal<AmberContext> _localContext = new ThreadLocal();
    private AmberFactory _factory;
    private int _depth;
    private AmberConnection _aConn;

    private AmberContext(AmberFactory factory) {
        this._factory = factory;
    }

    public static AmberContext create(AmberFactory factory) {
        AmberContext context = _localContext.get();
        if (context != null) {
            ++context._depth;
        } else {
            context = new AmberContext(factory);
            _localContext.set(context);
        }
        return context;
    }

    public static AmberConnection getConnection() throws SQLException {
        AmberContext context = _localContext.get();
        if (context == null) {
            throw new AmberException(L.l("No amber context is available."));
        }
        if (context._aConn == null) {
            context._aConn = context._factory.getConnection();
        }
        return context._aConn;
    }

    public static void close() {
        AmberContext context = _localContext.get();
        if (context._depth == 0) {
            _localContext.set(null);
            AmberConnection conn = context._aConn;
            if (conn != null) {
                conn.close();
            }
        } else {
            --context._depth;
        }
    }
}

