/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.connection;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberManager;
import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityFactory;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.CachedQueryKey;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.UserQuery;
import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheConnectionImpl
extends AmberConnectionImpl {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/connection/CacheConnectionImpl"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/connection/CacheConnectionImpl"));
    private Connection _conn;
    private int _depth;
    private CachedQueryKey _queryKey = new CachedQueryKey();

    public CacheConnectionImpl(AmberManager amberManager) {
        super(amberManager);
    }

    public void register(AmberCollection query) {
    }

    public boolean isInTransaction() {
        return false;
    }

    public Object load(Class cl, Object key) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        try {
            entityHome.init();
        }
        catch (ConfigException e) {
            throw new AmberException(e);
        }
        Entity entity = entityHome.load(this, key);
        return entity;
    }

    public Entity getEntity(EntityItem item) {
        return item.copy(this);
    }

    public Object makePersistent(Object obj) throws SQLException {
        Entity entity = (Entity)obj;
        if (entity == null) {
            throw new NullPointerException();
        }
        Class<?> cl = entity.getClass();
        AmberEntityHome entityHome = this._amberManager.getEntityHome(entity.getClass().getName());
        if (entityHome == null) {
            throw new AmberException(L.l("entity has no matching home"));
        }
        entityHome.makePersistent(entity, this, false);
        return entity;
    }

    public Entity loadLazy(Class cl, String name, Object key) {
        if (key == null) {
            return null;
        }
        try {
            Entity obj;
            AmberEntityHome home = this._amberManager.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", cl.getName()));
            }
            home.init();
            Entity entity = obj = home.loadLazy(this, key);
            return entity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        catch (ConfigException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public Object loadProxy(String name, Object key) {
        if (key == null) {
            return null;
        }
        try {
            AmberEntityHome home = this._amberManager.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", name));
            }
            home.init();
            EntityItem item = home.findEntityItem(this, key, false);
            if (item == null) {
                return null;
            }
            EntityFactory factory = home.getEntityFactory();
            Object entity = factory.getEntity(this, item);
            return entity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        catch (ConfigException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public Object load(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.load(cl, key);
    }

    public Object loadLazy(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._amberManager.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.loadLazy(cl, cl.getName(), key);
    }

    public Entity getEntity(Class cl, Object key) {
        return null;
    }

    public void beginTransaction() throws SQLException {
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
    }

    public void flush() throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        if (this._conn == null) {
            this._conn = this._amberManager.getDataSource().getConnection();
        } else if (this._conn.isClosed()) {
            this.closeConnection();
            this._conn = this._amberManager.getDataSource().getConnection();
        }
        return this._conn;
    }

    public void makeTransactional(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void update(Object obj) {
    }

    public void create(Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void update(Entity entity) {
    }

    public void delete(Object obj) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CachedQueryKey getQueryKey() {
        if (this._queryKey == null) {
            this._queryKey = new CachedQueryKey();
        }
        return this._queryKey;
    }

    public AmberQuery prepareQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, false);
    }

    public AmberQuery prepareLazyQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    public AmberQuery prepareUpdate(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    private AmberQuery prepareQuery(String queryString, boolean isLazy) throws AmberException {
        try {
            this._amberManager.initEntityHomes();
        }
        catch (Exception e) {
            throw AmberRuntimeException.create(e);
        }
        QueryParser parser = new QueryParser(queryString);
        parser.setAmberManager(this._amberManager);
        parser.setLazyResult(isLazy);
        AbstractQuery queryProgram = parser.parse();
        UserQuery query = new UserQuery(queryProgram);
        query.setSession(this);
        return query;
    }

    public ResultSet query(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.executeQuery();
    }

    public int update(String hsql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public List find(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.list();
    }

    public List find(String query, Object value) throws SQLException {
        return null;
    }

    public List find(String query, Object[] values) throws SQLException {
        return null;
    }

    public Iterator iterate(String query) throws SQLException {
        return null;
    }

    public Iterator iterate(String query, Object value) throws SQLException {
        return null;
    }

    public Iterator iterate(String query, Object[] values) throws SQLException {
        return null;
    }

    public void cleanup() {
        this.freeConnection();
    }

    public void pushDepth() {
        ++this._depth;
    }

    public void popDepth() {
        --this._depth;
        if (this._depth == 0) {
            this.closeConnection();
        }
    }

    public void freeConnection() {
        if (this._depth != 0) {
            return;
        }
        this.closeConnection();
        this._amberManager.freeCacheConnection(this);
    }

    protected void closeConnection() {
        super.freeConnection();
        Connection conn = this._conn;
        this._conn = null;
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return "CacheConnectionImpl[]";
    }

    public void finalize() {
    }
}

