/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AssociationField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class EntityManyToManyField
extends AssociationField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityManyToManyField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityManyToManyField"));
    private EntityType _targetType;
    private Table _associationTable;
    private LinkColumns _sourceLink;
    private LinkColumns _targetLink;

    public EntityManyToManyField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public EntityManyToManyField(EntityType entityType) {
        super(entityType);
    }

    public void setType(Type targetType) {
        this._targetType = (EntityType)targetType;
        super.setType(targetType);
    }

    public EntityType getTargetType() {
        return this._targetType;
    }

    public Table getAssociationTable() {
        return this._associationTable;
    }

    public void setAssociationTable(Table table) {
        this._associationTable = table;
    }

    public void setSourceLink(LinkColumns link) {
        this._sourceLink = link;
    }

    public LinkColumns getSourceLink() {
        return this._sourceLink;
    }

    public void setTargetLink(LinkColumns link) {
        this._targetLink = link;
    }

    public LinkColumns getTargetLink() {
        return this._targetLink;
    }

    public void init() throws ConfigException {
        this._targetLink.setSourceCascadeDelete(true);
        this._sourceLink.setSourceCascadeDelete(true);
    }

    public void generateSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ManyToOneExpr(new OneToManyExpr(parser, parent, this._sourceLink), this._targetLink);
    }

    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    public String generateTargetSelect(String id) {
        return this.getTargetType().getId().generateSelect(id);
    }

    public String generateTargetLoadSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(this.getTargetType().getId().generateLoadSelect(id));
        String value = this.getTargetType().generateLoadSelect(id);
        if (cb.length() > 0 && value.length() > 0) {
            cb.append(", ");
        }
        cb.append(value);
        return cb.close();
    }

    public void generateGetProperty(JavaWriter out) throws IOException {
        String var = "_caucho_" + this.getGetterName();
        out.println("private com.caucho.amber.collection.CollectionImpl " + var + ";");
        out.println();
        out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        out.println("if (" + var + " != null) {");
        out.pushDepth();
        out.println(var + ".setSession(__caucho_session);");
        out.println("return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println("if (__caucho_session == null) {");
        if (!this.isAbstract()) {
            out.println("  return super." + this.getGetterName() + "();");
        }
        out.println("}");
        out.println("try {");
        out.pushDepth();
        out.print("String sql=\"");
        out.print("SELECT o." + this.getName());
        out.print(" FROM " + this.getSourceType().getName() + " o");
        out.print(" WHERE ");
        out.print(this.getSourceType().getId().generateRawWhere("o"));
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", "this");
        out.println(var + " = new com.caucho.amber.collection.CollectionImpl(query) {");
        out.pushDepth();
        this.generateAdd(out);
        this.generateRemove(out);
        this.generateClear(out);
        out.popDepth();
        out.println("};");
        out.println();
        out.println("return " + var + ";");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        this.generateAmberAdd(out);
        this.generateAmberRemove(out);
        this.generateAmberRemoveTargetAll(out);
    }

    private void generateAdd(JavaWriter out) throws IOException {
        out.println("public boolean add(Object o)");
        out.println("{");
        out.pushDepth();
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("if (! (o instanceof " + ownerType + "))");
        out.println("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a " + ownerType + "\");");
        out.println(ownerType + " bean = (" + ownerType + ") o;");
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateRemove(JavaWriter out) throws IOException {
        out.println("public boolean remove(Object o)");
        out.println("{");
        out.pushDepth();
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("if (! (o instanceof " + ownerType + "))");
        out.println("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a " + ownerType + "\");");
        out.println(ownerType + " bean = (" + ownerType + ") o;");
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateClear(JavaWriter out) throws IOException {
        out.println("public void clear()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flush();");
        out.print("String sql=\"");
        out.print("UPDATE ");
        out.print(this.getSourceType().getName());
        out.print(" SET ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", ownerType + ".this");
        out.println("query.executeUpdate();");
        out.println("super.clear();");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("} else {");
        out.println("  super.clear();");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateSize(JavaWriter out) throws IOException {
        out.println("public int size()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null || isValid())");
        out.println("  return super.size();");
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flush();");
        out.print("String sql=\"");
        out.print("SELECT count(*) FROM ");
        out.print(this.getSourceType().getName());
        out.print(" AS o ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", this.getSourceType().getName() + "__ResinExt.this", "index");
        out.println("java.sql.ResultSet rs = query.executeQuery();");
        out.println("if (rs.next())");
        out.println("  return rs.getInt(1);");
        out.println("else");
        out.println("  return 0;");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberAdd(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_add(Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"INSERT INTO ");
        out.print(this._associationTable.getName() + " (");
        out.print(this._sourceLink.generateSelectSQL(null));
        out.print(", ");
        out.print(this._targetLink.generateSelectSQL(null));
        out.print(") VALUES (");
        int count = this.getSourceType().getId().getKeyCount() + this.getTargetType().getId().getKeyCount();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("?");
        }
        out.println(")\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareInsertStatement(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "pstmt", "index", "this");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1) {");
        out.pushDepth();
        out.println("__caucho_session.addCompletion(new com.caucho.amber.entity.TableInvalidateCompletion(\"" + this._targetLink.getSourceTable().getName() + "\"));");
        out.println("return true;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemove(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_remove(Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(this._associationTable.getName() + " WHERE ");
        out.print(this._sourceLink.generateMatchArgSQL(null));
        out.print(" AND ");
        out.print(this._targetLink.generateMatchArgSQL(null));
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "pstmt", "index", "this");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1) {");
        out.pushDepth();
        out.println("__caucho_session.addCompletion(new com.caucho.amber.entity.TableInvalidateCompletion(\"" + this._targetLink.getSourceTable().getName() + "\"));");
        out.println("return true;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemoveTargetAll(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println("public boolean __amber_" + this.getGetterName() + "_remove_target(Object o)");
        out.println("{");
        out.pushDepth();
        out.println("if (! (o instanceof " + targetType + "))");
        out.println("  return false;");
        out.println();
        out.println(targetType + " v = (" + targetType + ") o;");
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(this._associationTable.getName() + " WHERE ");
        out.print(this._targetLink.generateMatchArgSQL(null));
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1)");
        out.println("  return true;");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateSetProperty(JavaWriter out) throws IOException {
        Method setter = this.getSetterMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        out.println();
        out.print("public void " + setter.getName() + "(");
        out.print(paramTypes[0].getName() + " value)");
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
    }

    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println("if (\"" + this._sourceLink.getSourceTable().getName() + "\".equals(table)) {");
        out.pushDepth();
        this.generateExpire(out);
        out.popDepth();
        out.println("}");
    }

    public void generateExpire(JavaWriter out) throws IOException {
        String var = "_caucho_" + this.getGetterName();
        out.println("if (" + var + " != null)");
        out.println("  " + var + ".update();");
    }
}

