/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.CollectionField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityOneToManyField
extends CollectionField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityOneToManyField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityOneToManyField"));
    private ArrayList<String> _orderByFields;
    private ArrayList<Boolean> _orderByAscending;
    private EntityManyToOneField _sourceField;

    public EntityOneToManyField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public EntityOneToManyField(EntityType entityType) {
        super(entityType);
    }

    public void setOrderBy(ArrayList<String> orderByFields, ArrayList<Boolean> orderByAscending) {
        this._orderByFields = orderByFields;
        this._orderByAscending = orderByAscending;
    }

    public EntityType getEntityTargetType() {
        return (EntityType)this.getTargetType();
    }

    @Override
    public Type getTargetType() {
        return this._sourceField.getSourceType();
    }

    public EntityManyToOneField getSourceField() {
        return this._sourceField;
    }

    public void setSourceField(EntityManyToOneField sourceField) {
        this._sourceField = sourceField;
    }

    @Override
    public LinkColumns getLinkColumns() {
        return this._sourceField.getLinkColumns();
    }

    @Override
    public void init() {
        if (this._sourceField == null || this.getLinkColumns() == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new OneToManyExpr(parser, parent, this.getLinkColumns());
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    @Override
    public String generateTargetSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        Id key = this.getEntityTargetType().getId();
        cb.append(key.generateSelect(id));
        String value = this.getEntityTargetType().generateLoadSelect(id);
        if (cb.length() > 0 && value.length() > 0) {
            cb.append(", ");
        }
        cb.append(value);
        return cb.close();
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        String var = new StringBuffer().append("_caucho_").append(this.getGetterName()).toString();
        boolean isSet = ClassLiteral.getClass((String)"java/util/Set").isAssignableFrom(this.getGetterMethod().getReturnType());
        if (isSet) {
            out.println(new StringBuffer().append("private com.caucho.amber.collection.SetImpl ").append(var).append(";").toString());
        } else {
            out.println(new StringBuffer().append("private com.caucho.amber.collection.CollectionImpl ").append(var).append(";").toString());
        }
        out.println();
        out.println(new StringBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.println(new StringBuffer().append("if (").append(var).append(" != null) {").toString());
        out.pushDepth();
        out.println(new StringBuffer().append(var).append(".setSession(__caucho_session);").toString());
        out.println(new StringBuffer().append("return ").append(var).append(";").toString());
        out.popDepth();
        out.println("}");
        out.println("if (__caucho_session == null) {");
        if (!this.isAbstract()) {
            out.println(new StringBuffer().append("  return super.").append(this.getGetterName()).append("();").toString());
        }
        out.println("}");
        out.println("try {");
        out.pushDepth();
        out.print("String sql=\"");
        out.print("SELECT c");
        out.print(new StringBuffer().append(" FROM ").append(this.getSourceType().getName()).append(" o,").toString());
        out.print(new StringBuffer().append("      o.").append(this.getName()).append(" c").toString());
        out.print(" WHERE ");
        out.print(this.getSourceType().getId().generateRawWhere("o"));
        if (this._orderByFields != null) {
            out.print(" ORDER BY ");
            for (int i = 0; i < this._orderByFields.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(new StringBuffer().append("c.").append(this._orderByFields.get(i)).toString());
                if (!Boolean.FALSE.equals(this._orderByAscending.get(i))) continue;
                out.print(" DESC");
            }
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", "this");
        if (isSet) {
            out.println(new StringBuffer().append(var).append(" = new com.caucho.amber.collection.SetImpl(query) {").toString());
        } else {
            out.println(new StringBuffer().append(var).append(" = new com.caucho.amber.collection.CollectionImpl(query) {").toString());
        }
        out.pushDepth();
        out.popDepth();
        out.println("};");
        out.println();
        out.println(new StringBuffer().append("return ").append(var).append(";").toString());
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateSize(JavaWriter out) throws IOException {
        out.println("public int size()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null || isValid())");
        out.println("  return super.size();");
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flush();");
        out.print("String sql=\"");
        out.print("SELECT count(*) FROM ");
        out.print(this.getSourceType().getName());
        out.print(" AS o ");
        out.print(" WHERE ");
        ArrayList<IdField> keys = this.getSourceType().getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                out.print(" AND ");
            }
            out.print(new StringBuffer().append("o.").append(keys.get(i).getName()).toString());
            out.print("=?");
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", new StringBuffer().append(this.getSourceType().getName()).append("__ResinExt.this").toString());
        out.println("java.sql.ResultSet rs = query.executeQuery();");
        out.println("if (rs.next())");
        out.println("  return rs.getInt(1);");
        out.println("else");
        out.println("  return 0;");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        Method setter = this.getSetterMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        out.println();
        out.print(new StringBuffer().append("public void ").append(setter.getName()).append("(").toString());
        out.print(new StringBuffer().append(paramTypes[0].getName()).append(" value)").toString());
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        Table table = this.getLinkColumns().getSourceTable();
        out.println(new StringBuffer().append("if (\"").append(table.getName()).append("\".equals(table)) {").toString());
        out.pushDepth();
        String var = new StringBuffer().append("_caucho_").append(this.getGetterName()).toString();
        out.println(new StringBuffer().append("if (").append(var).append(" != null)").toString());
        out.println(new StringBuffer().append("  ").append(var).append(".update();").toString());
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
        String var = new StringBuffer().append("_caucho_").append(this.getGetterName()).toString();
        out.println(new StringBuffer().append(var).append(" = null;").toString());
    }
}

