/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/Id"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/Id"));
    private EntityType _ownerType;
    private ArrayList<IdField> _keys = new ArrayList();
    private ArrayList<Column> _columns = new ArrayList();

    public Id(EntityType ownerType, ArrayList<IdField> keys) {
        this._ownerType = ownerType;
        for (IdField key : keys) {
            this.addKey(key);
        }
    }

    public Id(EntityType ownerType, IdField key) {
        this._ownerType = ownerType;
        this.addKey(key);
    }

    private void addKey(IdField key) {
        this._keys.add(key);
        this._columns.addAll(key.getColumns());
        for (Column column : key.getColumns()) {
            this._ownerType.getTable().addIdColumn(column);
        }
    }

    private static ArrayList<IdField> createField(IdField field) {
        ArrayList<IdField> fields = new ArrayList<IdField>();
        fields.add(field);
        return fields;
    }

    public EntityType getOwnerType() {
        return this._ownerType;
    }

    public ArrayList<Column> getColumns() {
        return this._columns;
    }

    public ArrayList<IdField> getKeys() {
        return this._keys;
    }

    public int getKeyCount() {
        return this._columns.size();
    }

    public IdField getKey() {
        return this._keys.get(0);
    }

    public String getForeignTypeName() {
        return this._keys.get(0).getForeignTypeName();
    }

    public void init() throws ConfigException {
    }

    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet, String name) throws IOException {
    }

    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        for (int i = 0; i < this._keys.size(); ++i) {
            this._keys.get(i).generatePrologue(out, completedSet);
        }
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        if (this._keys.size() > 1) {
            throw new UnsupportedOperationException();
        }
        return this._keys.get(0).generateLoadForeign(out, rs, indexVar, index, name);
    }

    public String generateSelect(String id) {
        return this.getKey().generateSelect(id);
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    public String generateGetProperty(String value) {
        return this.getKey().generateGet(value);
    }

    public String generateGetProxyKey(String value) {
        return new StringBuffer().append("((").append(this.getForeignTypeName()).append(") ").append(value).append(".getPrimaryKey())").toString();
    }

    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateLoadFromObject(out, obj);
        }
    }

    public void generateSet(JavaWriter out, String obj) throws IOException {
        IdField key = this.getKey();
        key.generateSet(out, key.toValue(obj));
    }

    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateUpdateFromObject(out, obj);
        }
    }

    public String generateMatchArgWhere(String id) {
        CharBuffer cb = new CharBuffer();
        boolean isFirst = true;
        for (IdField field : this.getKeys()) {
            for (Column column : field.getColumns()) {
                if (!isFirst) {
                    cb.append(" AND ");
                }
                isFirst = false;
                cb.append(column.generateMatchArgWhere(id));
            }
        }
        return cb.toString();
    }

    public String generateRawWhere(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(keys.get(i).generateRawWhere(id));
        }
        return cb.close();
    }

    public String generateCreateTableSQL(AmberManager manager) {
        String sql = this.getKey().generateCreateTableSQL(manager);
        if (this.getKey().getGenerator() != null) {
            return new StringBuffer().append(sql).append(" PRIMARY KEY auto_increment").toString();
        }
        return new StringBuffer().append(sql).append(" PRIMARY KEY").toString();
    }

    public void generateSetKey(JavaWriter out, String pstmt, String index, String keyObject) throws IOException {
        IdField key = this.getKey();
        key.getType().generateSet(out, pstmt, index, keyObject);
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSet(out, pstmt, index, value);
        }
    }

    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSet(out, pstmt, index);
        }
    }

    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSetInsert(out, pstmt, index);
        }
    }

    public String generateCastFromObject(String value) {
        return value;
    }

    public void generateMatch(JavaWriter out, String key) throws IOException {
        IdField id = this.getKeys().get(0);
        out.println(new StringBuffer().append("return (").append(id.generateEquals(id.generateSuperGetter(), id.toValue(key))).append(");").toString());
    }

    public String generateEquals(String leftBase, String value) {
        ArrayList<IdField> keys = this.getKeys();
        String eq = "(";
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            if (i != 0) {
                eq = new StringBuffer().append(eq).append(" && ").toString();
            }
            eq = new StringBuffer().append(eq).append(key.generateEquals(leftBase, value)).toString();
        }
        return new StringBuffer().append(eq).append(")").toString();
    }

    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateCheckCreateKey(out);
        }
    }

    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSetGeneratedKeys(out, pstmt);
        }
    }

    public String toObject(String value) {
        return this.getKey().toObject(value);
    }

    public Object toObjectKey(long value) {
        return new Long(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return null;
    }
}

