/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ColumnExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyField
extends AbstractField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/PropertyField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/PropertyField"));
    private Column _column;
    private Type _type;
    private KeyManyToOneField _aliasKey;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;

    public PropertyField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public PropertyField(EntityType entityType) {
        super(entityType);
    }

    public void setType(Type type) {
        this._type = type;
    }

    public Type getType() {
        return this._type;
    }

    @Override
    public Table getTable() {
        return this.getColumn().getTable();
    }

    public void setColumn(Column column) {
        this._column = column;
    }

    public Column getColumn() {
        return this._column;
    }

    public void setInsert(boolean isInsert) {
        this._isInsert = isInsert;
    }

    public void setUpdate(boolean isUpdate) {
        this._isUpdate = isUpdate;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        if (this.getColumn() == null) {
            throw new IllegalStateException(L.l("column must be set before init"));
        }
        if (this.getSourceType().getId() != null) {
            for (IdField field : this.getSourceType().getId().getKeys()) {
                if (!(field instanceof KeyManyToOneField)) continue;
                KeyManyToOneField key = (KeyManyToOneField)field;
                for (ForeignColumn column : key.getLinkColumns().getColumns()) {
                    if (!this.getColumn().getName().equals(column.getName())) continue;
                    this._aliasKey = key;
                }
            }
        }
    }

    @Override
    public String generateNull() {
        return this.getType().generateNull();
    }

    @Override
    protected String getFieldName() {
        return this.getColumn().getFieldName();
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
        out.println();
        out.println(new StringBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null)");
        out.println(new StringBuffer().append("  __caucho_load_").append(this.getLoadGroupIndex()).append("(__caucho_session);").toString());
        out.println();
        out.println(new StringBuffer().append("return ").append(this.generateSuperGetter()).append(";").toString());
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && (this.getGetterMethod() == null || this.getSetterMethod() == null && !this.isAbstract())) {
            return;
        }
        out.println();
        out.println(new StringBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        if (!this._isUpdate) {
            out.println("if (__caucho_session == null)");
            out.println(new StringBuffer().append("  ").append(this.generateSuperSetter("v")).append(";").toString());
        } else {
            out.println(new StringBuffer().append(this.getJavaTypeName()).append(" oldValue = ").append(this.generateSuperGetter()).append(";").toString());
            long mask = 1L << this.getLoadGroupIndex();
            if (this.getJavaTypeName().equals("java.lang.String")) {
                out.println(new StringBuffer().append("if ((oldValue == v || v != null && v.equals(oldValue)) && (__caucho_loadMask & ").append(mask).append("L) != 0L)").toString());
                out.println("  return;");
            } else {
                out.println(new StringBuffer().append("if (oldValue == v && (__caucho_loadMask & ").append(mask).append("L) != 0)").toString());
                out.println("  return;");
            }
            out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
            out.println();
            out.println("long oldMask = __caucho_dirtyMask;");
            out.println(new StringBuffer().append("__caucho_dirtyMask |= ").append(1L << this.getIndex()).append("L;").toString());
            out.println();
            out.println("if (__caucho_session != null && oldMask == 0)");
            out.println("  __caucho_session.update(this);");
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        if (this.getColumn().getTable() != table) {
            return null;
        }
        return this.generateSelect(id);
    }

    @Override
    public String generateSelect(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public String generateWhere(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert && this._aliasKey == null) {
            columns.add(this.getColumn().getName());
        }
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._isUpdate && this._aliasKey == null) {
            sql.append(this.getColumn().generateUpdateSet());
        }
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._aliasKey == null) {
            if (this._isInsert) {
                this.generateSet(out, pstmt, index, obj);
            } else if (this.getLoadGroupIndex() != 0) {
                out.println(new StringBuffer().append("__caucho_loadMask &= ~").append(1L << this.getLoadGroupIndex()).append("L;").toString());
            }
        }
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._isUpdate && this._aliasKey == null) {
            this.generateSet(out, pstmt, index, obj);
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null || this._aliasKey != null) {
            return;
        }
        this.getColumn().generateSet(out, pstmt, index, this.generateGet(obj));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._aliasKey != null) {
            return index;
        }
        String var = new StringBuffer().append("amber_ld").append(index).toString();
        out.print(this.getJavaTypeName());
        out.print(new StringBuffer().append(" ").append(var).append(" = ").toString());
        index = this.getColumn().generateLoad(out, rs, indexVar, index);
        out.println(";");
        out.println(new StringBuffer().append(this.generateSuperSetter(var)).append(";").toString());
        return index;
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ColumnExpr(parent, this.getColumn());
    }
}

