/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;

public class LoadGroupGenerator
extends ClassComponent {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/gen/LoadGroupGenerator"));
    private String _extClassName;
    private EntityType _entityType;
    private int _index;

    public LoadGroupGenerator(String extClassName, EntityType entityType, int index) {
        this._extClassName = extClassName;
        this._entityType = entityType;
        this._index = index;
    }

    public void generate(JavaWriter out) throws IOException {
        out.println();
        out.println("protected void __caucho_load_" + this._index + "(com.caucho.amber.connection.AmberConnectionImpl aConn)");
        out.println("{");
        out.pushDepth();
        long mask = 1L << this._index;
        out.println("if (aConn.isInTransaction()) {");
        out.println("  if (com.caucho.amber.entity.Entity.P_DELETING <= __caucho_state) {");
        out.println("    return;");
        out.println("  }");
        out.println("  else if (__caucho_state < com.caucho.amber.entity.Entity.P_TRANSACTIONAL) {");
        out.println("    __caucho_state = com.caucho.amber.entity.Entity.P_TRANSACTIONAL;");
        out.println("    __caucho_loadMask = 0;");
        out.println("    __caucho_dirtyMask = 0;");
        out.println("    aConn.makeTransactional(this);");
        out.println("  }");
        out.println("  else if ((__caucho_loadMask & " + mask + "L) != 0)");
        out.println("    return;");
        out.println("}");
        out.println("else if ((__caucho_loadMask & " + mask + "L) != 0)");
        out.println("  return;");
        out.println("else if (__caucho_item != null) {");
        out.pushDepth();
        out.println(this._extClassName + " item = (" + this._extClassName + ") __caucho_item.getEntity();");
        out.println("item.__caucho_load_" + this._index + "(aConn);");
        this._entityType.generateCopyLoadObject(out, "super", "item", this._index);
        out.println("__caucho_loadMask |= " + mask + "L;");
        out.println();
        out.println("return;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("try {");
        out.pushDepth();
        Table table = this._entityType.getTable();
        String from = null;
        String select = null;
        String where = null;
        String subSelect = this._entityType.generateLoadSelect(table, "o", this._index);
        Table mainTable = null;
        String tableName = null;
        if (subSelect != null) {
            select = subSelect;
            from = table.getName() + " o";
            where = this._entityType.getId().generateMatchArgWhere("o");
            mainTable = table;
            tableName = "o";
        }
        ArrayList<Table> subTables = this._entityType.getSecondaryTables();
        for (int i = 0; i < subTables.size(); ++i) {
            Table subTable = subTables.get(i);
            subSelect = this._entityType.generateLoadSelect(subTable, "o" + i, this._index);
            if (subSelect == null) continue;
            select = select != null ? select + ", " + subSelect : subSelect;
            from = from != null ? from + ", " + subTable.getName() + " o" + i : subTable.getName() + " o" + i;
            if (where != null) {
                LinkColumns link = subTable.getDependentIdLink();
                where = where + " AND " + link.generateJoin("o" + i, "o");
                continue;
            }
            throw new IllegalStateException();
        }
        if (select == null) {
            select = "1";
        }
        if (where == null) {
            from = table.getName() + " o";
            where = this._entityType.getId().generateMatchArgWhere("o");
        }
        String sql = "SELECT " + select + " FROM " + from + " WHERE " + where;
        out.println("String sql = \"" + sql + "\";");
        out.println();
        out.println("java.sql.PreparedStatement pstmt = aConn.prepareStatement(sql);");
        out.println("int index = 1;");
        this._entityType.getId().generateSet(out, "pstmt", "index", "super");
        out.println();
        out.println("java.sql.ResultSet rs = pstmt.executeQuery();");
        out.println("if (rs.next()) {");
        out.pushDepth();
        this._entityType.generateLoad(out, "rs", "", 1, this._index);
        out.println("__caucho_loadMask |= " + mask + "L;");
        if (this._entityType.getHasLoadCallback()) {
            out.println("__caucho_load_callback();");
        }
        out.popDepth();
        out.println("}");
        out.println("else {");
        out.println("  rs.close();");
        String errorString = "(\"amber load: no matching object " + this._entityType.getName() + "[\" + __caucho_getPrimaryKey() + \"]\")";
        out.println("  throw new com.caucho.amber.AmberObjectNotFoundException(" + errorString + ");");
        out.println("}");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        if (this._index == 0 && this._entityType.getHasLoadCallback()) {
            out.println();
            out.println("protected void __caucho_load_callback() {}");
        }
    }
}

