/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.query.ArgExpr;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.ManyToOneJoinExpr;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery {
    private String _sql;
    protected ArrayList<FromItem> _fromList = new ArrayList();
    private ArgExpr[] _argList;

    public abstract String getSQL();

    abstract void registerUpdates(CachedQuery var1);

    AbstractQuery(String sql) {
        this._sql = sql;
    }

    public String getQueryString() {
        return this._sql;
    }

    FromItem createFromItem(Table table, String name) {
        FromItem item = new FromItem(table, name, this._fromList.size());
        item.setQuery(this);
        this._fromList.add(item);
        return item;
    }

    FromItem createDependentFromItem(FromItem parent, LinkColumns link, String name) {
        JoinExpr join;
        for (int i = 0; i < this._fromList.size(); ++i) {
            join = this._fromList.get(i).getJoinExpr();
            if (join == null || !join.isDependent(parent, link)) continue;
            return this._fromList.get(i);
        }
        FromItem item = this.createFromItem(link.getSourceTable(), name);
        join = new ManyToOneJoinExpr(link, item, parent);
        item.setJoinExpr(join);
        return item;
    }

    ArrayList<FromItem> getFromList() {
        return this._fromList;
    }

    AbstractQuery getParentQuery() {
        return null;
    }

    void setArgList(ArgExpr[] argList) {
        this._argList = argList;
    }

    ArgExpr[] getArgList() {
        return this._argList;
    }

    public long getCacheMaxAge() {
        return -1L;
    }

    public void prepare(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
    }

    public void complete(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
    }
}

