/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.query.SelectQuery;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetImpl
implements ResultSet {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/query/ResultSetImpl"));
    private UserQuery _userQuery;
    private ResultSet _rs;
    private ArrayList<FromItem> _fromList;
    private ArrayList<AmberExpr> _resultList;
    private AmberConnectionImpl _session;
    private QueryCacheKey _cacheKey;
    private ResultSetCacheChunk _cacheChunk;
    private boolean _isCache;
    private int _firstResult;
    private int _maxResults = 0x3FFFFFFF;
    private int _row;

    public void setUserQuery(UserQuery userQuery) {
        this._userQuery = userQuery;
    }

    public void setResultSet(ResultSet rs) {
        this._rs = rs;
    }

    public void setQuery(SelectQuery query) {
        this._fromList = query.getFromList();
        this._resultList = query.getResultList();
    }

    public void setSession(AmberConnectionImpl aConn) {
        this._session = aConn;
    }

    public void setCacheChunk(ResultSetCacheChunk cacheChunk) {
        this._cacheChunk = cacheChunk;
        this._isCache = true;
    }

    public void setFirstResult(int first) {
        this._firstResult = first;
    }

    public void setMaxResults(int max) {
        this._maxResults = max < 0 ? 0x3FFFFFFF : max;
    }

    public void fillCacheChunk(ResultSetCacheChunk cacheChunk) throws SQLException {
        int size = 25;
        for (int i = 0; i < size; ++i) {
            if (this._rs.next()) {
                cacheChunk.newRow();
                int len = this._resultList.size();
                for (int j = 0; j < len; ++j) {
                    int index = this.getColumn(j + 1);
                    AmberExpr expr = this._resultList.get(j);
                    cacheChunk.setValue(i, j, expr.getCacheObject(this._session, this._rs, index));
                }
                continue;
            }
            cacheChunk.setLast(true);
            return;
        }
        if (!this._rs.next()) {
            cacheChunk.setLast(true);
        }
    }

    public void init() throws SQLException {
        this._row = 0;
        while (this._row < this._firstResult && this.next()) {
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this._rs.getRow();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._rs.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this._rs.isLast();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._rs.isAfterLast();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._rs.getStatement();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._rs.getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._rs.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this._rs.getCursorName();
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this._rs.setFetchSize(size);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._rs.getFetchSize();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._rs.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int dir) throws SQLException {
        this._rs.setFetchDirection(dir);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._rs.getConcurrency();
    }

    @Override
    public boolean next() throws SQLException {
        if (this._firstResult + this._maxResults <= this._row) {
            return false;
        }
        int row = this._row++;
        ResultSetCacheChunk cacheChunk = this._cacheChunk;
        if (cacheChunk == null) {
            return this._rs.next();
        }
        if (row < cacheChunk.getRowCount()) {
            return true;
        }
        this._isCache = false;
        this._cacheChunk = null;
        if (cacheChunk.isLast()) {
            this._maxResults = 0;
            return false;
        }
        if (this._rs != null) {
            return true;
        }
        if (this._userQuery != null) {
            this._rs = this._userQuery.executeQuery(row, -1);
            return this._rs.next();
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this._row <= this._firstResult) {
            return false;
        }
        --this._row;
        return this._rs.previous();
    }

    @Override
    public boolean relative(int delta) throws SQLException {
        return this._rs.relative(delta);
    }

    @Override
    public boolean absolute(int delta) throws SQLException {
        return this._rs.absolute(delta);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._rs.beforeFirst();
    }

    @Override
    public boolean first() throws SQLException {
        return this._rs.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this._rs.last();
    }

    @Override
    public void afterLast() throws SQLException {
        this._rs.afterLast();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._rs.wasNull();
    }

    @Override
    public int getType() throws SQLException {
        return this._rs.getType();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String column) throws SQLException {
        return this._rs.getBoolean(this.getColumn(column));
    }

    @Override
    public boolean getBoolean(int column) throws SQLException {
        return this._rs.getBoolean(this.getColumn(column));
    }

    @Override
    public byte getByte(String column) throws SQLException {
        return this._rs.getByte(this.getColumn(column));
    }

    @Override
    public byte getByte(int column) throws SQLException {
        return this._rs.getByte(this.getColumn(column));
    }

    @Override
    public short getShort(String column) throws SQLException {
        return this._rs.getShort(this.getColumn(column));
    }

    @Override
    public short getShort(int column) throws SQLException {
        return this._rs.getShort(this.getColumn(column));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        int column = this.getColumn(columnName);
        if (this._cacheChunk != null) {
            return this._cacheChunk.getInt(this._row - 1, column - 1);
        }
        return this._rs.getInt(column);
    }

    @Override
    public int getInt(int column) throws SQLException {
        if (this._cacheChunk != null) {
            return this._cacheChunk.getInt(this._row - 1, column - 1);
        }
        return this._rs.getInt(column);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        int column = this.getColumn(columnName);
        if (this._cacheChunk != null) {
            return this._cacheChunk.getLong(this._row - 1, column - 1);
        }
        return this._rs.getLong(column);
    }

    @Override
    public long getLong(int column) throws SQLException {
        if (this._cacheChunk != null) {
            return this._cacheChunk.getLong(this._row - 1, column - 1);
        }
        return this._rs.getLong(column);
    }

    @Override
    public float getFloat(String column) throws SQLException {
        return this._rs.getFloat(this.getColumn(column));
    }

    @Override
    public float getFloat(int column) throws SQLException {
        return this._rs.getFloat(this.getColumn(column));
    }

    @Override
    public double getDouble(String column) throws SQLException {
        return this._rs.getDouble(this.getColumn(column));
    }

    @Override
    public double getDouble(int column) throws SQLException {
        return this._rs.getDouble(this.getColumn(column));
    }

    @Override
    public String getString(int column) throws SQLException {
        return this._rs.getString(this.getColumn(column));
    }

    @Override
    public String getString(String column) throws SQLException {
        return this._rs.getString(this.getColumn(column));
    }

    @Override
    public byte[] getBytes(int column) throws SQLException {
        return this._rs.getBytes(this.getColumn(column));
    }

    @Override
    public byte[] getBytes(String column) throws SQLException {
        return this._rs.getBytes(this.getColumn(column));
    }

    @Override
    public Date getDate(int column) throws SQLException {
        return this._rs.getDate(this.getColumn(column));
    }

    @Override
    public Date getDate(String column) throws SQLException {
        return this._rs.getDate(this.getColumn(column));
    }

    @Override
    public Date getDate(int column, Calendar cal) throws SQLException {
        return this._rs.getDate(this.getColumn(column), cal);
    }

    @Override
    public Date getDate(String column, Calendar cal) throws SQLException {
        return this._rs.getDate(this.getColumn(column), cal);
    }

    @Override
    public Time getTime(int column) throws SQLException {
        return this._rs.getTime(this.getColumn(column));
    }

    @Override
    public Time getTime(String column) throws SQLException {
        return this._rs.getTime(this.getColumn(column));
    }

    @Override
    public Time getTime(int column, Calendar cal) throws SQLException {
        return this._rs.getTime(this.getColumn(column), cal);
    }

    @Override
    public Time getTime(String column, Calendar cal) throws SQLException {
        return this._rs.getTime(this.getColumn(column), cal);
    }

    @Override
    public Timestamp getTimestamp(int column) throws SQLException {
        return this._rs.getTimestamp(this.getColumn(column));
    }

    @Override
    public Timestamp getTimestamp(String column) throws SQLException {
        return this._rs.getTimestamp(this.getColumn(column));
    }

    @Override
    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        return this._rs.getTimestamp(this.getColumn(column), cal);
    }

    @Override
    public Timestamp getTimestamp(String column, Calendar cal) throws SQLException {
        return this._rs.getTimestamp(this.getColumn(column), cal);
    }

    @Override
    public Ref getRef(int column) throws SQLException {
        return this._rs.getRef(this.getColumn(column));
    }

    @Override
    public Ref getRef(String column) throws SQLException {
        return this._rs.getRef(this.getColumn(column));
    }

    @Override
    public Clob getClob(int column) throws SQLException {
        return this._rs.getClob(this.getColumn(column));
    }

    @Override
    public Clob getClob(String column) throws SQLException {
        return this._rs.getClob(this.getColumn(column));
    }

    @Override
    public Blob getBlob(int column) throws SQLException {
        return this._rs.getBlob(this.getColumn(column));
    }

    @Override
    public Blob getBlob(String column) throws SQLException {
        return this._rs.getBlob(this.getColumn(column));
    }

    @Override
    public Reader getCharacterStream(int column) throws SQLException {
        return this._rs.getCharacterStream(this.getColumn(column));
    }

    @Override
    public Reader getCharacterStream(String column) throws SQLException {
        return this._rs.getCharacterStream(this.getColumn(column));
    }

    @Override
    public InputStream getBinaryStream(int column) throws SQLException {
        return this._rs.getBinaryStream(this.getColumn(column));
    }

    @Override
    public InputStream getBinaryStream(String column) throws SQLException {
        return this._rs.getBinaryStream(this.getColumn(column));
    }

    @Override
    public InputStream getAsciiStream(int column) throws SQLException {
        return this._rs.getAsciiStream(this.getColumn(column));
    }

    @Override
    public InputStream getAsciiStream(String column) throws SQLException {
        return this._rs.getAsciiStream(this.getColumn(column));
    }

    @Override
    public InputStream getUnicodeStream(int column) throws SQLException {
        return this._rs.getUnicodeStream(this.getColumn(column));
    }

    @Override
    public InputStream getUnicodeStream(String column) throws SQLException {
        return this._rs.getUnicodeStream(this.getColumn(column));
    }

    @Override
    public Array getArray(int column) throws SQLException {
        return this._rs.getArray(this.getColumn(column));
    }

    @Override
    public Array getArray(String column) throws SQLException {
        return this._rs.getArray(this.getColumn(column));
    }

    @Override
    public URL getURL(int column) throws SQLException {
        return this._rs.getURL(this.getColumn(column));
    }

    @Override
    public URL getURL(String column) throws SQLException {
        return this._rs.getURL(this.getColumn(column));
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws SQLException {
        return this._rs.getBigDecimal(this.getColumn(column));
    }

    @Override
    public BigDecimal getBigDecimal(String column) throws SQLException {
        return this._rs.getBigDecimal(this.getColumn(column));
    }

    @Override
    public BigDecimal getBigDecimal(int column, int digit) throws SQLException {
        return this._rs.getBigDecimal(this.getColumn(column), digit);
    }

    @Override
    public BigDecimal getBigDecimal(String column, int digit) throws SQLException {
        return this._rs.getBigDecimal(this.getColumn(column), digit);
    }

    @Override
    public Object getObject(int column) throws SQLException {
        ResultSetCacheChunk cacheChunk = this._cacheChunk;
        if (cacheChunk != null) {
            Object obj = cacheChunk.getObject(this._row - 1, column - 1);
            if (obj instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)obj;
                Entity entity = entityItem.getEntity();
                Object value = this._session.loadProxy(entity.__caucho_getEntityType(), entity.__caucho_getPrimaryKey());
                return value;
            }
            return obj;
        }
        int index = this.getColumn(column);
        AmberExpr expr = this._resultList.get(column - 1);
        Object value = expr.getObject(this._session, this._rs, index);
        return value;
    }

    public EntityItem findEntityItem(int column) throws SQLException {
        ResultSetCacheChunk cacheChunk = this._cacheChunk;
        if (cacheChunk != null) {
            Object obj = cacheChunk.getObject(this._row - 1, column - 1);
            if (obj instanceof EntityItem) {
                return (EntityItem)obj;
            }
            throw new SQLException(L.l("'{0}' is an unexpected type.", obj));
        }
        int index = this.getColumn(column);
        AmberExpr expr = this._resultList.get(column - 1);
        EntityItem item = expr.findItem(this._session, this._rs, index);
        return item;
    }

    @Override
    public Object getObject(String column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getKey(int column) throws SQLException {
        int index = this.getColumn(column);
        FromItem item = this._fromList.get(column - 1);
        AmberEntityHome home = item.getEntityHome();
        Object key = home.getEntityType().getId().getObject(this._rs, index);
        return key;
    }

    @Override
    public Object getObject(int column, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String column, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String column, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int column, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String column, Object value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int column, Object value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String column, Object value, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int column, Object value, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String column, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int column, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String column, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int column, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String column, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int column, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String column, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int column, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String column, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int column, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String column, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int column, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String column, BigDecimal decimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int column, BigDecimal decimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String column, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int column, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String column, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateUnicodeStream(String column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateUnicodeStream(int column, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String column, byte[] value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int column, byte[] value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String column, boolean value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int column, boolean value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String column, byte value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int column, byte value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String column, short value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int column, short value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String column, int value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int column, int value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String column, long value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int column, long value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String column, float value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int column, float value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String column, double value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int column, double value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    private int getColumn(String name) {
        throw new UnsupportedOperationException();
    }

    private int getColumn(int index) {
        return index;
    }

    @Override
    public void close() throws SQLException {
        ResultSet rs = this._rs;
        this._rs = null;
        if (rs != null) {
            rs.close();
        }
    }
}

