/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.TableCacheUpdate;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateQuery
extends AbstractQuery {
    private ArrayList<String> _fieldList;
    private ArrayList<AmberExpr> _valueList;
    private AmberExpr _where;
    private String _sql;

    UpdateQuery(String query) {
        super(query);
    }

    void setFieldList(ArrayList<String> fieldList) {
        this._fieldList = fieldList;
    }

    public ArrayList<String> getFieldList() {
        return this._fieldList;
    }

    void setValueList(ArrayList<AmberExpr> exprList) {
        this._valueList = exprList;
    }

    public ArrayList<AmberExpr> getValueList() {
        return this._valueList;
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    @Override
    public String getSQL() {
        return this._sql;
    }

    void init() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("UPDATE ");
        FromItem item = (FromItem)this._fromList.get(0);
        cb.append(item.getTable().getName());
        cb.append(" SET ");
        for (int i = 0; i < this._fieldList.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._fieldList.get(i));
            cb.append("=");
            this._valueList.get(i).generateWhere(cb);
        }
        if (this._where != null) {
            cb.append(" WHERE ");
            this._where.generateWhere(cb);
        }
        this._sql = cb.close();
    }

    @Override
    void registerUpdates(CachedQuery query) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem item = (FromItem)this._fromList.get(i);
            AmberEntityHome home = item.getEntityHome();
            TableCacheUpdate update = new TableCacheUpdate(query);
            home.addUpdate(update);
        }
    }

    @Override
    public void prepare(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
        aConn.flush();
    }

    @Override
    public void complete(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
        aConn.expire();
        FromItem item = (FromItem)this._fromList.get(0);
        aConn.addCompletion(new TableInvalidateCompletion(item.getEntityType().getTable().getName()));
    }

    public String toString() {
        return new StringBuffer().append("UpdateQuery[").append(this.getQueryString()).append("]").toString();
    }
}

