/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.ByteType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveByteType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveByteType"));
    private static final PrimitiveByteType BYTE_TYPE = new PrimitiveByteType();

    private PrimitiveByteType() {
    }

    public static PrimitiveByteType create() {
        return BYTE_TYPE;
    }

    public String getName() {
        return "byte";
    }

    public Type getForeignType() {
        return ByteType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(-6, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getByte(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setByte(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
    }

    public String toObject(String value) {
        return "new Byte(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").byteValue()";
    }
}

