/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.CharacterType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveCharType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveCharType"));
    private static final PrimitiveCharType CHAR_TYPE = new PrimitiveCharType();

    private PrimitiveCharType() {
    }

    public static PrimitiveCharType create() {
        return CHAR_TYPE;
    }

    public String getName() {
        return "char";
    }

    public Type getForeignType() {
        return CharacterType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(1, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveCharType.toChar(" + rs + ".getString(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setString(" + index + "++, String.valueOf(" + value + "));");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
    }

    public String toObject(String value) {
        return "new Character(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Character) " + value + ").charValue()";
    }

    public static char toChar(String value) {
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        return value.charAt(0);
    }
}

